/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.type;

import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.attribute.type.IntegerAttribute;
import com.tplink.cdd.radius.common.attribute.type.IpAttribute;
import com.tplink.cdd.radius.common.attribute.type.Ipv6PrefixAttribute;
import com.tplink.cdd.radius.common.attribute.type.LongAttribute;
import com.tplink.cdd.radius.common.attribute.type.OctetsAttribute;
import com.tplink.cdd.radius.common.attribute.type.StringAttribute;
import com.tplink.cdd.radius.common.attribute.type.VendorSpecificAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.dictionary.Vendor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum AttributeType {
    VSA(VendorSpecificAttribute::new, (d, v, t, s) -> OctetsAttribute.stringHexParser(s)),
    OCTETS(OctetsAttribute::new, (d, v, t, s) -> OctetsAttribute.stringHexParser(s)),
    STRING(StringAttribute::new, (d, v, t, s) -> StringAttribute.stringParser(s)),
    INTEGER(IntegerAttribute::new, IntegerAttribute::stringParser),
    LONG(LongAttribute::new, LongAttribute::stringParser),
    IPV4(IpAttribute.V4::new, (d, v, t, s) -> IpAttribute.stringParser(s)),
    IPV6(IpAttribute.V6::new, (d, v, t, s) -> IpAttribute.stringParser(s)),
    IPV6_PREFIX(Ipv6PrefixAttribute::new, (d, v, t, s) -> Ipv6PrefixAttribute.stringParser(s));

    private static final Logger logger;
    private final Constructor constructor;
    private final StringParser stringParser;

    private AttributeType(Constructor constructor, StringParser stringParser) {
        this.constructor = constructor;
        this.stringParser = stringParser;
    }

    public OctetsAttribute create(Dictionary dictionary, int vendorId, ByteBuf data) {
        try {
            OctetsAttribute attribute = this.constructor.newInstance(dictionary, vendorId, data);
            logger.trace("Created RadiusAttribute: vendorId: {}, type: {}", (Object)attribute.getVendorId(), (Object)attribute.getType());
            return attribute;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create attribute - vendorId: " + vendorId + ", bytes: 0x" + DatatypeConverter.printHexBinary((byte[])data.copy().array()), e);
        }
    }

    public OctetsAttribute create(Dictionary dictionary, int vendorId, int type, byte tag, byte[] value) {
        Optional<Vendor> vendor = dictionary.getVendor(vendorId);
        int headerSize = vendor.map(Vendor::getHeaderSize).orElse(2);
        byte[] tagBytes = AttributeType.toTagBytes(dictionary, vendorId, type, tag);
        int length = headerSize + tagBytes.length + value.length;
        byte[] typeBytes = vendor.map(v -> v.toTypeBytes(type)).orElse(new byte[]{(byte)type});
        byte[] lengthBytes = vendor.map(v -> v.toLengthBytes(length)).orElse(new byte[]{(byte)length});
        return this.create(dictionary, vendorId, Unpooled.wrappedBuffer((byte[][])new byte[][]{typeBytes, lengthBytes, tagBytes, value}));
    }

    private static byte[] toTagBytes(Dictionary dictionary, int vendorId, int type, byte tag) {
        return dictionary.getAttributeTemplate(vendorId, type).filter(AttributeTemplate::isTagged).map(x -> new byte[]{tag}).orElse(new byte[0]);
    }

    public OctetsAttribute create(Dictionary dictionary, int vendorId, int type, byte tag, String value) {
        byte[] bytes = this.stringParser.parse(dictionary, vendorId, type, value);
        return this.create(dictionary, vendorId, type, tag, bytes);
    }

    public static AttributeType fromDataType(String dataType) {
        switch (dataType) {
            case "vsa": {
                return VSA;
            }
            case "string": {
                return STRING;
            }
            case "integer": 
            case "date": {
                return INTEGER;
            }
            case "long": {
                return LONG;
            }
            case "ipaddr": {
                return IPV4;
            }
            case "ipv6addr": {
                return IPV6;
            }
            case "ipv6prefix": {
                return IPV6_PREFIX;
            }
        }
        return OCTETS;
    }

    static {
        logger = LogManager.getLogger();
    }

    private static interface StringParser {
        public byte[] parse(Dictionary var1, int var2, int var3, String var4);
    }

    private static interface Constructor {
        public OctetsAttribute newInstance(Dictionary var1, int var2, ByteBuf var3);
    }
}

