/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.type;

import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import io.netty.buffer.ByteBuf;
import java.util.Optional;

public class AnonSubAttribute
implements RadiusAttribute {
    private final Dictionary dictionary;
    private final ByteBuf data;
    private final int vendorId;

    public AnonSubAttribute(Dictionary dictionary, int vendorId, ByteBuf data) {
        this.dictionary = dictionary;
        this.vendorId = vendorId;
        this.data = data;
        if (vendorId == -1) {
            throw new IllegalArgumentException("Undistinguished sub-attribute vendorId should not be -1, actual: " + vendorId);
        }
    }

    @Override
    public int getVendorId() {
        return this.vendorId;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public Optional<Byte> getTag() {
        return Optional.empty();
    }

    @Override
    public byte[] getValue() {
        return this.data.copy().array();
    }

    @Override
    public String getValueString() {
        return "[Unparsable sub-attribute (vendorId " + this.vendorId + ", length " + this.data.readableBytes() + ")]";
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public ByteBuf getData() {
        return this.data;
    }

    public String toString() {
        return this.getValueString();
    }
}

