/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.codec;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.codec.BaseCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.Arrays;

class UserPasswordCodec
extends BaseCodec {
    UserPasswordCodec() {
    }

    @Override
    protected byte[] encodeData(byte[] data, byte[] auth, byte[] secret) {
        byte[] str = UserPasswordCodec.pad16x(data);
        ByteBuffer buffer = ByteBuffer.allocate(str.length);
        byte[] c = auth;
        for (int i = 0; i < str.length; i += 16) {
            c = UserPasswordCodec.xor16(str, i, this.md5(secret, c));
            buffer.put(c);
        }
        return buffer.array();
    }

    @Override
    protected byte[] decodeData(byte[] encodedData, byte[] auth, byte[] secret) throws RadiusPacketException {
        if (encodedData.length < 16) {
            throw new RadiusPacketException("Malformed attribute while decoding with RFC2865 User-Password method - data must be at least 16 octets, actual: " + encodedData.length);
        }
        if (encodedData.length % 16 != 0) {
            throw new RadiusPacketException("Malformed attribute while decoding with RFC2865 User-Password method - data octets must be multiple of 16, actual: " + encodedData.length);
        }
        ByteBuf buf = Unpooled.buffer((int)encodedData.length, (int)encodedData.length);
        byte[] c = auth;
        for (int i = 0; i < encodedData.length; i += 16) {
            buf.writeBytes(UserPasswordCodec.xor16(encodedData, i, this.md5(secret, c)));
            c = Arrays.copyOfRange(encodedData, i, i + 16);
        }
        for (int nullIndex = encodedData.length - 1; nullIndex > 0; --nullIndex) {
            if (buf.getByte(nullIndex) == 0) continue;
            return buf.writerIndex(nullIndex + 1).copy().array();
        }
        return buf.copy().array();
    }
}

