/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.codec;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.codec.BaseCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;

class TunnelPasswordCodec
extends BaseCodec {
    private static final SecureRandom RANDOM = new SecureRandom();

    TunnelPasswordCodec() {
    }

    @Override
    protected byte[] encodeData(byte[] data, byte[] auth, byte[] secret) {
        byte[] salt = TunnelPasswordCodec.genSalt();
        byte[] combined = ByteBuffer.allocate(data.length + 1).put((byte)data.length).put(data).array();
        byte[] plaintext = TunnelPasswordCodec.pad16x(combined);
        ByteBuffer buffer = ByteBuffer.allocate(plaintext.length + 2).put(salt);
        byte[] c = ByteBuffer.allocate(18).put(auth).put(salt).array();
        for (int i = 0; i < plaintext.length; i += 16) {
            c = TunnelPasswordCodec.xor16(plaintext, i, this.md5(secret, c));
            buffer.put(c);
        }
        return buffer.array();
    }

    @Override
    protected byte[] decodeData(byte[] encodedData, byte[] auth, byte[] secret) throws RadiusPacketException {
        int strLen = encodedData.length - 2;
        if (strLen < 16) {
            throw new RadiusPacketException("Malformed attribute while decoding with RFC2868 Tunnel-Password method - string must be at least 16 octets, actual: " + strLen);
        }
        if (strLen % 16 != 0) {
            throw new RadiusPacketException("Malformed attribute while decoding with RFC2865 Tunnel-Password method - string octets must be multiple of 16, actual: " + strLen);
        }
        byte[] encodedStr = Arrays.copyOfRange(encodedData, 2, encodedData.length);
        byte[] salt = Arrays.copyOfRange(encodedData, 0, 2);
        byte[] c = ByteBuffer.allocate(18).put(auth).put(salt).array();
        ByteBuf plaintext = Unpooled.buffer((int)encodedStr.length, (int)encodedStr.length);
        for (int i = 0; i < strLen; i += 16) {
            plaintext.writeBytes(TunnelPasswordCodec.xor16(encodedStr, i, this.md5(secret, c)));
            c = Arrays.copyOfRange(encodedStr, i, i + 16);
        }
        byte len = plaintext.readByte();
        return plaintext.writerIndex(len + 1).copy().array();
    }

    private static byte[] genSalt() {
        byte[] randomBytes = new byte[2];
        RANDOM.nextBytes(randomBytes);
        randomBytes[0] = (byte)(randomBytes[0] | 0x80);
        return randomBytes;
    }
}

