/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.codec;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.packet.RadiusPacket;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;

public abstract class BaseCodec {
    public byte[] encode(byte[] data, byte[] requestAuth, String sharedSecret) throws RadiusPacketException {
        Objects.requireNonNull(data);
        Objects.requireNonNull(requestAuth);
        Objects.requireNonNull(sharedSecret);
        if (requestAuth.length != 16) {
            throw new RadiusPacketException("Request Authenticator must be 16 octets");
        }
        return this.encodeData(data, requestAuth, sharedSecret.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] decode(byte[] data, byte[] requestAuth, String sharedSecret) throws RadiusPacketException {
        Objects.requireNonNull(data);
        Objects.requireNonNull(requestAuth);
        Objects.requireNonNull(sharedSecret);
        if (requestAuth.length != 16) {
            throw new RadiusPacketException("Request Authenticator must be 16 octets");
        }
        return this.decodeData(data, requestAuth, sharedSecret.getBytes(StandardCharsets.UTF_8));
    }

    protected abstract byte[] encodeData(byte[] var1, byte[] var2, byte[] var3);

    protected abstract byte[] decodeData(byte[] var1, byte[] var2, byte[] var3) throws RadiusPacketException;

    protected static byte[] xor16(byte[] src1, int src1offset, byte[] src2) {
        Objects.requireNonNull(src1);
        Objects.requireNonNull(src2);
        byte[] dst = new byte[16];
        if (src1offset < 0) {
            throw new IndexOutOfBoundsException("src1offset is less than 0");
        }
        if (src1.length < src1offset + 16) {
            throw new IndexOutOfBoundsException("bytes in src1 is less than src1offset + 16");
        }
        if (src2.length < 16) {
            throw new IndexOutOfBoundsException("bytes in src2 is less than 16");
        }
        for (int i = 0; i < 16; ++i) {
            dst[i] = (byte)(src1[i + src1offset] ^ src2[i]);
        }
        return dst;
    }

    protected byte[] md5(byte[] a, byte[] b) {
        MessageDigest md = RadiusPacket.getMd5Digest();
        md.update(a);
        return md.digest(b);
    }

    protected static byte[] pad16x(byte[] val) {
        Objects.requireNonNull(val, "Byte array cannot be null");
        int length = Math.max((int)(Math.ceil((double)val.length / 16.0) * 16.0), 16);
        return Arrays.copyOf(val, length);
    }
}

