/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.codec;

import com.tplink.cdd.radius.common.attribute.codec.AscendSendSecretCodec;
import com.tplink.cdd.radius.common.attribute.codec.BaseCodec;
import com.tplink.cdd.radius.common.attribute.codec.NoOpCodec;
import com.tplink.cdd.radius.common.attribute.codec.TunnelPasswordCodec;
import com.tplink.cdd.radius.common.attribute.codec.UserPasswordCodec;

public enum AttributeCodecType {
    NO_ENCRYPT(0, new NoOpCodec()),
    RFC2865_USER_PASSWORD(1, new UserPasswordCodec()),
    RFC2868_TUNNEL_PASSWORD(2, new TunnelPasswordCodec()),
    ASCENT_SEND_SECRET(3, new AscendSendSecretCodec());

    private final byte id;
    private final BaseCodec codec;

    private AttributeCodecType(byte id, BaseCodec codec) {
        this.id = id;
        this.codec = codec;
    }

    public byte getId() {
        return this.id;
    }

    public BaseCodec getCodec() {
        return this.codec;
    }

    public static AttributeCodecType fromId(byte id) {
        switch (id) {
            case 1: {
                return RFC2865_USER_PASSWORD;
            }
            case 2: {
                return RFC2868_TUNNEL_PASSWORD;
            }
            case 3: {
                return ASCENT_SEND_SECRET;
            }
        }
        return NO_ENCRYPT;
    }
}

