/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.AttributeHolder;
import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.attribute.type.VendorSpecificAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public interface NestedAttributeHolder<T extends NestedAttributeHolder<T>>
extends AttributeHolder<T> {
    default public List<RadiusAttribute> filterAttributes(int vendorId, int type) {
        if (vendorId == this.getChildVendorId()) {
            return this.filterAttributes(type);
        }
        return this.getVendorAttributes(vendorId).stream().map(VendorSpecificAttribute::getAttributes).flatMap(Collection::stream).filter(sa -> sa.getType() == type && sa.getVendorId() == vendorId).collect(Collectors.toList());
    }

    @Override
    default public List<RadiusAttribute> filterAttributes(AttributeTemplate type) {
        return this.filterAttributes(type.getVendorId(), type.getType());
    }

    default public Optional<RadiusAttribute> getAttribute(int vendorId, int type) {
        return this.filterAttributes(vendorId, type).stream().findFirst();
    }

    default public List<VendorSpecificAttribute> getVendorAttributes(int vendorId) {
        return this.getAttributes().stream().filter(VendorSpecificAttribute.class::isInstance).map(VendorSpecificAttribute.class::cast).filter(a -> a.getChildVendorId() == vendorId).collect(Collectors.toList());
    }

    default public List<RadiusAttribute> getFlattenedAttributes() {
        return this.getAttributes().stream().map(RadiusAttribute::flatten).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    default public T addAttribute(RadiusAttribute attribute) throws RadiusPacketException {
        RadiusAttribute toAdd = attribute.getVendorId() == this.getChildVendorId() ? attribute : new VendorSpecificAttribute(this.getDictionary(), attribute.getVendorId(), Collections.singletonList(attribute));
        return (T)((NestedAttributeHolder)AttributeHolder.super.addAttribute(toAdd));
    }

    @Override
    default public T removeAttribute(RadiusAttribute attribute) throws RadiusPacketException {
        if (attribute.getVendorId() == this.getChildVendorId()) {
            return (T)((NestedAttributeHolder)AttributeHolder.super.removeAttribute(attribute));
        }
        List<RadiusAttribute> attributes = this.getAttributes().stream().map(a -> {
            if (!(a instanceof VendorSpecificAttribute)) {
                return a;
            }
            VendorSpecificAttribute vsa = (VendorSpecificAttribute)a;
            List<RadiusAttribute> subAttributes = vsa.filterAttributes((RadiusAttribute sa) -> !sa.equals(attribute));
            return subAttributes.isEmpty() ? null : vsa.withAttributes((List)subAttributes);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return (T)((NestedAttributeHolder)this.withAttributes(attributes));
    }

    default public T removeAttributes(int vendorId, int type) throws RadiusPacketException {
        if (vendorId == this.getChildVendorId()) {
            return (T)((NestedAttributeHolder)this.removeAttributes(type));
        }
        List<RadiusAttribute> attributes = this.getAttributes().stream().map(a -> {
            if (!(a instanceof VendorSpecificAttribute)) {
                return a;
            }
            VendorSpecificAttribute vsa = (VendorSpecificAttribute)a;
            List<RadiusAttribute> subAttributes = vsa.filterAttributes((RadiusAttribute sa) -> sa.getType() != type || sa.getVendorId() != vendorId);
            return subAttributes.isEmpty() ? null : vsa.withAttributes((List)subAttributes);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return (T)((NestedAttributeHolder)this.withAttributes(attributes));
    }
}

