/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.codec.AttributeCodecType;
import com.tplink.cdd.radius.common.attribute.type.AttributeType;
import com.tplink.cdd.radius.common.attribute.type.EncodedAttribute;
import com.tplink.cdd.radius.common.attribute.type.OctetsAttribute;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AttributeTemplate {
    private final int vendorId;
    private final int type;
    private final String name;
    private final String dataType;
    private final boolean tagged;
    private final AttributeCodecType codecType;
    private final AttributeType decodedType;
    private final AttributeType encodedType;
    private final Map<Integer, String> int2str = new HashMap<Integer, String>();
    private final Map<String, Integer> str2int = new HashMap<String, Integer>();
    private final Map<Long, String> long2str = new HashMap<Long, String>();
    private final Map<String, Long> str2long = new HashMap<String, Long>();

    public AttributeTemplate(int vendorId, int type, String name, String rawDataType) {
        this(vendorId, type, name, rawDataType, 0, false);
    }

    public AttributeTemplate(int vendorId, int type, String name, String rawDataType, byte encryptFlag, boolean hasTag) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name is empty");
        }
        Objects.requireNonNull(rawDataType, "Data type is null");
        this.vendorId = vendorId;
        this.type = type;
        this.name = name;
        this.dataType = rawDataType.toLowerCase();
        this.decodedType = vendorId == -1 && type == 26 ? AttributeType.VSA : AttributeType.fromDataType(this.dataType);
        this.tagged = AttributeTemplate.detectHasTag(vendorId, type, hasTag);
        this.codecType = AttributeTemplate.detectAttributeCodec(vendorId, type, encryptFlag);
        this.encodedType = this.codecType == AttributeCodecType.NO_ENCRYPT ? this.decodedType : AttributeType.OCTETS;
    }

    public RadiusAttribute create(Dictionary dictionary, byte tag, byte[] value) {
        return this.decodedType.create(dictionary, this.vendorId, this.type, tag, value);
    }

    public RadiusAttribute create(Dictionary dictionary, byte tag, String value) {
        return this.decodedType.create(dictionary, this.vendorId, this.type, tag, value);
    }

    public RadiusAttribute parse(Dictionary dictionary, ByteBuf data) {
        return this.autoWrapEncode(this.encodedType.create(dictionary, this.vendorId, data));
    }

    public RadiusAttribute createEncoded(Dictionary dictionary, byte tag, byte[] encodedValue) {
        return this.autoWrapEncode(this.encodedType.create(dictionary, this.vendorId, this.type, tag, encodedValue));
    }

    private RadiusAttribute autoWrapEncode(OctetsAttribute attribute) {
        return this.encryptEnabled() ? new EncodedAttribute(attribute) : attribute;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public String getDataType() {
        return this.dataType;
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public boolean encryptEnabled() {
        return this.codecType != AttributeCodecType.NO_ENCRYPT;
    }

    public AttributeCodecType getCodecType() {
        return this.codecType;
    }

    public String getEnumeration(int value) {
        return this.int2str.get(value);
    }

    public Integer getEnumeration(String value) {
        return this.str2int.get(value);
    }

    public String getEnumerationLong(long value) {
        return this.long2str.get(value);
    }

    public Long getEnumerationLong(String value) {
        return this.str2long.get(value);
    }

    public void addEnumerationValue(int num, long numLong, String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name is empty");
        }
        this.int2str.put(num, name);
        this.str2int.put(name, num);
        this.long2str.put(numLong, name);
        this.str2long.put(name, numLong);
    }

    public RadiusAttribute encode(RadiusAttribute attribute, byte[] requestAuth, String secret) throws RadiusPacketException {
        if (!this.encryptEnabled() || attribute.isEncoded()) {
            return attribute;
        }
        try {
            return this.createEncoded(attribute.getDictionary(), attribute.getTag().orElse((byte)0), this.codecType.getCodec().encode(attribute.getValue(), requestAuth, secret));
        }
        catch (Exception e) {
            throw new RadiusPacketException("Error encoding attribute " + attribute, e);
        }
    }

    public RadiusAttribute decode(RadiusAttribute attribute, byte[] requestAuth, String secret) throws RadiusPacketException {
        if (!attribute.isEncoded()) {
            return attribute;
        }
        try {
            return this.create(attribute.getDictionary(), (byte)attribute.getTag().orElse((byte)0), this.codecType.getCodec().decode(attribute.getValue(), requestAuth, secret));
        }
        catch (Exception e) {
            throw new RadiusPacketException("Error decoding attribute " + attribute, e);
        }
    }

    public String toString() {
        String s = Integer.toUnsignedString(this.getType()) + "/" + this.getName() + ": " + this.getDataType();
        if (this.getVendorId() != -1) {
            s = s + " (Vendor " + this.getVendorId() + ")";
        }
        return s;
    }

    private static boolean detectHasTag(int vendorId, int type, boolean hasTag) {
        return vendorId == -1 && type == 69 || hasTag;
    }

    private static AttributeCodecType detectAttributeCodec(int vendorId, int type, byte encryptFlag) {
        if (vendorId == -1 && type == 2) {
            return AttributeCodecType.RFC2865_USER_PASSWORD;
        }
        if (vendorId == -1 && type == 69) {
            return AttributeCodecType.RFC2868_TUNNEL_PASSWORD;
        }
        if (vendorId == 529 && type == 214) {
            return AttributeCodecType.ASCENT_SEND_SECRET;
        }
        return AttributeCodecType.fromId(encryptFlag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeTemplate)) {
            return false;
        }
        AttributeTemplate that = (AttributeTemplate)o;
        return this.vendorId == that.vendorId && this.type == that.type && this.tagged == that.tagged && this.name.equals(that.name) && this.dataType.equals(that.dataType) && this.codecType == that.codecType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vendorId, this.type, this.name, this.dataType, this.tagged, this.codecType});
    }
}

