/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.attribute.type.AnonSubAttribute;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.dictionary.Vendor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface AttributeHolder<T extends AttributeHolder<T>> {
    public static final Logger attrHolderLogger = LogManager.getLogger();

    public static ByteBuf attributesToBytes(List<RadiusAttribute> attributes) {
        return Unpooled.wrappedBuffer((ByteBuf[])((ByteBuf[])attributes.stream().map(RadiusAttribute::toByteBuf).toArray(ByteBuf[]::new)));
    }

    public static List<RadiusAttribute> readAttributes(Dictionary dictionary, int vendorId, ByteBuf data) {
        Optional<Vendor> vendor = dictionary.getVendor(vendorId);
        if (vendorId != -1 && !vendor.isPresent()) {
            return Collections.singletonList(new AnonSubAttribute(dictionary, vendorId, data));
        }
        ArrayList<RadiusAttribute> attributes = new ArrayList<RadiusAttribute>();
        try {
            while (data.isReadable(2)) {
                attributes.add(AttributeHolder.readAttribute(dictionary, vendorId, data));
            }
            if (data.isReadable()) {
                throw new IllegalArgumentException("Attribute malformed, " + data.readableBytes() + " bytes remaining to parse (minimum 2 octets)");
            }
        }
        catch (Exception e) {
            attrHolderLogger.trace("Could not extract all attributes: 0x{}", (Object)DatatypeConverter.printHexBinary((byte[])data.copy().array()));
            throw new IllegalArgumentException("Error reading attributes, already extracted attributes: " + attributes, e);
        }
        return attributes;
    }

    public static RadiusAttribute readAttribute(Dictionary dictionary, int vendorId, ByteBuf data) {
        int length;
        int type;
        Optional<Vendor> vendor = dictionary.getVendor(vendorId);
        int typeSize = vendor.map(Vendor::getTypeSize).orElse(1);
        switch (typeSize) {
            case 2: {
                type = data.getShort(data.readerIndex());
                break;
            }
            case 4: {
                type = data.getInt(data.readerIndex());
                break;
            }
            default: {
                type = Byte.toUnsignedInt(data.getByte(data.readerIndex()));
            }
        }
        int lengthSize = vendor.map(Vendor::getLengthSize).orElse(1);
        switch (lengthSize) {
            case 0: {
                length = data.readableBytes();
                break;
            }
            case 2: {
                length = data.getShort(data.readerIndex() + typeSize);
                break;
            }
            default: {
                length = Byte.toUnsignedInt(data.getByte(data.readerIndex() + typeSize));
            }
        }
        if (length < typeSize + lengthSize) {
            throw new IllegalArgumentException("Invalid attribute length " + length + ", must be >= typeSize + lengthSize, but typeSize=" + typeSize + ", lengthSize=" + lengthSize);
        }
        if (length > data.readableBytes()) {
            throw new IllegalArgumentException("Invalid attribute length " + length + ", parsable bytes " + data.readableBytes());
        }
        return dictionary.createAttribute(vendorId, type, data.readSlice(length));
    }

    public int getChildVendorId();

    public Dictionary getDictionary();

    public List<RadiusAttribute> getAttributes();

    default public Optional<RadiusAttribute> getAttribute(String type) {
        return this.filterAttributes(type).stream().findFirst();
    }

    default public Optional<RadiusAttribute> getAttribute(int type) {
        return this.filterAttributes(type).stream().findFirst();
    }

    default public List<RadiusAttribute> filterAttributes(int type) {
        return this.filterAttributes((RadiusAttribute a) -> a.getType() == type);
    }

    default public List<RadiusAttribute> filterAttributes(String name) {
        Optional<AttributeTemplate> type = this.getDictionary().getAttributeTemplate(name);
        if (type.isPresent()) {
            return this.filterAttributes(type.get());
        }
        throw new IllegalArgumentException("Unknown attribute type name'" + name + "'");
    }

    default public List<RadiusAttribute> filterAttributes(Predicate<RadiusAttribute> filter) {
        return this.getAttributes().stream().filter(filter).collect(Collectors.toList());
    }

    default public List<RadiusAttribute> filterAttributes(AttributeTemplate type) {
        if (type.getVendorId() == this.getChildVendorId()) {
            return this.filterAttributes(type.getType());
        }
        return Collections.emptyList();
    }

    default public ByteBuf getAttributeByteBuf() {
        return AttributeHolder.attributesToBytes(this.getAttributes());
    }

    public T withAttributes(List<RadiusAttribute> var1) throws RadiusPacketException;

    default public T addAttribute(RadiusAttribute attribute) throws RadiusPacketException {
        if (attribute.getVendorId() != this.getChildVendorId()) {
            throw new IllegalArgumentException("Attribute vendor ID doesn't match: required " + this.getChildVendorId() + ", actual " + attribute.getVendorId());
        }
        ArrayList<RadiusAttribute> attributes = new ArrayList<RadiusAttribute>(this.getAttributes());
        attributes.add(attribute);
        return this.withAttributes(attributes);
    }

    default public T addAttribute(String name, String value) throws RadiusPacketException {
        return this.addAttribute(this.getDictionary().createAttribute(name, value));
    }

    default public T addAttribute(int type, String value) throws RadiusPacketException {
        return this.addAttribute(this.getDictionary().createAttribute(this.getChildVendorId(), type, (byte)0, value));
    }

    default public T removeAttribute(RadiusAttribute attribute) throws RadiusPacketException {
        return this.withAttributes(this.filterAttributes((RadiusAttribute a) -> !a.equals(attribute)));
    }

    default public T removeAttributes(int type) throws RadiusPacketException {
        return this.withAttributes(this.filterAttributes((RadiusAttribute a) -> a.getType() != type));
    }

    default public T removeLastAttribute(int type) throws RadiusPacketException {
        List<RadiusAttribute> attributes = this.filterAttributes(type);
        if (attributes.isEmpty()) {
            return this.withAttributes(this.getAttributes());
        }
        return this.removeAttribute(attributes.get(attributes.size() - 1));
    }

    default public List<RadiusAttribute> encodeAttributes(byte[] requestAuth, String sharedSecret) throws RadiusPacketException {
        ArrayList<RadiusAttribute> encoded = new ArrayList<RadiusAttribute>();
        for (RadiusAttribute a : this.getAttributes()) {
            RadiusAttribute encode = a.encode(requestAuth, sharedSecret);
            encoded.add(encode);
        }
        return encoded;
    }

    default public List<RadiusAttribute> decodeAttributes(byte[] requestAuth, String sharedSecret) throws RadiusPacketException {
        ArrayList<RadiusAttribute> decoded = new ArrayList<RadiusAttribute>();
        for (RadiusAttribute a : this.getAttributes()) {
            RadiusAttribute decode = a.decode(requestAuth, sharedSecret);
            decoded.add(decode);
        }
        return decoded;
    }
}

