/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.cloud.omada.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tplink.smb.omada.cloud.api.internal.dto.DeviceTokenDTO;
import com.tplink.smb.omada.cloud.omada.service.d;
import com.tplink.smb.omada.cloud.platform.b;
import com.tplink.smb.omada.common.obfuscate.KeepMethod;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.system.a;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalMethodResolveClient;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalRequestDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class c {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(c.class);
    public static final String a = "getDeviceTokenWithServices";
    private static final Map<String, DeviceTokenDTO> c = new ConcurrentHashMap<String, DeviceTokenDTO>();
    @Autowired
    private OmadaClusterUniversalMethodResolveClient d;
    @Autowired
    private com.tplink.smb.omada.system.api.internal.c e;

    @Nullable
    public DeviceTokenDTO a(String deviceId, String serviceId) {
        String realServiceId = serviceId == null ? "nbu.omada.api" : serviceId;
        DeviceTokenDTO deviceTokenModel = this.a(realServiceId);
        if (deviceTokenModel != null && deviceTokenModel.getExpiresIn() >= System.currentTimeMillis()) {
            b.debug("deviceToken {} already exist", (Object)deviceTokenModel.getExpiresIn());
            return deviceTokenModel;
        }
        if (T.a((String)deviceId)) {
            deviceId = (String)this.e.d().getResult();
        }
        if (T.a((String)deviceId)) {
            b.error("No deviceId found");
            return null;
        }
        List<String> serviceIdList = this.b(realServiceId);
        com.tplink.smb.omada.common.access.OperationResponse<JSONObject> operationResponse = this.a(deviceId, serviceIdList);
        if (!operationResponse.success()) {
            b.warn("Failed to getDeviceTokenWithServices, err is {}", (Object)operationResponse.getMsg());
            return null;
        }
        try {
            JSONObject result = (JSONObject)operationResponse.getResult();
            deviceTokenModel = new DeviceTokenDTO();
            deviceTokenModel.setDeviceToken(result.getString("deviceToken"));
            deviceTokenModel.setExpiresIn(Long.valueOf(System.currentTimeMillis() + (long)result.getInt("expiresIn") * 1000L));
            b.debug("deviceToken expiresIn {}", (Object)deviceTokenModel.getExpiresIn());
            JSONObject serviceUrls = result.getJSONObject("serviceUrls");
            String omadaCloudUrl = serviceUrls.optString(realServiceId);
            b.debug("deviceToken omadaCloudUrl {}", (Object)omadaCloudUrl);
            if (T.a((String)omadaCloudUrl)) {
                b.warn("Find no serviceUrl with {}", (Object)realServiceId);
                return null;
            }
            deviceTokenModel.setServiceUrl(omadaCloudUrl);
            c.put(realServiceId, deviceTokenModel);
            return deviceTokenModel;
        }
        catch (Exception ex) {
            b.warn(ex.toString(), (Throwable)ex);
            return null;
        }
    }

    @KeepMethod
    public DeviceTokenDTO getOmadaCloudDeviceToken(String serviceId) {
        String realServiceId = serviceId == null ? "nbu.omada.api" : serviceId;
        DeviceTokenDTO deviceTokenDTO = c.get(realServiceId);
        if (deviceTokenDTO != null && deviceTokenDTO.getExpiresIn() >= System.currentTimeMillis()) {
            b.debug("deviceToken {} already exist", (Object)deviceTokenDTO.getExpiresIn());
            return deviceTokenDTO;
        }
        if (deviceTokenDTO != null && deviceTokenDTO.getExpiresIn() < System.currentTimeMillis()) {
            this.removeDeviceToken(serviceId);
        }
        return null;
    }

    public DeviceTokenDTO a(String realServiceId) {
        DeviceTokenDTO deviceTokenDTO = c.get(realServiceId);
        if (!com.tplink.smb.omada.common.util.system.a.b() || CollectionUtils.isEmpty((Map)com.tplink.smb.omada.common.util.system.c.a()) || OmadacType.r()) {
            return deviceTokenDTO;
        }
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(c.class, (TypeReference)new d(this), Boolean.valueOf(false), "getOmadaCloudDeviceToken", new Class[]{String.class}, new Object[]{realServiceId});
        Set nodeIds = com.tplink.smb.omada.common.util.system.c.a().keySet();
        HashMap<String, DeviceTokenDTO> deviceTokenMap = new HashMap<String, DeviceTokenDTO>();
        for (String nodeId : nodeIds) {
            OperationResponse clientNumRespInOtherNode;
            if (Objects.equals(nodeId, com.tplink.smb.omada.common.util.system.a.h()) || !(clientNumRespInOtherNode = this.d.resolveSpringBeanCall(nodeId, requestDTO)).success() || !Objects.nonNull(deviceTokenDTO = (DeviceTokenDTO)clientNumRespInOtherNode.getResult())) continue;
            deviceTokenMap.put(nodeId, deviceTokenDTO);
        }
        if (deviceTokenMap.size() == 1) {
            return (DeviceTokenDTO)deviceTokenMap.values().iterator().next();
        }
        if (deviceTokenMap.size() == 0) {
            return null;
        }
        deviceTokenDTO = deviceTokenMap.values().stream().sorted(Comparator.comparingLong(DeviceTokenDTO::getExpiresIn).reversed()).findFirst().orElse(null);
        return deviceTokenDTO;
    }

    @Nonnull
    private com.tplink.smb.omada.common.access.OperationResponse<JSONObject> a(String deviceId, List<String> serviceIdList) {
        JSONObject response;
        JSONObject requestObj = new JSONObject();
        requestObj.put("deviceId", (Object)deviceId);
        JSONArray serviceIds = new JSONArray();
        serviceIdList.forEach(serviceId -> serviceIds.put(serviceId));
        requestObj.put("serviceIds", (Object)serviceIds);
        try {
            response = com.tplink.smb.omada.cloud.platform.b.a().a(a, requestObj);
        }
        catch (IOException e2) {
            b.info("Exception occurs when sending request('{}'): {}", (Object)a, (Object)e2);
            b.debug(e2.toString(), (Throwable)e2);
            return new com.tplink.smb.omada.common.access.OperationResponse(com.tplink.smb.omada.common.g.b.ag);
        }
        if (response == null) {
            return new com.tplink.smb.omada.common.access.OperationResponse(com.tplink.smb.omada.common.g.b.ag);
        }
        try {
            int errCode = response.getInt("error_code");
            if (errCode == com.tplink.smb.omada.common.g.b.a.b()) {
                return new com.tplink.smb.omada.common.access.OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)response.getJSONObject("result"));
            }
        }
        catch (Exception ex) {
            b.warn(ex.toString(), (Throwable)ex);
        }
        return new com.tplink.smb.omada.common.access.OperationResponse(com.tplink.smb.omada.common.g.b.b);
    }

    @KeepMethod
    public void removeDeviceToken(String serviceId) {
        c.remove(serviceId);
    }

    public void a() {
        c.clear();
    }

    @Nullable
    public DeviceTokenDTO b() {
        String deviceId = (String)this.e.d().getResult();
        if (T.a((String)deviceId)) {
            return null;
        }
        DeviceTokenDTO deviceTokenModel = this.a(deviceId, "nbu.omada.api");
        if (deviceTokenModel == null || T.a((String)deviceTokenModel.getDeviceToken())) {
            return null;
        }
        return deviceTokenModel;
    }

    private List<String> b(@Nonnull String realServiceId) {
        ArrayList<String> serviceIdList = new ArrayList<String>();
        serviceIdList.add(realServiceId);
        switch (realServiceId) {
            case "nbu.omada-v2.api": {
                serviceIdList.add("nbu.omada.api");
                break;
            }
            case "nbu.cvm-server-v2": {
                serviceIdList.add("nbu.cvm-server");
                break;
            }
            case "nbu.client-recognition": {
                serviceIdList.add("nbu.homecare-cloud");
                break;
            }
        }
        return serviceIdList;
    }
}

