/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.cloud.omada.proxy.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.dispatcher.common.util.SessionUtils;
import com.tplink.smb.omada.identityaccess.api.internal.a.c;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetSessionRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadaRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacVO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.TenantDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.api.internal.h;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.b;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.ReferenceCountUtil;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.RequestEntity;
import org.springframework.web.util.UriTemplate;

public class w {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(w.class);
    private static final String b = "/api";
    private static final String c = "files";
    private static final String d = "msp";
    private static final String e = "Content-Type";
    private static final String f = "/openapi";
    private static final Integer g = 32;
    private final UriTemplate h = new UriTemplate("/{omadacId}/api/{*}");
    private final UriTemplate i = new UriTemplate("/api/{*}/msp/{mspId}");
    private final UriTemplate j = new UriTemplate("/api/{*}/app/msp/{mspId}");
    private final UriTemplate k = new UriTemplate("/openapi/{*}/{omadacId}");
    private final UriTemplate l = new UriTemplate("/openapi/{*}/msp/{mspId}");
    private ObjectMapper m;

    public FullHttpResponse a(@Nonnull FullHttpRequest request, String sessionId, String accountId, String transferId) {
        String originRequestUri = request.headers().get("Origin-Request-URI");
        String originRequestMethod = request.headers().get("Origin-Request-Http-Method");
        String requestSource = request.headers().get("Omada-Request-Source");
        a.debug("handleTransferStream, transfer id {}, originRequestUri {}", (Object)transferId, (Object)originRequestUri);
        if (!(T.a((String)requestSource) || Objects.equals(requestSource, "web-remote") || Objects.equals(requestSource, "app-remote"))) {
            a.warn("not support access type: {}", (Object)requestSource);
            return com.tplink.smb.omada.cloud.a.b.a.a(this.m, OperationResponse.GENERAL_ERROR, transferId);
        }
        if (T.a((String)sessionId) || T.a((String)accountId) || T.a((String)transferId)) {
            a.warn("Missing parameters in transferStream request, session {}, accountId {}, transferId {}", new Object[]{sessionId, accountId, transferId});
            return com.tplink.smb.omada.cloud.a.b.a.a(this.m, OperationResponse.GENERAL_ERROR, transferId);
        }
        GetSessionRequestDTO querySession = new GetSessionRequestDTO();
        querySession.setSessionId(sessionId);
        OperationResponse tenantSession = com.tplink.smb.omada.cloud.omada.proxy.client.w$a.f.b(querySession);
        if (!tenantSession.success() || Objects.isNull(tenantSession.getResult())) {
            a.warn("session Id {} is not find or timeout, transferId {}", (Object)sessionId, (Object)transferId);
            return com.tplink.smb.omada.cloud.a.b.a.a(this.m, new OperationResponse(com.tplink.smb.omada.common.g.b.l), transferId);
        }
        String email = ((TenantDTO)tenantSession.getResult()).getEmail();
        a.debug("origin request uri: {}, transferId {}", (Object)originRequestUri, (Object)transferId);
        if (T.c((String)originRequestUri)) {
            a.warn("not support null request uri {} in handleTransferStream", (Object)originRequestUri);
            return com.tplink.smb.omada.cloud.a.b.a.a(this.m, OperationResponse.PARAM_ERROR, transferId);
        }
        String omadacId = this.a(originRequestUri);
        if (T.a((String)omadacId) || Objects.equals("null", omadacId)) {
            omadacId = Optional.ofNullable((OmadacVO)com.tplink.smb.omada.cloud.omada.proxy.client.w$a.a.b().getResult()).map(OmadacVO::getId).orElse(null);
        }
        if (T.c((String)omadacId)) {
            a.warn("not support uri {} with blank omadac or msp id", (Object)originRequestUri);
            return com.tplink.smb.omada.cloud.a.b.a.a(this.m, OperationResponse.PARAM_ERROR, transferId);
        }
        String requestUri = this.a(originRequestUri, omadacId);
        if (Objects.equals(requestUri, originRequestUri)) {
            a.warn("Failed to resolve originRequestUri {} requestUri {}", (Object)originRequestUri, (Object)requestUri);
            return com.tplink.smb.omada.cloud.a.b.a.a(this.m, OperationResponse.UNSUPPORTED_HTTP_PATH, transferId);
        }
        OperationResponse findOmadacByIdOpt = com.tplink.smb.omada.cloud.omada.proxy.client.w$a.d.a(new OmadaRequestDTO(omadacId));
        if (!findOmadacByIdOpt.success() || findOmadacByIdOpt.getResult() == null) {
            a.warn("find omadac id failed, errorCode is {}, result is {}, uri {}", new Object[]{findOmadacByIdOpt.getErrorCode(), findOmadacByIdOpt.getResult(), requestUri});
            return com.tplink.smb.omada.cloud.a.b.a.a(this.m, new OperationResponse(com.tplink.smb.omada.common.g.b.aA), transferId);
        }
        if (requestUri.contains(d)) {
            a.debug("handle msp path start ..., originRequestUri is {}, transferId {}", (Object)originRequestUri, (Object)transferId);
            return this.a(omadacId, request, email, requestUri, sessionId, transferId);
        }
        String contentType = request.headers().get(e);
        if (requestUri.contains(c)) {
            if (!T.a((String)contentType) && contentType.contains("multipart/form-data")) {
                return this.b(omadacId, request, email, requestUri, originRequestMethod, sessionId, transferId);
            }
            return this.c(omadacId, request, email, requestUri, originRequestMethod, sessionId, transferId);
        }
        return this.a(omadacId, request, email, requestUri, originRequestMethod, sessionId, transferId);
    }

    private String a(String requestUri, String omadacId) {
        if (T.c((String)omadacId) || T.c((String)requestUri)) {
            return requestUri;
        }
        if (requestUri.contains(f)) {
            return requestUri.substring(requestUri.indexOf(f));
        }
        if (requestUri.contains(b)) {
            int apiIndex = requestUri.indexOf(b);
            int omadacIndex = requestUri.substring(0, apiIndex).lastIndexOf("/");
            if (omadacIndex < 0) {
                return requestUri;
            }
            String omadacStringInPath = requestUri.substring(omadacIndex + 1, apiIndex);
            if (omadacId.equals(omadacStringInPath)) {
                if (omadacStringInPath.length() != g.intValue()) {
                    a.warn("Omadac String In Path length is not 32 characters {}", (Object)omadacStringInPath);
                }
                return requestUri.substring(omadacIndex);
            }
            return requestUri.substring(apiIndex);
        }
        return requestUri;
    }

    private String a(String originRequestUri) {
        boolean mspPath = false;
        if (originRequestUri.contains(d)) {
            mspPath = true;
        }
        Map omadacUriMap = this.h.match(originRequestUri);
        Map mspUriMap = this.i.match(originRequestUri);
        Map mspAppUriMap = this.j.match(originRequestUri);
        Map openApiUriMap = this.k.match(originRequestUri);
        Map openApiMspUriMap = this.l.match(originRequestUri);
        String urlOmadacId = null;
        if (mspPath) {
            if (mspUriMap.containsKey("mspId")) {
                urlOmadacId = (String)mspUriMap.get("mspId");
            } else if (mspAppUriMap.containsKey("mspId")) {
                urlOmadacId = (String)mspAppUriMap.get("mspId");
            } else if (openApiMspUriMap.containsKey("mspId")) {
                urlOmadacId = (String)openApiMspUriMap.get("mspId");
            }
        } else if (omadacUriMap.containsKey("omadacId")) {
            urlOmadacId = (String)omadacUriMap.get("omadacId");
        } else if (openApiUriMap.containsKey("omadacId")) {
            urlOmadacId = (String)openApiUriMap.get("omadacId");
        }
        return urlOmadacId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FullHttpResponse a(String omadacId, FullHttpRequest request, String email, String uri, String httpMethod, String sessionId, String transferId) {
        OperationResponse operationResponse;
        FullHttpResponse response = null;
        try {
            SessionUtils.setThreadSessionId((String)sessionId);
            SessionUtils.setThreadAccountName((String)email);
            RequestEntity<String> entity = com.tplink.smb.omada.cloud.a.b.a.a(request, uri, httpMethod);
            response = com.tplink.smb.omada.cloud.a.b.a.a(this.m, OperationResponse.SUCCESS, transferId);
            com.tplink.smb.omada.cloud.api.internal.c.a proxyEvent = new com.tplink.smb.omada.cloud.api.internal.c.a(entity, null, response, omadacId, sessionId);
            DomainEventBusHolder.getPublisher().publishSync((DomainEvent)proxyEvent);
            operationResponse = proxyEvent.f();
        }
        catch (Exception ex) {
            a.error(ex.toString(), (Throwable)ex);
            operationResponse = OperationResponse.GENERAL_ERROR;
            ReferenceCountUtil.release(response);
        }
        finally {
            SessionUtils.clearThreadSession();
        }
        return com.tplink.smb.omada.cloud.a.b.a.a(this.m, operationResponse, transferId, omadacId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FullHttpResponse b(String omadacId, FullHttpRequest request, String email, String uri, String httpMethod, String sessionId, String transferId) {
        OperationResponse operationResponse;
        FullHttpResponse response = null;
        try {
            HashMap<String, com.tplink.smb.omada.common.util.file.a> multipartFileMap = new HashMap<String, com.tplink.smb.omada.common.util.file.a>(2);
            com.tplink.smb.omada.common.util.file.a bytesMultiPartFile = null;
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)request);
            List dataList = decoder.getBodyHttpDatas();
            for (InterfaceHttpData data : dataList) {
                if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.FileUpload) continue;
                FileUpload fileUpload = (FileUpload)data;
                bytesMultiPartFile = new com.tplink.smb.omada.common.util.file.a(fileUpload.getName(), fileUpload.getFilename(), fileUpload.getContentType(), fileUpload.get());
            }
            if (bytesMultiPartFile != null) {
                multipartFileMap.put("file", bytesMultiPartFile);
            }
            SessionUtils.setThreadSessionId((String)sessionId);
            SessionUtils.setThreadAccountName((String)email);
            RequestEntity<String> entity = com.tplink.smb.omada.cloud.a.b.a.a(request, uri, httpMethod, decoder);
            response = com.tplink.smb.omada.cloud.a.b.a.b(this.m, OperationResponse.SUCCESS, transferId);
            com.tplink.smb.omada.cloud.api.internal.c.a proxyEvent = new com.tplink.smb.omada.cloud.api.internal.c.a(entity, multipartFileMap, response, omadacId, sessionId);
            DomainEventBusHolder.getPublisher().publishSync((DomainEvent)proxyEvent);
            operationResponse = proxyEvent.f();
        }
        catch (Exception ex) {
            a.error(ex.toString(), (Throwable)ex);
            operationResponse = OperationResponse.GENERAL_ERROR;
            ReferenceCountUtil.release(response);
        }
        finally {
            SessionUtils.clearThreadSession();
        }
        return com.tplink.smb.omada.cloud.a.b.a.b(this.m, operationResponse, transferId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FullHttpResponse c(String omadacId, FullHttpRequest request, String email, String uri, String httpMethod, String sessionId, String transferId) {
        ByteArrayOutputStream out = null;
        OperationResponse res = null;
        Map headers = null;
        DefaultFullHttpResponse response = null;
        try {
            SessionUtils.setThreadSessionId((String)sessionId);
            SessionUtils.setThreadAccountName((String)email);
            RequestEntity<String> entity = com.tplink.smb.omada.cloud.a.b.a.a(request, uri, httpMethod);
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, com.tplink.smb.omada.cloud.a.b.a.a(this.m, (Object)OperationResponse.SUCCESS));
            com.tplink.smb.omada.cloud.api.internal.c.a proxyEvent = new com.tplink.smb.omada.cloud.api.internal.c.a(entity, null, (FullHttpResponse)response, omadacId, sessionId);
            DomainEventBusHolder.getPublisher().publishSync((DomainEvent)proxyEvent);
            out = (ByteArrayOutputStream)proxyEvent.g();
            if (out.toByteArray().length == 0) {
                res = proxyEvent.f();
            }
            headers = proxyEvent.h();
        }
        catch (Exception ex) {
            a.error(ex.toString(), (Throwable)ex);
            ReferenceCountUtil.release(response);
        }
        finally {
            SessionUtils.clearThreadSession();
        }
        if (Objects.nonNull(res)) {
            return com.tplink.smb.omada.cloud.a.b.a.a(this.m, res, transferId, omadacId);
        }
        return com.tplink.smb.omada.cloud.a.b.a.a(transferId, out, headers);
    }

    public FullHttpResponse a(String omadacId, FullHttpRequest request, String email, String requestUri, String sessionId, String transferId) {
        String originRequestMethod = request.headers().get("Origin-Request-Http-Method");
        String contentType = request.headers().get(e);
        if (requestUri.contains(c)) {
            if (!T.a((String)contentType) && contentType.contains("multipart/form-data")) {
                return this.b(omadacId, request, email, requestUri, originRequestMethod, sessionId, transferId);
            }
            return this.c(omadacId, request, email, requestUri, originRequestMethod, sessionId, transferId);
        }
        return this.a(omadacId, request, email, requestUri, originRequestMethod, sessionId, transferId);
    }

    @Generated
    public void a(ObjectMapper mapper) {
        this.m = mapper;
    }

    private static class a {
        static c a = (c)com.tplink.smb.omada.common.spring.a.b(c.class);
        static g b = (g)com.tplink.smb.omada.common.spring.a.b(g.class);
        static com.tplink.smb.omada.identityaccess.api.internal.a.a c = (com.tplink.smb.omada.identityaccess.api.internal.a.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.identityaccess.api.internal.a.a.class);
        static l d = (l)com.tplink.smb.omada.common.spring.a.b(l.class);
        static b e = (b)com.tplink.smb.omada.common.spring.a.b(b.class);
        static h f = (h)com.tplink.smb.omada.common.spring.a.b(h.class);

        private a() {
        }
    }
}

