/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.cloud.a;

import com.tplink.eap.cloudsdk.DeviceInfo;
import com.tplink.eap.cloudsdk.IDeviceMgmt;
import com.tplink.eap.cloudsdk.deviceToken.DeviceTokenDTO;
import com.tplink.eap.cloudsdk.util.TwoTuple;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.identityaccess.api.internal.a.c;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacVO;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.GeneralSettingDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class b
extends DeviceInfo
implements IDeviceMgmt {
    @Generated
    private static final Logger l = LoggerFactory.getLogger(b.class);
    public static final String a = "mac";
    public static final String b = "hw_id";
    public static final String c = "fw_id";
    public static final String d = "oem_id";
    public static final String e = "device_id";
    public static final String f = "product_name";
    private static final String m = "br-lan";
    public static final String g = "product_version";
    public static final String h = "firmware-version";
    public static final String i = "#";
    public static final String j = "clusterMode=";
    public static final String k = "hasClusterPermission=";

    public DeviceInfo getDeviceInfo() {
        long begin = System.currentTimeMillis();
        String deviceInfoJson = x.a((File)new File("/tmp/sysinfo/device-info.json"));
        try {
            JSONObject deviceInfoObj = new JSONObject(deviceInfoJson);
            this.setHwId(deviceInfoObj.getString(b));
            this.setDeviceModel(deviceInfoObj.getString(f));
            this.setDeviceHwVer(deviceInfoObj.getString(g));
            this.setOemId(deviceInfoObj.getString(d));
        }
        catch (JSONException e2) {
            l.error(e2.getMessage());
        }
        l.info("hw getDeviceInfo DEVICE_INFO_PATH cost:{} ms", (Object)(System.currentTimeMillis() - begin));
        String firmwareInfoJson = x.a((File)new File("/tmp/sysinfo/firmware-info.json"));
        try {
            JSONObject firmwareInfoObj = new JSONObject(firmwareInfoJson);
            this.setFwId(firmwareInfoObj.getString(c));
            this.setFwVer(firmwareInfoObj.getString(h));
        }
        catch (JSONException e3) {
            l.error(e3.getMessage());
        }
        l.info("hw getDeviceInfo FIRMWARE_INFO_PATH cost:{} ms", (Object)(System.currentTimeMillis() - begin));
        String tddpInfoJson = x.a((File)new File("/tmp/sysinfo/tddp.json"));
        try {
            JSONObject tddpInfoObj = new JSONObject(tddpInfoJson);
            this.setDeviceMac(tddpInfoObj.getString(a).replaceAll("[-:]", ""));
            this.setDeviceId(tddpInfoObj.getString(e));
        }
        catch (JSONException e4) {
            l.error(e4.getMessage());
        }
        l.info("hw getDeviceInfo TDDP_PATH cost:{} ms", (Object)(System.currentTimeMillis() - begin));
        TwoTuple<String, String> localNet = this.b();
        if (localNet != null) {
            this.setIp((String)localNet.first);
            this.setMask((String)localNet.second);
        }
        String alias = null;
        String cloudUserName = "";
        String omadacId = Optional.ofNullable((OmadacVO)com.tplink.smb.omada.cloud.a.b$a.b.b().getResult()).map(OmadacVO::getId).orElse(null);
        if (omadacId != null) {
            GeneralSettingDTO generalSetting = (GeneralSettingDTO)com.tplink.smb.omada.cloud.a.b$a.a.a(omadacId).getResult();
            if (Objects.nonNull(generalSetting) && T.b((String)generalSetting.getOmadacName())) {
                alias = generalSetting.getOmadacName();
            }
            cloudUserName = com.tplink.smb.omada.cloud.a.b.a.d(omadacId);
            this.setOmadacId(omadacId);
        }
        this.setAlias(alias == null ? this.c() : alias);
        if (OmadacType.t()) {
            this.setDeviceType("SMB.OMADA.ROUTERCONTROLLER");
        } else if (OmadacType.l()) {
            this.setDeviceType("SMB.OMADA.HARDWARECONTROLLERPRO");
        } else {
            this.setDeviceType("SMB.OMADA.HARDWARECONTROLLER");
        }
        this.a();
        this.setControllerVersion((String)com.tplink.smb.omada.cloud.a.b$a.a.b().getResult());
        this.setCloudUserName(cloudUserName);
        l.info("hw getDeviceInfo total cost:{} ms", (Object)(System.currentTimeMillis() - begin));
        return this;
    }

    public DeviceTokenDTO getDeviceTokenFromController() {
        return null;
    }

    public void setDeviceTokenForController(DeviceTokenDTO deviceTokenDTO) {
    }

    public Boolean needGetTokenFromontroller() {
        return false;
    }

    private void a() {
        String appVersion = com.tplink.smb.omada.common.b.a.a();
        if (com.tplink.smb.omada.common.util.system.a.b()) {
            if (com.tplink.smb.omada.common.util.system.a.c()) {
                this.setDeviceName("Omada Controller #" + appVersion + "#clusterMode=" + Boolean.TRUE + "#hasClusterPermission=" + Boolean.TRUE);
            } else if (com.tplink.smb.omada.common.util.system.a.d() && Objects.nonNull(com.tplink.smb.omada.common.util.system.c.b()) && Boolean.TRUE.equals(com.tplink.smb.omada.common.util.system.c.b().getPrimary())) {
                this.setDeviceName("Omada Controller #" + appVersion + "#clusterMode=" + Boolean.TRUE + "#hasClusterPermission=" + Boolean.TRUE);
            } else {
                this.setDeviceName("Omada Controller #" + appVersion + "#clusterMode=" + Boolean.TRUE + "#hasClusterPermission=" + Boolean.FALSE);
            }
        } else {
            this.setDeviceName("Omada Controller #" + appVersion + "#clusterMode=" + Boolean.FALSE + "#hasClusterPermission=" + Boolean.FALSE);
        }
    }

    @Nullable
    private TwoTuple<String, String> b() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                l.debug("netInterface's name is {}", (Object)netInterface.getName());
                if (!Objects.equals(netInterface.getName(), m)) continue;
                List<InterfaceAddress> intfAddrList = netInterface.getInterfaceAddresses();
                for (InterfaceAddress intfAddr : intfAddrList) {
                    InetAddress ip = intfAddr.getAddress();
                    if (ip == null || ip.isLoopbackAddress() || ip.isLinkLocalAddress()) continue;
                    String mask = this.a(intfAddr.getNetworkPrefixLength());
                    l.debug("local ip is {}, mask is {}.", (Object)ip.getHostAddress(), (Object)mask);
                    return new TwoTuple((Object)ip.getHostAddress(), (Object)mask);
                }
            }
        }
        catch (Exception ex) {
            l.error(ex.toString(), (Throwable)ex);
            return null;
        }
        return new TwoTuple((Object)"--", (Object)"");
    }

    @Nonnull
    private String a(short length) {
        int mask = -1 << 32 - length;
        int partsNum = 4;
        int bitsOfPart = 8;
        int[] maskParts = new int[partsNum];
        int selector = 255;
        for (int i2 = 0; i2 < maskParts.length; ++i2) {
            int pos = maskParts.length - 1 - i2;
            maskParts[pos] = mask >> i2 * bitsOfPart & selector;
        }
        StringBuilder ipMask = new StringBuilder();
        for (int i3 = 0; i3 < partsNum; ++i3) {
            ipMask.append(maskParts[i3]);
            if (i3 >= partsNum - 1) continue;
            ipMask.append(".");
        }
        return ipMask.toString();
    }

    @Nonnull
    private String c() {
        String string;
        Process process;
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec("uci get system.settings.dev_name");
        }
        catch (IOException ex) {
            l.error(ex.toString(), (Throwable)ex);
            return this.getDeviceModel() + "_" + this.getDeviceMac().substring(6);
        }
        StringBuilder deviceName = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                deviceName.append(line);
            }
            string = deviceName.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                l.error(ex.toString(), (Throwable)ex);
                return this.getDeviceModel() + "_" + this.getDeviceMac().substring(6);
            }
        }
        bufferedReader.close();
        return string;
    }

    private static class a {
        static com.tplink.smb.omada.manager.configuration.api.internal.omadac.b a = (com.tplink.smb.omada.manager.configuration.api.internal.omadac.b)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.configuration.api.internal.omadac.b.class);
        static c b = (c)com.tplink.smb.omada.common.spring.a.b(c.class);

        private a() {
        }
    }
}

