/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.common.config;

import com.tplink.smb.omada.common.concurrent.thread.CommonExecutorProperties;
import com.tplink.smb.omada.common.concurrent.thread.b;
import com.tplink.smb.omada.monitor.common.properties.SchedulerCustomProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CommonExecutorProperties.class})
public class CommThreadConfig {
    public static final String a = "executor_metric";
    @Autowired
    private CommonExecutorProperties b;
    @Autowired
    private SchedulerCustomProperties c;
    @Autowired
    private MeterRegistry d;

    @Bean(name={"commThreadPool"})
    @ConditionalOnMissingBean(name={"commThreadPool"})
    public ExecutorService initCommThreadPool() {
        String poolName = "comm-pool";
        ExecutorService executor = com.tplink.smb.omada.common.concurrent.thread.b.a((int)this.b.getCommCoreThreads(), (int)this.b.getCommMaxThreads(), (long)this.b.getKeepAliveTime(), new SynchronousQueue(), (String)poolName);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.d, (ExecutorService)executor, (String)poolName, (String)a, (Tag[])new Tag[0]);
    }

    @Bean(name={"commBlockingThreadPool"})
    @ConditionalOnMissingBean(name={"commBlockingThreadPool"})
    public ExecutorService initCommBlockingThreadPool() {
        String poolName = "monitor-common-block-pool";
        ExecutorService executor = com.tplink.smb.omada.common.concurrent.thread.b.a((int)this.b.getCommCoreThreads(), (int)this.b.getCommMaxThreads(), (long)this.b.getKeepAliveTime(), new LinkedBlockingQueue(this.b.getQueueCapacity()), (String)poolName);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.d, (ExecutorService)executor, (String)poolName, (String)a, (Tag[])new Tag[0]);
    }

    @Bean(name={"reportEmailBlockingThreadPool"})
    @ConditionalOnMissingBean(name={"reportEmailBlockingThreadPool"})
    public ExecutorService initReportEmailBlockingThreadPool() {
        String poolName = "monitor-report-email-block-pool";
        ExecutorService executor = com.tplink.smb.omada.common.concurrent.thread.b.a((int)this.c.getEmailScheduleCoreSize(), (int)this.c.getEmailScheduleMaxSize(), (long)this.b.getKeepAliveTime(), new LinkedBlockingQueue(this.b.getQueueCapacity()), (String)poolName);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.d, (ExecutorService)executor, (String)poolName, (String)a, (Tag[])new Tag[0]);
    }
}

