/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.port.local;

import com.tplink.smb.omada.common.omadac.config.b;
import com.tplink.smb.omada.common.omadac.config.c;
import com.tplink.smb.omada.common.util.T;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAotInitUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAotInitUtils.class);

    public static void init() {
        String myDIR = SpringAotInitUtils.getMyDIR();
        System.out.println(myDIR);
        System.setProperty("eap.home", SpringAotInitUtils.getMyDIR() + File.separator + "..");
        SpringAotInitUtils.loadConfigurations();
        SpringAotInitUtils.mongoSystemProperty();
        SpringAotInitUtils.jettySystemProperty();
        SpringAotInitUtils.deviceManageProperty();
        SpringAotInitUtils.portalRateLimiterProperty();
        SpringAotInitUtils.ssoProperty();
        SpringAotInitUtils.mspProperty();
    }

    public static String getMyDIR() {
        return ".";
    }

    private static void loadConfigurations() {
        try {
            c.a((File)new File(System.getProperty("eap.home", "."), "properties"));
        }
        catch (IOException e2) {
            log.error("fail to load configurations .", (Throwable)e2);
        }
    }

    private static void mongoSystemProperty() {
        b eapConf = c.a((String)"omada.properties");
        boolean useExternal = eapConf.b("mongo.external");
        Object uri = useExternal ? eapConf.a("eap.mongod.uri") : "mongodb://127.0.0.1:" + eapConf.a("eap.mongod.port") + "/omada";
        System.setProperty("eap.mongod.uri", (String)uri);
    }

    private static void jettySystemProperty() {
        b configuration = c.a((String)"omada.properties");
        System.setProperty("manage.https.port", configuration.a("manage.https.port"));
        System.setProperty("portal.http.port", configuration.a("portal.http.port"));
        System.setProperty("portal.https.port", configuration.a("portal.https.port"));
        System.setProperty("manage.http.port", configuration.a("manage.http.port"));
        System.setProperty("upgrade.https.port", configuration.a("upgrade.https.port"));
        Optional.ofNullable(configuration.a("upload.file.size")).ifPresent(value -> System.setProperty("upload.file.size", value));
    }

    private static void deviceManageProperty() {
        String reconnectRateLimter;
        String adoptRateLimter;
        String managerQueueSize;
        String managerMaxThread;
        String managerCoreThread;
        String adoptQueueSize;
        String adoptMaxThread;
        String adoptCoreThread;
        b configuration = c.a((String)"omada.properties");
        String discoveryCoreThread = configuration.a("discovery.net.thread");
        if (T.b((String)discoveryCoreThread)) {
            System.setProperty("discovery.net.thread", discoveryCoreThread);
        }
        String discoveryMaxThread = configuration.a("max.discovery.net.thread");
        if (T.b((String)discoveryCoreThread)) {
            System.setProperty("max.discovery.net.thread", discoveryMaxThread);
        }
        String discoveryQueueSize = configuration.a("discovery.net.queue.size");
        if (T.b((String)discoveryCoreThread)) {
            System.setProperty("discovery.net.queue.size", discoveryQueueSize);
        }
        if (T.b((String)(adoptCoreThread = configuration.a("adopt.net.thread")))) {
            System.setProperty("adopt.net.thread", adoptCoreThread);
        }
        if (T.b((String)(adoptMaxThread = configuration.a("max.adopt.net.thread")))) {
            System.setProperty("max.adopt.net.thread", adoptMaxThread);
        }
        if (T.b((String)(adoptQueueSize = configuration.a("adopt.net.queue.size")))) {
            System.setProperty("adopt.net.queue.size", adoptQueueSize);
        }
        if (T.b((String)(managerCoreThread = configuration.a("manager.net.thread")))) {
            System.setProperty("manager.net.thread", managerCoreThread);
        }
        if (T.b((String)(managerMaxThread = configuration.a("max.manager.net.thread")))) {
            System.setProperty("max.manager.net.thread", managerMaxThread);
        }
        if (T.b((String)(managerQueueSize = configuration.a("manager.net.queue.size")))) {
            System.setProperty("manager.net.queue.size", managerQueueSize);
        }
        if (T.b((String)(adoptRateLimter = configuration.a("adopt.device.manage.config.maxAdoptSyncNum")))) {
            System.setProperty("adopt.device.manage.config.maxAdoptSyncNum", adoptRateLimter);
        }
        if (T.b((String)(reconnectRateLimter = configuration.a("adopt.device.manage.config.reconnectMaxAdoptSyncNum")))) {
            System.setProperty("adopt.device.manage.config.reconnectMaxAdoptSyncNum", reconnectRateLimter);
        }
        Optional.ofNullable(configuration.a("port.app.discovery")).ifPresent(value -> System.setProperty("port.app.discovery", value));
        Optional.ofNullable(configuration.a("port.adopt.v1")).ifPresent(value -> System.setProperty("port.adopt.v1", value));
        Optional.ofNullable(configuration.a("port.upgrade.v1")).ifPresent(value -> System.setProperty("port.upgrade.v1", value));
        Optional.ofNullable(configuration.a("port.manager.v1")).ifPresent(value -> System.setProperty("port.manager.v1", value));
        Optional.ofNullable(configuration.a("port.manager.v2")).ifPresent(value -> System.setProperty("port.manager.v2", value));
        Optional.ofNullable(configuration.a("port.discovery")).ifPresent(value -> System.setProperty("port.discovery", value));
        Optional.ofNullable(configuration.a("port.transfer.v2")).ifPresent(value -> System.setProperty("port.transfer.v2", value));
        Optional.ofNullable(configuration.a("port.rtty")).ifPresent(value -> System.setProperty("port.rtty", value));
        Optional.ofNullable(configuration.a("port.device.monitor")).ifPresent(value -> System.setProperty("port.device.monitor", value));
        Optional.ofNullable(configuration.a("max.device")).ifPresent(value -> System.setProperty("max.device", value));
        Optional.ofNullable(configuration.a("device.manage.interface.ip")).ifPresent(value -> System.setProperty("device.manage.interface.ip", value));
        Optional.ofNullable(configuration.a("max.device.adopt.each.batch")).ifPresent(value -> System.setProperty("max.device.adopt.each.batch", value));
    }

    private static void portalRateLimiterProperty() {
        b configuration = c.a((String)"omada.properties");
        System.setProperty("client.portal.auth.config.authNumPerSecond", configuration.a("client.portal.auth.config.authNumPerSecond"));
    }

    private static void ssoProperty() {
        b configuration = c.a((String)"omada.properties");
        Optional.ofNullable(configuration.a("sso.saml.entityUrl")).ifPresent(value -> System.setProperty("sso.saml.entityUrl", value));
        Optional.ofNullable(configuration.a("sso.saml.signOnUrl")).ifPresent(value -> System.setProperty("sso.saml.signOnUrl", value));
        Optional.ofNullable(configuration.a("sso.saml.redirectUrl")).ifPresent(value -> System.setProperty("sso.saml.redirectUrl", value));
        Optional.ofNullable(configuration.a("sso.saml.samlUserMaxNum")).ifPresent(value -> System.setProperty("sso.saml.samlUserMaxNum", value));
    }

    private static void mspProperty() {
        b configuration = c.a((String)"omada.properties");
        Optional.ofNullable(configuration.a("customer.limit")).ifPresent(value -> System.setProperty("customer.limit", value));
    }

    @Generated
    private SpringAotInitUtils() {
    }
}

