/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.port.local;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.apigateway.port.local.ServerCertConfig;
import com.tplink.smb.omada.apigateway.port.local.ServerCertProvider;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.omadac.config.b;
import com.tplink.smb.omada.common.omadac.config.c;
import com.tplink.smb.omada.common.util.ab;
import com.tplink.smb.omada.system.api.util.X509CertificateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.Compression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@KeepClass
public class LocalApplicationConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalApplicationConfig.class);
    private static final int MAX_FORM_CONTENT_SIZE = 0x300000;
    private static final int MAX_IDLE_TIME = 300000;
    private static final int CONNECTOR_ACCEPTORS = 2;
    private static final int CONNECTOR_ACCEPT_QUEUE_SIZE = 100;
    private static final int MIN_THREADS = 3;
    private static final int MAX_THREADS = 100;
    private static final int GRACEFUL_SHUTDOWN = 1000;
    private static final String EAP_CONTEXT_PATH = "/";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private int httpPort = ab.d();
    private int httpsPort = ab.e();
    private int portalHttpPort = ab.b();
    private int portalHttpsPort = ab.c();
    private int upgradeHttpsPort = ab.a();
    private ServerCertProvider serverCertProvider;
    private FileRepository fileRepository;
    private static List<String> ciphers = Arrays.asList("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_AES_128_CCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CCM", "TLS_ECDHE_ECDSA_WITH_AES_256_CCM", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_CCM", "TLS_DHE_RSA_WITH_AES_256_CCM");
    private static final String EXCLUDE_CIPHERS = ":!TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA:!TLS_DHE_RSA_WITH_AES_256_CBC_SHA:!TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA:!TLS_DHE_RSA_WITH_AES_128_CBC_SHA";
    private static final String USED_CIPHERS = String.join((CharSequence)":", ciphers);
    @Autowired
    private ApplicationArguments arguments;

    @Bean
    public TomcatServletWebServerFactory servletContainer() {
        boolean retry = false;
        String eapHome = System.getProperty("eap.home");
        String path = eapHome + "/data/keystore/eap.keystore";
        File file = new File(eapHome + "/data/keystore/smb.keystore");
        if (file.exists()) {
            path = eapHome + "/data/keystore/smb.keystore";
        }
        for (String sourceArg : this.arguments.getSourceArgs()) {
            if (!"retry".equals(sourceArg)) continue;
            retry = true;
            break;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory(){

            protected void postProcessContext(Context context) {
                StandardJarScanFilter filter = (StandardJarScanFilter)context.getJarScanner().getJarScanFilter();
                String skip = ",forms-1.0.5.jar,looks-1.2.2.jar,miethxml-toolkit.jar,xercesImpl.jar,xml-apis.jar,serializer.jar,fop-2.9.jar,fop-util-2.9.jar,fop-events-2.9.jar,qdox-1.12.jar,fop-core-2.9.jar,fontbox-2.0.27.jar,rhino-1.7.13.jar,batik-extension-1.17.jar,kabeja-0.4.10.jar,batik-swing-1.17.jar,batik-anim-1.17.jar,batik-awt-util-1.17.jar,xmlgraphics-commons-2.9.jar,batik-bridge-1.17.jar,batik-css-1.17.jar,batik-dom-1.17.jar,batik-ext-1.17.jar,batik-gui-util-1.17.jar,batik-gvt-1.17.jar,batik-script-1.17.jar,batik-shared-resources-1.17.jar,batik-util-1.17.jar,batik-constants-1.17.jar,batik-i18n-1.17.jar,batik-transcoder-1.17.jar,batik-svggen-1.17.jar,batik-xml-1.17.jar,batik-svg-dom-1.17.jar,batik-parser-1.17.jar,batik-codec-1.17.jar,svm.jar,library-support.jar,objectfile.jar,native-image-base.jar,pointsto.jar";
                filter.setTldSkip(filter.getTldSkip() + skip);
                context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
            }
        };
        Connector[] additionalConnectors = this.additionalConnector(retry, path);
        if (additionalConnectors.length > 0) {
            tomcat.addAdditionalTomcatConnectors(additionalConnectors);
        }
        Compression compression = new Compression();
        compression.setEnabled(true);
        String[] compress_mimitype = new String[]{"text/html", "text/xml", "text/plain", "text/css", "text/javascript", "application/javascript", "application/xml"};
        compression.setMimeTypes(compress_mimitype);
        tomcat.setCompression(compression);
        return tomcat;
    }

    private Connector[] additionalConnector(boolean retry, String path) {
        b conf = c.a((String)"omada.properties");
        String eapHome = System.getProperty("eap.home");
        Integer tomcatMinSpareNum = 3;
        try {
            tomcatMinSpareNum = Integer.valueOf(System.getProperty("server.tomcat.threads.min-spare"));
        }
        catch (NumberFormatException e2) {
            log.warn("Tomcat use static configuration.");
        }
        ArrayList<Connector> result = new ArrayList<Connector>();
        result.add(this.buildHttpsConnector(this.httpsPort, eapHome, conf, retry, path, tomcatMinSpareNum));
        if (this.httpsPort != this.portalHttpsPort) {
            result.add(this.buildHttpsConnector(this.portalHttpsPort, eapHome, conf, retry, path, tomcatMinSpareNum));
        }
        if (this.httpsPort != this.upgradeHttpsPort) {
            result.add(this.buildHttpsConnector(this.upgradeHttpsPort, eapHome, conf, retry, path, tomcatMinSpareNum));
        }
        Integer managePort = Integer.valueOf(System.getProperty("manage.http.port"));
        Integer portalPort = Integer.valueOf(System.getProperty("portal.http.port"));
        if (!Objects.equals(portalPort, managePort)) {
            Connector httpConnector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
            httpConnector.setScheme(HTTP);
            httpConnector.setPort(portalPort.intValue());
            httpConnector.setAsyncTimeout(300000L);
            httpConnector.setMaxPostSize(0x300000);
            httpConnector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
            Http11NioProtocol protocol = (Http11NioProtocol)httpConnector.getProtocolHandler();
            protocol.setMinSpareThreads(tomcatMinSpareNum.intValue());
            protocol.setCompression("on");
            protocol.setCompressibleMimeType("text/html,text/xml,text/plain,text/css,text/javascript,application/javascript,application/xml");
            result.add(httpConnector);
        }
        if (Objects.equals("1", System.getProperty("hiability.mode")) || Objects.equals("2", System.getProperty("hiability.mode"))) {
            result.add(this.buildHttpsConnector(ab.j(), eapHome, conf, retry, path, tomcatMinSpareNum));
        }
        return result.toArray(new Connector[0]);
    }

    private Connector buildHttpsConnector(int httpsPort, String eapHome, b configuration, boolean retry, String path, Integer tomcatMinSpareNum) {
        Connector httpsConnector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        httpsConnector.setScheme(HTTPS);
        httpsConnector.setPort(httpsPort);
        httpsConnector.setSecure(true);
        httpsConnector.setProperty("SSLEnabled", "true");
        SSLHostConfig httpsSSLConfig = this.initSSLHostConfig(eapHome, configuration, retry, path);
        httpsConnector.addSslHostConfig(httpsSSLConfig);
        httpsConnector.setAsyncTimeout(300000L);
        httpsConnector.setMaxPostSize(0x300000);
        httpsConnector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        Http11NioProtocol protocol = (Http11NioProtocol)httpsConnector.getProtocolHandler();
        protocol.setMinSpareThreads(tomcatMinSpareNum.intValue());
        protocol.setCompression("on");
        protocol.setCompressibleMimeType("text/html,text/xml,text/plain,text/css,text/javascript,application/javascript,application/xml");
        return httpsConnector;
    }

    private SSLHostConfig initSSLHostConfig(String eapHome, b conf, boolean retry, String path) {
        String uri = conf.a("eap.mongod.uri");
        ServerCertConfig config = this.serverCertProvider.readConfig(uri);
        SSLHostConfig httpsSSLConfig = new SSLHostConfig();
        SSLHostConfigCertificate defaultCertificate = new SSLHostConfigCertificate(httpsSSLConfig, SSLHostConfigCertificate.Type.UNDEFINED);
        httpsSSLConfig.addCertificate(defaultCertificate);
        if (retry) {
            defaultCertificate.setCertificateKeystoreFile(eapHome + "/data/keystore/eap.keystore");
            defaultCertificate.setCertificateKeystorePassword(X509CertificateUtils.b());
            return httpsSSLConfig;
        }
        if (config.isEnable() && (config.isCrossVersion() ? this.handleV4Certificate(eapHome, httpsSSLConfig, config) : this.handleCertificate(httpsSSLConfig, config))) {
            return httpsSSLConfig;
        }
        defaultCertificate.setCertificateKeystoreFile(path);
        defaultCertificate.setCertificateKeystorePassword(X509CertificateUtils.b());
        httpsSSLConfig.setProtocols("-TLSv1-TLSv1.1+TLSv1.2+TLSv1.3");
        httpsSSLConfig.setCiphers("HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!kRSA:!RSA:!CAMELLIA:!LOW:!3DES:!EXP:!PSK:!SRP:!DSS:!SHA1:!SHA256:!SHA384");
        return httpsSSLConfig;
    }

    private boolean handleV4Certificate(String eapHome, SSLHostConfig httpsSSLConfig, ServerCertConfig config) {
        boolean isSuccess = false;
        File file = new File(eapHome + "/data/cer/jetty.jks");
        if (!this.verifyCertificateV4(file, config.getKeyPassword())) {
            log.warn("Certificate is invalid.Try to use default certificate.");
            return false;
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(inputStream, config.getKeyPassword().toCharArray());
            SSLHostConfigCertificate defaultCer = (SSLHostConfigCertificate)httpsSSLConfig.getCertificates().toArray()[0];
            defaultCer.setCertificateKeystoreFile("NONE");
            defaultCer.setCertificateKeystorePassword(config.getKeyPassword());
            defaultCer.setCertificateKeystoreType(System.getProperty("javax.net.ssl.keyStoreType", "JKS"));
            defaultCer.setCertificateKeystore(ks);
            defaultCer.setCertificateKeystorePassword(config.getKeyPassword());
            isSuccess = true;
        }
        catch (KeyStoreException e2) {
            log.warn("KeyStoreException in initSSLHostConfig", (Throwable)e2);
        }
        catch (IOException e3) {
            log.warn("IOException in initSSLHostConfig", (Throwable)e3);
        }
        catch (NoSuchAlgorithmException e4) {
            log.warn("NoSuchAlgorithmException in initSSLHostConfig", (Throwable)e4);
        }
        catch (CertificateException e5) {
            log.warn("CertificateException in initSSLHostConfig", (Throwable)e5);
        }
        return isSuccess;
    }

    private boolean handleCertificate(SSLHostConfig httpsSSLConfig, ServerCertConfig config) {
        boolean isSuccess = false;
        if (!this.verifyCertificate(config.getCerFileId(), config.getKeyPassword())) {
            log.warn("Certificate is invalid.Try to use default certificate.");
            return false;
        }
        try (InputStream inputStream = this.fileRepository.readFile(config.getCerFileId());){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(inputStream, config.getKeyPassword().toCharArray());
            SSLHostConfigCertificate defaultCer = (SSLHostConfigCertificate)httpsSSLConfig.getCertificates().toArray()[0];
            defaultCer.setCertificateKeystoreFile("NONE");
            defaultCer.setCertificateKeystorePassword(config.getKeyPassword());
            defaultCer.setCertificateKeystoreType(System.getProperty("javax.net.ssl.keyStoreType", "JKS"));
            defaultCer.setCertificateKeystore(ks);
            defaultCer.setCertificateKeystorePassword(config.getKeyPassword());
            isSuccess = true;
        }
        catch (KeyStoreException e2) {
            log.warn("KeyStoreException in initSSLHostConfig", (Throwable)e2);
        }
        catch (IOException e3) {
            log.warn("IOException in initSSLHostConfig", (Throwable)e3);
        }
        catch (NoSuchAlgorithmException e4) {
            log.warn("NoSuchAlgorithmException in initSSLHostConfig", (Throwable)e4);
        }
        catch (CertificateException e5) {
            log.warn("CertificateException in initSSLHostConfig", (Throwable)e5);
        }
        return isSuccess;
    }

    private boolean verifyCertificate(String cerId, String keyPassword) {
        block12: {
            boolean bl;
            block11: {
                InputStream inputStream = this.fileRepository.readFile(cerId);
                try {
                    bl = X509CertificateUtils.a((InputStream)inputStream, (String)keyPassword);
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (KeyStoreException e2) {
                        log.warn("KeyStoreException in initSSLHostConfig", (Throwable)e2);
                        break block12;
                    }
                    catch (IOException e3) {
                        log.warn("IOException in initSSLHostConfig", (Throwable)e3);
                        break block12;
                    }
                    catch (NoSuchAlgorithmException e4) {
                        log.warn("NoSuchAlgorithmException in initSSLHostConfig", (Throwable)e4);
                        break block12;
                    }
                    catch (CertificateException e5) {
                        log.warn("CertificateException in initSSLHostConfig", (Throwable)e5);
                    }
                }
                inputStream.close();
            }
            return bl;
        }
        return false;
    }

    private boolean verifyCertificateV4(File cerFile, String keyPassword) {
        block10: {
            boolean bl;
            FileInputStream inputStream = new FileInputStream(cerFile);
            try {
                bl = X509CertificateUtils.a((InputStream)inputStream, (String)keyPassword);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (KeyStoreException e2) {
                    log.warn("KeyStoreException in initSSLHostConfig", (Throwable)e2);
                    break block10;
                }
                catch (IOException e3) {
                    log.warn("IOException in initSSLHostConfig", (Throwable)e3);
                    break block10;
                }
                catch (NoSuchAlgorithmException e4) {
                    log.warn("NoSuchAlgorithmException in initSSLHostConfig", (Throwable)e4);
                    break block10;
                }
                catch (CertificateException e5) {
                    log.warn("CertificateException in initSSLHostConfig", (Throwable)e5);
                }
            }
            ((InputStream)inputStream).close();
            return bl;
        }
        return false;
    }

    @Autowired
    public void setServerCertProvider(ServerCertProvider serverCertProvider) {
        this.serverCertProvider = serverCertProvider;
    }

    @Autowired
    public void setFileRepository(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }
}

