/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.port.local;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.apigateway.port.local.ApiRegister;
import com.tplink.smb.omada.common.obfuscate.KeepClassName;
import com.tplink.smb.omada.common.omadac.a;
import com.tplink.smb.omada.dispatcher.annotation.Api;
import com.tplink.smb.omada.dispatcher.annotation.AppApi;
import com.tplink.smb.omada.dispatcher.cache.ApiServiceCache;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.common.access.HttpMethod;
import com.tplink.smb.omada.dispatcher.common.access.ServiceType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
@Lazy(value=false)
@KeepClassName
public class ApiServiceCacheInitializer
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private ApiServiceCache apiServiceCache;
    private ApiRegister apiRegister;

    @PostConstruct
    public void registerAll() {
        for (Class<?> clazz : this.apiRegister.getApiServices()) {
            this.resolveApiAndRegisterService(clazz);
        }
    }

    public <T> void resolveApiAndRegisterService(Class<T> clazz) {
        if (a.a) {
            List apiMethods = MethodUtils.getMethodsListWithAnnotation(clazz, Api.class);
            List appApiMethods = MethodUtils.getMethodsListWithAnnotation(clazz, AppApi.class);
            HashSet apiMethodSet = new HashSet(Math.min(apiMethods.size() + appApiMethods.size(), 2));
            apiMethodSet.addAll(apiMethods);
            apiMethodSet.addAll(appApiMethods);
            apiMethodSet.forEach(method -> {
                try {
                    method.invoke(null, new Object[method.getParameterCount()]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        for (Method method2 : clazz.getDeclaredMethods()) {
            AppApi appApiAnnotation;
            Api annotation = (Api)AnnotationUtils.findAnnotation((Method)method2, Api.class);
            if (annotation != null) {
                this.apiServiceCache.register((ServiceMethodInfo)new com.tplink.smb.omada.dispatcher.cache.LazyServiceMethodInfo(annotation.path(), annotation.method(), method2, () -> this.getService(clazz), (Set)Sets.newHashSet((Object[])annotation.requires()), annotation.service(), (Set)Sets.newHashSet((Object[])annotation.encryptKeys())));
            }
            if ((appApiAnnotation = (AppApi)AnnotationUtils.findAnnotation((Method)method2, AppApi.class)) == null) continue;
            this.apiServiceCache.register((ServiceMethodInfo)new com.tplink.smb.omada.dispatcher.cache.LazyServiceMethodInfo(appApiAnnotation.path(), appApiAnnotation.method(), method2, () -> this.getService(clazz), (Set)Sets.newHashSet((Object[])appApiAnnotation.requires()), appApiAnnotation.service(), (Set)Sets.newHashSet((Object[])appApiAnnotation.encryptKeys())));
        }
    }

    private <T> T getService(Class<T> clazz) {
        return (T)this.applicationContext.getBean(clazz);
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Autowired
    public void setApiServiceCache(ApiServiceCache apiServiceCache) {
        this.apiServiceCache = apiServiceCache;
    }

    @Autowired
    public void setApiRegister(ApiRegister apiRegister) {
        this.apiRegister = apiRegister;
    }

    private static class LazyServiceMethodInfo
    extends ServiceMethodInfo {
        @Nonnull
        private final Supplier<Object> delaySupplier;
        @Nullable
        private Object actualService;

        public LazyServiceMethodInfo(String path, HttpMethod[] httpMethods, Method method, @Nonnull Supplier<Object> delaySupplier, Set<String> permissions, ServiceType serviceType, Set<String> encryptFields) {
            super(path, httpMethods, method, null, permissions, serviceType, null, encryptFields);
            this.delaySupplier = delaySupplier;
        }

        public Object getService() {
            if (this.actualService == null) {
                this.actualService = this.delaySupplier.get();
            }
            return this.actualService;
        }

        @Nonnull
        @Generated
        public Supplier<Object> getDelaySupplier() {
            return this.delaySupplier;
        }

        @Nullable
        @Generated
        public Object getActualService() {
            return this.actualService;
        }
    }
}

