/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InitStatusCache {
    private static volatile Integer status;

    private InitStatusCache() {
    }

    public static void setStatus(Integer status) {
        InitStatusCache.status = status;
    }

    public static InitStatusCheckResult initOk() {
        if (status == null) {
            status = InitStatusEnum.INIT.status;
            return new InitStatusCheckResult(status, InitStatusEnum.INIT.description);
        }
        InitStatusEnum initStatusEnum = InitStatusEnum.resolve(status);
        return new InitStatusCheckResult(status, initStatusEnum.description);
    }

    public static enum InitStatusEnum {
        ERROR(-1, "Something error."),
        INIT(0, "Executing init data task, please wait"),
        FINISH(1, "InitTask done.");

        private int status;
        private String description;
        private static final Map<Integer, InitStatusEnum> STATUS_MAP;

        private InitStatusEnum(int status, String description) {
            this.status = status;
            this.description = description;
        }

        public static InitStatusEnum resolve(Integer status) {
            if (status == null) {
                return ERROR;
            }
            return STATUS_MAP.get(status);
        }

        public int getStatus() {
            return this.status;
        }

        public String getDescription() {
            return this.description;
        }

        static {
            STATUS_MAP = Arrays.stream(InitStatusEnum.values()).collect(Collectors.toMap(InitStatusEnum::getStatus, entry -> entry));
        }
    }

    public static class InitStatusCheckResult {
        private int status;
        private String description;

        @Generated
        public int getStatus() {
            return this.status;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public InitStatusCheckResult(int status, String description) {
            this.status = status;
            this.description = description;
        }

        @Generated
        public InitStatusCheckResult() {
        }
    }
}

