/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.server.b;

import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.e.e;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerAdapter;
import com.tplink.smb.rtty.protocol.RttyDeviceStateEnum;
import com.tplink.smb.rtty.protocol.packet.RttyMessage;
import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import com.tplink.smb.rtty.protocol.packet.message.manager.DeviceDisconnectExceptionMessage;
import com.tplink.smb.rtty.protocol.packet.message.manager.DeviceDisconnectNormallyMessage;
import com.tplink.smb.rtty.protocol.packet.message.manager.RttyManagerMessage;
import com.tplink.smb.rtty.server.a.b;
import com.tplink.smb.rtty.server.b.a;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class c
extends ChannelHandlerAdapter {
    private static final Logger a = LoggerFactory.getLogger(c.class);
    private final a b;
    private final com.tplink.smb.rtty.server.a.a c;
    private final EcspServerProperties d;
    private final com.tplink.smb.rtty.server.c.a e;

    public c(a serverCenter, com.tplink.smb.rtty.server.a.a rttyHandlerStrategyFactory, EcspServerProperties rttyServerProperties, com.tplink.smb.rtty.server.c.a rttySendEventService) {
        this.b = serverCenter;
        this.c = rttyHandlerStrategyFactory;
        this.d = rttyServerProperties;
        this.e = rttySendEventService;
    }

    public void received(Channel channel, Object packet) throws RemotingException {
        super.received(channel, packet);
        a.debug("-------------- received rtty data packet, parsing channel: {}-----------", (Object)channel);
        RttyMessage rttyMessage = com.tplink.smb.rtty.server.a.c.a((RttyPacket)packet);
        if (Objects.nonNull(rttyMessage) && rttyMessage.isValid()) {
            if (RttyMessageType.TERMDATA.equals((Object)RttyMessageType.fromInteger((int)rttyMessage.getType()))) {
                this.a(rttyMessage, channel, this.b);
            } else {
                this.c.a(() -> {
                    try {
                        this.a(rttyMessage, channel, this.b);
                    }
                    catch (Exception e2) {
                        a.warn("handle exception: {}, rtty message: {}", (Object)e2, (Object)rttyMessage);
                    }
                });
            }
        } else {
            a.warn("invalid device packet {}, data {}. close channel {}", new Object[]{packet, rttyMessage, channel});
            channel.close();
        }
    }

    private void a(RttyMessage rttyMessage, Channel channel, a serverCenter) throws RemotingException {
        boolean neededSendToManager = false;
        ServerMonitor.incIncomingRttyTcpCounter((RttyMessageType)RttyMessageType.fromInteger((int)rttyMessage.getType()));
        switch (RttyMessageType.fromInteger((int)rttyMessage.getType())) {
            case REGISTER: {
                if (!this.c.a(com.tplink.smb.rtty.server.a.b.a, rttyMessage, channel, serverCenter)) break;
                neededSendToManager = true;
                break;
            }
            case LOGIN: {
                if (!this.c.a(com.tplink.smb.rtty.server.a.b.b, rttyMessage, channel, serverCenter)) break;
                neededSendToManager = true;
                break;
            }
            case TERMDATA: {
                if (!this.c.a(com.tplink.smb.rtty.server.a.b.d, rttyMessage, channel, serverCenter)) break;
                neededSendToManager = true;
                break;
            }
            case LOGOUT: {
                if (!this.c.a(com.tplink.smb.rtty.server.a.b.c, rttyMessage, channel, serverCenter)) break;
                neededSendToManager = true;
                break;
            }
            case HEARTBEAT: {
                if (!this.c.a(com.tplink.smb.rtty.server.a.b.g, rttyMessage, channel, serverCenter)) break;
                neededSendToManager = true;
                break;
            }
            default: {
                a.warn("rtty server do not handle messageType {}, close {}", (Object)rttyMessage.getType(), (Object)channel);
                this.disconnected(channel);
            }
        }
        if (neededSendToManager) {
            this.a(rttyMessage, channel);
        }
    }

    private void a(RttyMessage rttyMessage, Channel channel) {
        Integer grpcPort = this.d.getGrpcPort();
        AddressDTO addressDTO = com.tplink.smb.ecsp.server.e.e.a(channel, grpcPort);
        String deviceMac = this.b.b(channel);
        this.e.a(rttyMessage, addressDTO, deviceMac);
    }

    public void connected(Channel channel) throws RemotingException {
        super.connected(channel);
        if (!this.d.isEnableHandleNewChannel()) {
            channel.close();
            ServerMonitor.incRttyRefuseDeviceConnectCounter();
        }
        a.trace("Rtty server new channel {} connected.", (Object)channel);
        ServerMonitor.getRttyConnectionsGauge().incrementAndGet();
    }

    public void disconnected(Channel channel) throws RemotingException {
        super.disconnected(channel);
        if (Objects.isNull(channel)) {
            return;
        }
        ServerMonitor.getRttyConnectionsGauge().decrementAndGet();
        String deviceMac = this.b.b(channel);
        if (Objects.isNull(deviceMac)) {
            return;
        }
        ServerMonitor.incRttyDeviceDisconnectedCounter();
        com.tplink.smb.rtty.server.a deviceContext = this.b.a(deviceMac);
        Object rttyManagerMessage = RttyDeviceStateEnum.CONNECTED.equals((Object)deviceContext.e()) ? new DeviceDisconnectExceptionMessage(deviceMac) : new DeviceDisconnectNormallyMessage(deviceMac);
        Integer grpcPort = this.d.getGrpcPort();
        AddressDTO addressDTO = com.tplink.smb.ecsp.server.e.e.a(channel, grpcPort);
        this.e.a(addressDTO, (RttyManagerMessage)rttyManagerMessage);
        this.b.e(deviceMac);
        a.debug("rtty server channel {} disconnected.", (Object)channel);
    }

    public void caught(Channel channel, Throwable exception) throws RemotingException {
        super.caught(channel, exception);
        a.warn("rtty handler caught channel:{}, exception: {}", (Object)channel, (Object)exception);
    }
}

