/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.rtty.server.b;

import com.tplink.smb.ecsp.common.exception.TransError;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.message.grpc.DeviceSocketDTO;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.l;
import com.tplink.smb.ecsp.server.m;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.Server;
import com.tplink.smb.ecsp.transport.api.Transporters;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerAdapter;
import com.tplink.smb.rtty.message.grpc.RttyGrpcDTO;
import com.tplink.smb.rtty.protocol.RttyDeviceStateEnum;
import com.tplink.smb.rtty.protocol.packet.RttyMessage;
import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import com.tplink.smb.rtty.protocol.packet.RttyTransMessage;
import com.tplink.smb.rtty.protocol.packet.message.LogoutMessage;
import com.tplink.smb.rtty.server.a.a.f;
import com.tplink.smb.rtty.server.a.b;
import com.tplink.smb.rtty.server.b.c;
import io.reactivex.Single;
import io.reactivex.subjects.Subject;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a
implements m,
com.tplink.smb.rtty.server.c.c {
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Resource
    private Transporters b;
    @Resource
    private EcspServerProperties c;
    @Resource
    private com.tplink.smb.rtty.server.a.a d;
    @Resource
    private com.tplink.smb.rtty.server.c.a e;
    @Resource
    private l f;
    private final ConcurrentHashMap<Integer, Server> g = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ServerType> h = new ConcurrentHashMap();
    private final ConcurrentHashMap<Channel, String> i = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, com.tplink.smb.rtty.server.a> j = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, f> k = new ConcurrentHashMap();

    @Override
    public ConcurrentHashMap<Integer, Server> a() {
        return this.g;
    }

    @Override
    public ConcurrentHashMap<Integer, ServerType> b() {
        return this.h;
    }

    @Override
    public ChannelHandlerAdapter c() {
        return new c(this, this.d, this.c, this.e);
    }

    @Override
    public Transporters d() {
        return this.b;
    }

    @Override
    public Logger e() {
        return a;
    }

    public Single<OperationResponse<RttyMessage>> a(RttyGrpcDTO rttyGrpcDTO) {
        String deviceMac = rttyGrpcDTO.getDeviceMac();
        RttyMessage rttyMessage = rttyGrpcDTO.getRttyMessage();
        a.debug("send tcp data msg: {}", (Object)rttyGrpcDTO);
        RttyPacket rttyPacket = rttyMessage.toRttyPacket();
        if (Objects.isNull(rttyPacket)) {
            return Single.just((Object)OperationResponse.error((Integer)1000, (String)TransError.getDefaultErrorMessage((int)1000)));
        }
        com.tplink.smb.rtty.server.a deviceContext = this.a(deviceMac);
        if (Objects.isNull(deviceContext)) {
            return Single.just((Object)OperationResponse.error((Integer)400, (String)TransError.getDefaultErrorMessage((int)400)));
        }
        Channel channel = deviceContext.c();
        long waitTimeout = rttyGrpcDTO.getTimeout();
        switch (RttyMessageType.fromInteger((int)rttyMessage.getType())) {
            case REGISTER: {
                try {
                    if (!this.d.a(com.tplink.smb.rtty.server.a.b.i, rttyMessage, channel, this)) {
                        return this.a(rttyPacket, channel).flatMap(sendResult -> {
                            if (!sendResult.isOk()) {
                                return Single.just((Object)new OperationResponse(sendResult.getErrorCode(), (Object)new RttyMessage()));
                            }
                            ServerMonitor.incOutgoingRttyTcpCounter((RttyMessageType)RttyMessageType.REGISTER);
                            return Single.just((Object)new OperationResponse(sendResult.getErrorCode(), (Object)new RttyMessage()));
                        }).timeout(waitTimeout, TimeUnit.MILLISECONDS).doFinally(() -> ((Channel)channel).close());
                    }
                }
                catch (RemotingException e2) {
                    a.warn("handle rtty message: {}, exception: {}", (Object)rttyGrpcDTO, (Object)e2);
                }
                break;
            }
            case LOGOUT: {
                LogoutMessage logoutMessage = (LogoutMessage)rttyMessage;
                this.d(logoutMessage.getSid());
                break;
            }
        }
        return this.a(rttyPacket, channel).flatMap(sendResult -> {
            if (!sendResult.isOk()) {
                return Single.just((Object)new OperationResponse(sendResult.getErrorCode(), (Object)new RttyMessage()));
            }
            ServerMonitor.incOutgoingRttyTcpCounter((RttyMessageType)RttyMessageType.fromInteger((int)rttyMessage.getType()));
            boolean needWaitResponse = this.a((Integer)rttyMessage.getType());
            if (!needWaitResponse) {
                return Single.just((Object)new OperationResponse(sendResult.getErrorCode(), (Object)new RttyMessage()));
            }
            Subject<RttyTransMessage> responseResultSubject = this.a(deviceMac, rttyMessage.getType());
            if (Objects.isNull(responseResultSubject)) {
                return Single.just((Object)new OperationResponse(Integer.valueOf(400), (Object)new RttyMessage()));
            }
            return responseResultSubject.filter(message -> this.a(deviceMac, rttyMessage.getType(), (RttyTransMessage)message)).firstOrError().map(responseMessage -> {
                if (!responseMessage.getRttyMessage().isValid()) {
                    a.warn("send tcp data failed because of disconnect, mac: {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                    return OperationResponse.error((Integer)7500, (Object)new RttyMessage());
                }
                return OperationResponse.ok((Object)new RttyMessage());
            });
        }).doFinally(() -> this.b(deviceMac, rttyMessage.getType())).timeout(waitTimeout, TimeUnit.MILLISECONDS);
    }

    protected Single<OperationResponse<Void>> a(@Nonnull RttyPacket packet, @Nonnull Channel channel) {
        if (!this.a(channel)) {
            return Single.just((Object)OperationResponse.error((Integer)8000, (String)("Failed to send tcp data  cause: not connect channel " + channel)));
        }
        return channel.send((Object)packet).map(aBoolean -> Boolean.TRUE.equals(aBoolean) ? OperationResponse.ok() : OperationResponse.error((Integer)7500));
    }

    public com.tplink.smb.rtty.server.a a(String deviceMac) {
        return this.j.get(deviceMac);
    }

    public void a(String deviceMac, com.tplink.smb.rtty.server.a deviceContext) {
        this.j.put(deviceMac, deviceContext);
    }

    public void b(String deviceMac) {
        this.j.remove(deviceMac);
    }

    public String b(Channel channel) {
        return this.i.get(channel);
    }

    public void a(Channel channel, String deviceMac) {
        this.i.put(channel, deviceMac);
    }

    public void c(Channel channel) {
        this.i.remove(channel);
    }

    public f c(String sessionId) {
        return k.getOrDefault(sessionId, new f());
    }

    public void a(String sessionId, f terminalSessionInfo) {
        k.put(sessionId, terminalSessionInfo);
    }

    public void d(String sessionId) {
        if (Objects.nonNull(sessionId)) {
            this.e.a(sessionId);
            k.remove(sessionId);
        }
    }

    public void e(String deviceMac) {
        com.tplink.smb.rtty.server.a deviceContext = this.a(deviceMac);
        if (Objects.isNull(deviceContext)) {
            return;
        }
        if (!RttyDeviceStateEnum.DISCONNECT.equals((Object)deviceContext.e())) {
            deviceContext.a(RttyDeviceStateEnum.DISCONNECT);
            this.a(deviceMac, deviceContext);
        }
    }

    private boolean a(Integer rttyMessageType) {
        return RttyMessageType.HEARTBEAT.equals((Object)RttyMessageType.fromInteger((int)rttyMessageType));
    }

    private Subject<RttyTransMessage> a(String deviceMac, Integer messageType) {
        switch (RttyMessageType.fromInteger((int)messageType)) {
            case HEARTBEAT: {
                return this.g().a(deviceMac, messageType);
            }
        }
        return null;
    }

    private void b(String deviceMac, Integer messageType) {
        this.g().c(deviceMac, messageType);
    }

    private l g() {
        return this.f;
    }

    private boolean a(String deviceMac, Integer messageType, RttyTransMessage message) {
        return deviceMac.equals(message.getDeviceMac()) && messageType.equals(message.getRttyMessage().getType());
    }

    public void a(String deviceMac, RttyMessage rttyMessage) {
        RttyMessageType.fromInteger((int)rttyMessage.getType());
        Subject<RttyTransMessage> responseResultSubject = this.g().b(deviceMac, rttyMessage.getType());
        if (responseResultSubject != null) {
            responseResultSubject.onNext((Object)new RttyTransMessage(deviceMac, rttyMessage));
        } else {
            a.debug("publish response failed for {}, type = {}, cause subject is null", (Object)deviceMac, (Object)rttyMessage.getType());
        }
    }

    public Single<OperationResponse<Void>> a(DeviceSocketDTO deviceSocketDTO) {
        String deviceMac = deviceSocketDTO.getDeviceMac();
        com.tplink.smb.rtty.server.a deviceContext = this.a(deviceMac);
        if (Objects.isNull(deviceContext)) {
            a.debug("need not to close channel for mac {}, cause device context is null", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            return Single.just((Object)OperationResponse.ok());
        }
        Channel channel = deviceContext.c();
        if (Boolean.TRUE.equals(deviceSocketDTO.getRemoveDeviceContext())) {
            this.b(deviceMac);
            this.c(channel);
        }
        if (this.a(channel)) {
            channel.close();
        }
        return Single.just((Object)OperationResponse.ok());
    }

    @Override
    public void f() {
        m.super.f();
        this.i.clear();
        this.j.clear();
        k.clear();
    }
}

