/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.e;

import com.tplink.smb.ecsp.a.a.b;
import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.exception.TransException;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.message.grpc.DeviceSocketDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceTimeoutDTO;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.server.n;
import com.tplink.smb.ecsp.transport.api.Channel;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class e {
    private static final Logger a = LoggerFactory.getLogger(e.class);

    private e() {
    }

    public static AddressDTO a(@Nonnull Channel channel, Integer serverGrpcPort) {
        String serverIp = channel.getLocalAddress().getAddress().getHostAddress();
        if (Objects.isNull(serverGrpcPort)) {
            TransException exception = new TransException(2, "[error] grpc.server.port can not be null");
            a.error("", (Throwable)exception);
            throw exception;
        }
        return new AddressDTO(serverIp, serverGrpcPort);
    }

    public static void a(@Nonnull String deviceMac, @Nullable AddressDTO localServerRoute, @Nullable AddressDTO adoptServerRoute, @Nullable AddressDTO manageServerRoute, @Nullable n executorService, @Nullable b deviceGatewayService, long timeout) {
        if (Objects.isNull(deviceGatewayService)) {
            return;
        }
        e.a(executorService, () -> {
            if (Objects.nonNull(adoptServerRoute) && !Objects.equals(adoptServerRoute, localServerRoute)) {
                e.b(deviceMac, adoptServerRoute, deviceGatewayService, timeout);
            }
            if (Objects.nonNull(manageServerRoute) && !Objects.equals(manageServerRoute, localServerRoute) && !Objects.equals(manageServerRoute, adoptServerRoute)) {
                e.b(deviceMac, manageServerRoute, deviceGatewayService, timeout);
            }
        });
    }

    private static void b(@Nonnull String deviceMac, @Nonnull AddressDTO oldServerRoute, @Nonnull b deviceGatewayService, long timeout) {
        deviceGatewayService.a(new DeviceSocketDTO(deviceMac, oldServerRoute)).timeout(timeout, TimeUnit.MILLISECONDS).subscribe((response, throwable) -> {
            if (Objects.nonNull(throwable)) {
                a.warn(throwable.getMessage(), throwable);
                return;
            }
            if (response.isOk()) {
                a.debug("set device offline success, mac = {}, address = {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)oldServerRoute);
            } else {
                a.info("set device offline failed, mac = {}, address = {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)oldServerRoute);
            }
        });
    }

    public static void a(@Nonnull String deviceMac, @Nullable AddressDTO localServerRoute, @Nonnull AddressDTO upgradeServerRoute, @Nullable n executorService, @Nullable b deviceGatewayService, long timeout) {
        if (Objects.isNull(deviceGatewayService) || Objects.equals(upgradeServerRoute, localServerRoute)) {
            return;
        }
        e.a(executorService, () -> deviceGatewayService.b(new DeviceSocketDTO(deviceMac, upgradeServerRoute)).timeout(timeout, TimeUnit.MILLISECONDS).subscribe((response, throwable) -> {
            if (Objects.nonNull(throwable)) {
                a.warn(throwable.getMessage(), throwable);
                return;
            }
            if (response.isOk()) {
                a.debug("close old upgrade channel success, mac = {}, address = {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)upgradeServerRoute);
            } else {
                a.info("close old upgrade channel failed, mac = {}, address = {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)upgradeServerRoute);
            }
        }));
    }

    public static void a(@Nonnull String deviceMac, @Nullable AddressDTO localServerRoute, @Nonnull AddressDTO manageServerRoute, @Nullable n executorService, @Nullable b deviceGatewayService, long deviceContextTimeout, long timeout) {
        if (Objects.isNull(deviceGatewayService) || Objects.equals(manageServerRoute, localServerRoute)) {
            return;
        }
        e.a(executorService, () -> deviceGatewayService.a(new DeviceTimeoutDTO(deviceMac, deviceContextTimeout, manageServerRoute)).timeout(timeout, TimeUnit.MILLISECONDS).subscribe((response, throwable) -> {
            if (Objects.nonNull(throwable)) {
                a.warn(throwable.getMessage(), throwable);
                return;
            }
            if (response.isOk()) {
                a.debug("update manage timeout success, mac = {}, address = {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)manageServerRoute);
            } else {
                a.info("update manage timeout failed, mac = {}, address = {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)manageServerRoute);
            }
        }));
    }

    public static String a(@Nonnull String deviceMac, @Nullable AddressDTO manageServerRoute, @Nullable b deviceGatewayService, long timeout) {
        OperationResponse response;
        if (Objects.isNull(deviceGatewayService)) {
            return null;
        }
        try {
            response = (OperationResponse)deviceGatewayService.c(new DeviceSocketDTO(deviceMac, manageServerRoute)).timeout(timeout, TimeUnit.MILLISECONDS).blockingGet();
        }
        catch (Exception e2) {
            a.warn("get device context for {} error, exception: ", (Object)deviceMac, (Object)e2);
            return null;
        }
        return (String)response.getResult();
    }

    private static void a(@Nullable n executorService, Runnable runnable) {
        if (Objects.nonNull(executorService)) {
            executorService.a(runnable);
        } else {
            runnable.run();
        }
    }
}

