/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.e;

import com.tplink.smb.ecsp.common.util.InterfaceUtils;
import com.tplink.smb.ecsp.common.util.IpUtils;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.common.util.MacUtils;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.common.util.encrypt.CipherUtils;
import com.tplink.smb.ecsp.common.util.encrypt.RC4Utils;
import com.tplink.smb.ecsp.common.util.encrypt.RsaCipher;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageBody;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.AdoptRequest;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseRebuildResponse;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.PreAdoptRequest;
import com.tplink.smb.ecsp.protocol.packet.header.MessageHeader;
import com.tplink.smb.ecsp.server.e.a;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class c {
    private static final Logger a = LoggerFactory.getLogger(c.class);

    private c() {
    }

    public static EcspMessage a(@Nonnull com.tplink.smb.ecsp.server.context.a deviceContext, int adoptPort) {
        String deviceMac = deviceContext.r();
        MessageHeader header = MessageHeader.builder().version(deviceContext.p()).mac(MacUtils.formatMacCL((String)deviceMac)).type(Integer.valueOf(MessageType.PRE_ADOPT_REQUEST.getValue())).build();
        List allInterfaceAddr = InterfaceUtils.listAllInterfaceAddrs();
        if (CollectionUtils.isEmpty((Collection)allInterfaceAddr) || Objects.isNull(deviceContext.B())) {
            a.warn("Failed to send pre adopt request to {} as no ip found", (Object)deviceMac);
            return null;
        }
        String deviceIp = ((InetSocketAddress)deviceContext.B().getValue()).getAddress().getHostAddress();
        String localIp = IpUtils.getCorrectLocalIp((String)deviceIp, (List)allInterfaceAddr);
        if (localIp == null) {
            localIp = ((InterfaceAddress)allInterfaceAddr.get(0)).getAddress().getHostAddress();
        }
        a.debug("Local ip in pre adopt {} request body is {}", (Object)deviceMac, (Object)localIp);
        PreAdoptRequest body = PreAdoptRequest.builder().mac(MacUtils.formatMacDb((String)deviceContext.r())).ip(localIp).adoptPort(Integer.valueOf(adoptPort)).build();
        return EcspMessage.builder().header(header).body((MessageBody)body).build();
    }

    public static String a(@Nonnull com.tplink.smb.ecsp.server.context.a ecspV1DeviceContext) {
        String signData;
        String hashData;
        String authData;
        MessageHeader header = MessageHeader.builder().version(ecspV1DeviceContext.p()).mac(MacUtils.formatMacCL((String)ecspV1DeviceContext.r())).type(Integer.valueOf(MessageType.ADOPT_REQUEST.getValue())).build();
        try {
            byte[] encodedAuth = ecspV1DeviceContext.h();
            authData = CipherUtils.encryptBASE64((byte[])encodedAuth);
            hashData = CipherUtils.encryptBASE64((byte[])CipherUtils.encryptSHA((byte[])encodedAuth));
            signData = RsaCipher.sign((byte[])encodedAuth);
        }
        catch (Exception e2) {
            a.warn("Build adopt request failed for mac:{} ", (Object)OmadaPIIUtils.encryptWithCache((String)ecspV1DeviceContext.r()), (Object)e2);
            return null;
        }
        AdoptRequest body = new AdoptRequest(authData, hashData, signData);
        return JacksonUtils.pojo2Json((Object)EcspMessage.builder().header(header).body((MessageBody)body).build());
    }

    public static String a(@Nonnull com.tplink.smb.ecsp.server.context.a ecspV1DeviceContext, @Nullable String body, @Nonnull MessageType messageType) {
        MessageHeader header = MessageHeader.builder().version(ecspV1DeviceContext.p()).mac(MacUtils.formatMacCL((String)ecspV1DeviceContext.r())).type(Integer.valueOf(messageType.getValue())).build();
        return body == null ? JacksonUtils.pojo2Json((Object)EcspMessage.builder().header(header).build()) : com.tplink.smb.ecsp.server.e.a.a(header, body);
    }

    public static String a(@Nonnull com.tplink.smb.ecsp.server.context.a ecspV1DeviceContext, @Nonnull String body, byte[] rc4Key) {
        MessageHeader header = MessageHeader.builder().version(ecspV1DeviceContext.p()).mac(MacUtils.formatMacCL((String)ecspV1DeviceContext.r())).type(Integer.valueOf(MessageType.REBUILD_RESPONSE.getValue())).build();
        BaseRebuildResponse rebuildResponse = (BaseRebuildResponse)JacksonUtils.json2Pojo((String)body, BaseRebuildResponse.class);
        String resetConfig = rebuildResponse.getResetConfig();
        if (StringUtils.isNotEmpty((String)resetConfig)) {
            String cryptResetConfig = CipherUtils.encryptBASE64((byte[])RC4Utils.crypt((byte[])resetConfig.getBytes(), (byte[])rc4Key));
            rebuildResponse.setResetConfig(cryptResetConfig);
        }
        return JacksonUtils.pojo2Json((Object)EcspMessage.builder().header(header).body((MessageBody)rebuildResponse).build());
    }
}

