/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.e;

import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.DeviceInfo;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.message.event.DeviceEventFilter;
import com.tplink.smb.ecsp.message.event.DeviceInfoEvent;
import com.tplink.smb.ecsp.message.event.DeviceMessage;
import com.tplink.smb.ecsp.message.event.DeviceMessageEvent;
import com.tplink.smb.ecsp.message.event.EcspV1TopicEnum;
import com.tplink.smb.ecsp.message.event.EcspV2TopicEnum;
import com.tplink.smb.ecsp.message.grpc.EcspAdoptInfo;
import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.NotifyRequest;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.protocol.packet.header.MessageHeader;
import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a {
    private static final Logger a = LoggerFactory.getLogger(a.class);

    private a() {
    }

    public static String a(@Nonnull MessageHeader messageHeader, @Nonnull String bodyStr) {
        String headerStr = JacksonUtils.pojo2Json((Object)messageHeader);
        return "{\"header\":" + headerStr + ",\"body\":" + bodyStr + "}";
    }

    public static void a(EventCenter eventCenter, EcspMessage ecspMessage, EcspAdoptInfo adoptInfo, String topic, Boolean sendWithKey) {
        com.tplink.smb.ecsp.server.e.a.a(eventCenter, ecspMessage, adoptInfo, null, topic, sendWithKey);
    }

    public static void a(EventCenter eventCenter, EcspMessage ecspMessage, EcspAdoptInfo adoptInfo, AddressDTO addressDTO, String topic, Boolean sendWithKey) {
        DeviceMessage deviceMessage = new DeviceMessage(ecspMessage.getMac(), ecspMessage, adoptInfo);
        DeviceEventFilter eventFilterDTO = DeviceEventFilter.buildFromEcspMessage((EcspMessage)ecspMessage, (AddressDTO)addressDTO);
        Event event = ((Event.EventBuilder)((Event.EventBuilder)Event.builder().filterKey(eventFilterDTO.toJson())).message((Object)new DeviceMessageEvent(ecspMessage.getMac(), deviceMessage, null).toJson())).build();
        String deviceMac = ecspMessage.getMac();
        MessageType messageType = MessageType.fromInteger((int)ecspMessage.getMessageType());
        if (Boolean.TRUE.equals(sendWithKey)) {
            if (a.isDebugEnabled()) {
                a.debug("send EcspMessageEvent with key (mac) to topic: {}, mac: {}, message type: {}, seqId: {}, dest: {}, timestamp: {}.", new Object[]{topic, OmadaPIIUtils.encryptWithCache((String)deviceMac), messageType.getType(), ecspMessage.getSeq(), ecspMessage.getDest(), ecspMessage.getTimestamp()});
            }
            eventCenter.send(topic, deviceMac, event);
        } else {
            if (a.isDebugEnabled()) {
                a.debug("send EcspMessageEvent to topic: {}, mac: {}, message type: {}, seqId: {}, dest: {}, timestamp: {}.", new Object[]{topic, OmadaPIIUtils.encryptWithCache((String)deviceMac), messageType.getType(), ecspMessage.getSeq(), ecspMessage.getDest(), ecspMessage.getTimestamp()});
            }
            eventCenter.send(topic, event);
        }
    }

    public static void a(EventCenter eventCenter, DeviceInfo deviceInfo, String topic, Boolean sendWithKey) {
        DeviceEventFilter eventFilterDTO = DeviceEventFilter.buildFromDeviceInfo((DeviceInfo)deviceInfo);
        Event event = ((Event.EventBuilder)((Event.EventBuilder)Event.builder().filterKey(eventFilterDTO.toJson())).message((Object)new DeviceInfoEvent(deviceInfo).toJson())).build();
        String deviceMac = deviceInfo.getMac();
        if (Boolean.TRUE.equals(sendWithKey)) {
            if (a.isDebugEnabled()) {
                a.debug("send DeviceInfoEvent with key (mac) to topic: {}, mac: {}, info type: {}.", new Object[]{topic, OmadaPIIUtils.encryptWithCache((String)deviceMac), deviceInfo.getNetStatus()});
            }
            eventCenter.send(topic, deviceMac, event);
        } else {
            if (a.isDebugEnabled()) {
                a.debug("send DeviceInfoEvent to topic: {}, mac: {}, info type: {}.", new Object[]{topic, OmadaPIIUtils.encryptWithCache((String)deviceMac), deviceInfo.getNetStatus()});
            }
            eventCenter.send(topic, event);
        }
    }

    public static String a(String topicPrefix, EcspVersion ecspVersion) {
        switch (ecspVersion) {
            case VERSION_2: 
            case VERSION_3: {
                return topicPrefix + EcspV2TopicEnum.TOPIC_PROXY_V2_DISCOVERY_UNICAST.getTopicName();
            }
        }
        return topicPrefix + EcspV1TopicEnum.TOPIC_PROXY_V1_DISCOVERY_UNICAST.getTopicName();
    }

    public static String a(ServerType serverType, EcspMessage ecspMessage, MessageType messageType, String topicPrefix) {
        String topic = topicPrefix + EcspV1TopicEnum.resolve((ServerType)serverType, (MessageType)messageType).getTopicName();
        return com.tplink.smb.ecsp.server.e.a.a(ecspMessage, messageType, topic);
    }

    private static String a(EcspMessage ecspMessage, MessageType messageType, String eventTopic) {
        NotifyRequest notifyBody;
        String notifySub;
        if (MessageType.NOTIFY_REQUEST.equals((Object)messageType) && StringUtils.isNotEmpty((String)(notifySub = String.valueOf((notifyBody = (NotifyRequest)ecspMessage.getBody()).getAdditionalProperties().get("sub"))))) {
            eventTopic = (String)eventTopic + "." + notifySub;
        }
        return eventTopic;
    }

    public static String a(String topicPrefix) {
        return topicPrefix + EcspV1TopicEnum.TOPIC_PROXY_V1_DEVICE_STATUS.getTopicName();
    }

    public static String b(String topicPrefix) {
        return topicPrefix + EcspV1TopicEnum.TOPIC_PROXY_V1_UPGRADE_UNICAST.getTopicName();
    }

    public static String b(ServerType serverType, EcspMessage ecspMessage, MessageType messageType, String topicPrefix) {
        String topic = topicPrefix + EcspV2TopicEnum.resolve((ServerType)serverType, (MessageType)messageType).getTopicName();
        return com.tplink.smb.ecsp.server.e.a.a(ecspMessage, messageType, topic);
    }

    public static String c(String topicPrefix) {
        return topicPrefix + EcspV2TopicEnum.TOPIC_PROXY_V2_DEVICE_STATUS.getTopicName();
    }
}

