/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.ecsp.common.EmFragDTO;
import com.tplink.smb.ecsp.common.Pair;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.server.b.b;
import com.tplink.smb.ecsp.server.b.c;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.regex.PatternSyntaxException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class d
implements com.tplink.smb.ecsp.server.c {
    private static final Logger a = LoggerFactory.getLogger(d.class);
    @Resource(name="localLockService")
    private b b;
    @Resource
    private EcspServerProperties c;
    private static final long d = 30000L;
    private Cache<String, EmFragDTO> e;

    @PostConstruct
    void a() {
        this.e = CacheBuilder.newBuilder().maximumSize((long)this.c.getMaxEasyManagerSize()).expireAfterWrite((long)this.c.getEsayManagerCachePeriod(), TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void a(EcspMessage ecspMessage) {
        String deviceMac = ecspMessage.getMac();
        MessageType messageType = MessageType.fromInteger((int)ecspMessage.getMessageType());
        String seqNum = ecspMessage.getSeqNum();
        try {
            Pair<String, Integer> fragSeqPair = this.a(seqNum);
            String fragId = (String)fragSeqPair.getKey();
            Integer seq = (Integer)fragSeqPair.getValue();
            String lockKey = this.c(deviceMac, messageType);
            this.a(lockKey, () -> {
                String ecspMapCacheKey = this.b(deviceMac, messageType);
                EmFragDTO emFragDTO = (EmFragDTO)this.e.getIfPresent((Object)ecspMapCacheKey);
                if (Objects.isNull(emFragDTO)) {
                    if (a.isDebugEnabled()) {
                        a.debug("received the first easy manager frag message of mac: {}, messageType:{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)messageType);
                    }
                    emFragDTO = new EmFragDTO();
                }
                if (!emFragDTO.withSameFragId(fragId)) {
                    a.warn("received other frag message of mac: {}, messageType:{}, origin fragId:{}, new fragId:{}", new Object[]{OmadaPIIUtils.encryptWithCache((String)deviceMac), messageType, emFragDTO.getFragId(), fragId});
                    emFragDTO = new EmFragDTO();
                }
                emFragDTO.getEcspFragList().add(ecspMessage);
                emFragDTO.setFragId(fragId);
                Boolean last = ecspMessage.getLast();
                if (Objects.isNull(last)) {
                    a.warn("try to add not easy manager message in frag cache: mac:{}, messageType:{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)messageType);
                    return false;
                }
                if (last.booleanValue()) {
                    emFragDTO.setMax(seq);
                }
                this.e.put((Object)ecspMapCacheKey, (Object)emFragDTO);
                return true;
            }, () -> a.warn("failed to cache es split message mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
        }
        catch (PatternSyntaxException e2) {
            a.warn("parse seq num in header failed, mac: {}, messageType: {},seqNum: {}, exception: {}", new Object[]{OmadaPIIUtils.encryptWithCache((String)deviceMac), messageType, seqNum, e2});
        }
    }

    @Override
    public OperationResponse<EcspMessage> a(String deviceMac, MessageType messageType) {
        String cacheKey = this.b(deviceMac, messageType);
        EmFragDTO emFragDTO = (EmFragDTO)this.e.getIfPresent((Object)cacheKey);
        if (Objects.isNull(emFragDTO)) {
            return OperationResponse.error((Integer)500);
        }
        if (!emFragDTO.receiveAllFrag()) {
            if (a.isDebugEnabled()) {
                a.debug("wait for next ecspMessage fragment, skip, mac: {}, messageType:{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)messageType);
            }
            return OperationResponse.ok();
        }
        EcspMessage assembleEcspMessage = emFragDTO.mergeCompletedEcspMessage();
        this.d(deviceMac, messageType);
        return OperationResponse.ok((Object)assembleEcspMessage);
    }

    private Pair<String, Integer> a(String seqNum) throws PatternSyntaxException {
        String fragId = seqNum.split("\\.")[0];
        int seq = Integer.parseInt(seqNum.split("\\.")[1]);
        return new Pair((Object)fragId, (Object)seq);
    }

    private boolean a(String lockKey, BooleanSupplier onSuccess, c onFail) {
        Boolean result = null;
        try {
            result = this.b.a("device-split-cache-lock", (Object)lockKey, 30000L, TimeUnit.MILLISECONDS, onSuccess, onFail);
        }
        catch (InterruptedException e2) {
            a.warn("get device lock fail. key = {}, exception: {}", new Object[]{lockKey, e2.getMessage(), e2});
            Thread.currentThread().interrupt();
        }
        return result == null ? Boolean.FALSE : result;
    }

    private String b(String deviceMac, MessageType messageType) {
        return deviceMac + "_" + messageType.getType();
    }

    private String c(String deviceMac, MessageType messageType) {
        return deviceMac + "_" + messageType.getType();
    }

    private void d(String deviceMac, MessageType messageType) {
        String splitMessageCacheKey = this.b(deviceMac, messageType);
        String lockKey = this.c(deviceMac, messageType);
        this.a(lockKey, () -> {
            this.e.invalidate((Object)splitMessageCacheKey);
            return true;
        }, () -> a.warn("failed to remove es cache mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }
}

