/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.context.helper;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.ecsp.common.DeviceInfo;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteCacheUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import com.tplink.smb.ecsp.protocol.DeviceNetStatus;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.server.c.f;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.a;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.context.e;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.eventcenter.api.EventCenter;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;

public class c
implements e,
com.tplink.smb.ecsp.server.context.helper.a {
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Resource
    private CacheService b;
    @Resource
    private LockService c;
    @Resource
    private EventCenter d;
    @Resource
    @Lazy
    private b e;
    @Resource
    private EcspServerProperties f;
    @Resource(name="ecspV1ManageServerCenter")
    private f g;
    private final Subject<DeviceInfo> h = BehaviorSubject.create().toSerialized();
    private final ConcurrentHashMap<Channel, String> i = new ConcurrentHashMap();

    @Override
    public Subject<DeviceInfo> getDeviceInfoSubject() {
        return this.h;
    }

    @Override
    public EcspVersion getEcspVersion() {
        return EcspVersion.VERSION_1;
    }

    @PostConstruct
    public void a() {
        this.h.subscribe(deviceInfo -> {
            String eventTopic = com.tplink.smb.ecsp.server.e.a.a(this.f.getTopicPrefix());
            com.tplink.smb.ecsp.server.e.a.a(this.d, deviceInfo, eventTopic, this.f.isEnableSendEventWithKey());
        });
    }

    @Override
    public void a(String deviceMac, byte[] decryptedKey, ServerRouteDTO serverRouteDTO) {
        boolean updateSuccess = this.e.a(deviceMac, () -> {
            a oldContext = this.e.a(deviceMac);
            if (oldContext == null) {
                a.info("failed to update v1 context to adopt success for {}, cause context is null", (Object)deviceMac);
                return false;
            }
            oldContext.a(DeviceNetStatus.ADOPT_SUCCESS);
            oldContext.a(System.currentTimeMillis());
            oldContext.d(this.f.getDeviceContextTimeout().getAdoptSuccessTimeout());
            oldContext.b();
            this.e.a(deviceMac, oldContext);
            return true;
        }, () -> a.warn("failed to update v1 adopt success device context :{}", (Object)deviceMac));
        if (!updateSuccess) {
            return;
        }
        ServerRouteCacheUtils.doWithTryLock((LockService)this.c, (String)deviceMac, (int)this.f.getTryLockTimeout(), () -> {
            serverRouteDTO.setKey(decryptedKey);
            ServerRouteCacheUtils.setServerRouteCache((String)deviceMac, (ServerRouteDTO)serverRouteDTO, (long)this.f.getAdoptingServerRouteExpire(), (CacheService)this.b);
            return null;
        });
    }

    @Override
    public boolean b(String deviceMac, EcspMessage preConnectInfo, Channel manageChannel) {
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.b);
        if (ServerRouteCacheUtils.isAdoptServerRouteNull((ServerRouteDTO)serverRouteDTO) || Objects.isNull(serverRouteDTO.getKey()) || !ServerRouteCacheUtils.isManageServerRouteNull((ServerRouteDTO)serverRouteDTO)) {
            a.info("device {} server route not match, should close manage channel {}", (Object)deviceMac, (Object)manageChannel);
            return false;
        }
        return this.e.a(deviceMac, () -> {
            a deviceContext = this.e.a(deviceMac);
            if (Objects.isNull(deviceContext)) {
                deviceContext = new a(DeviceType.resolve((String)preConnectInfo.getDeviceType()), EcspVersion.VERSION_1.getVersion(), DeviceNetStatus.CONNECTED, deviceMac, null);
            }
            this.e.a(deviceMac, deviceContext, manageChannel);
            a.debug("update device {} status to CONNECTED", (Object)deviceMac);
            return this.g.a(deviceMac, manageChannel);
        }, () -> a.warn("failed to update manage preConnect deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public boolean a(String deviceMac, String deviceType, Channel manageChannel) {
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.b);
        if (Objects.isNull(serverRouteDTO) || Objects.isNull(serverRouteDTO.getKey()) || Objects.nonNull(serverRouteDTO.getAdoptServerRoute())) {
            a.info("device {} server route not match, should close manage server rebuild channel {}", (Object)deviceMac, (Object)manageChannel);
            return false;
        }
        return this.e.a(deviceMac, () -> {
            a deviceContext;
            a oldContext = this.e.a(deviceMac);
            a a2 = deviceContext = Objects.nonNull(oldContext) ? oldContext : new a(DeviceType.resolve((String)deviceType), EcspVersion.VERSION_1.getVersion(), DeviceNetStatus.CONNECTED, deviceMac, null);
            if (!EcspVersion.isEcspVersion1((String)deviceContext.p())) {
                a.info("device {} context not match, should close manage server channel {}", (Object)deviceMac, (Object)manageChannel);
                return false;
            }
            this.e.a(deviceMac, deviceContext, manageChannel);
            ServerMonitor.incV1DeviceRebuildCounter();
            if (a.isDebugEnabled()) {
                a.debug("update device {} connected status when rebuilding", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            }
            return true;
        }, () -> a.warn("failed to update v1 rebuild context of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public boolean a(String deviceMac, DeviceType deviceType, Channel upgradeChannel) {
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.b);
        if (ServerRouteCacheUtils.isManageServerRouteNull((ServerRouteDTO)serverRouteDTO) || Objects.isNull(serverRouteDTO.getKey())) {
            a.info("device {} server route not match, should close upgrade server channel {}", (Object)deviceMac, (Object)upgradeChannel);
            return false;
        }
        return this.e.a(deviceMac, () -> {
            a oldContext = this.e.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                a.debug("create new empty connected context for device {}", (Object)deviceMac);
                oldContext = new a(deviceType, null, DeviceNetStatus.CONNECTED, deviceMac, null);
            } else {
                Channel oldUpgradeChannel = oldContext.D();
                if (Objects.nonNull(oldUpgradeChannel) && !Objects.equals(oldUpgradeChannel, upgradeChannel)) {
                    oldUpgradeChannel.close();
                }
            }
            oldContext.e(upgradeChannel);
            oldContext.c(System.currentTimeMillis());
            this.e.a(deviceMac, oldContext);
            this.i.put(upgradeChannel, deviceMac);
            a.debug("save device {} upgrade socket {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)upgradeChannel);
            return true;
        }, () -> a.warn("failed to update upgrade preConnect deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public void b(@Nonnull Channel upgradeChannel) {
        String deviceMac = this.i.get(upgradeChannel);
        if (StringUtils.isNull((String)deviceMac)) {
            return;
        }
        this.i.remove(upgradeChannel);
        this.e.a(deviceMac, () -> {
            a oldContext = this.e.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                return;
            }
            if (Objects.nonNull(oldContext.E())) {
                oldContext.e((Channel)null);
                oldContext.c(System.currentTimeMillis());
                this.e.a(deviceMac, oldContext);
                a.debug("update device {} context's upgrade channel {} to null", (Object)deviceMac, (Object)upgradeChannel);
            } else {
                this.e.b(deviceMac);
                a.debug("manage channel in other pod, delete device {} connected context for upgrade", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            }
        }, () -> a.warn("failed to remove upgrade server rout of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
        ServerRouteCacheUtils.doWithTryLock((LockService)this.c, (String)deviceMac, (int)this.f.getTryLockTimeout(), () -> {
            ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.b);
            if (Objects.isNull(serverRouteDTO) || Objects.isNull(serverRouteDTO.getUpgradeServerRoute())) {
                a.info("server route has expired for device {}, need not remove upgrade route", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                return null;
            }
            serverRouteDTO.setUpgradeServerRoute(null);
            ServerRouteCacheUtils.setServerRouteCache((String)deviceMac, (ServerRouteDTO)serverRouteDTO, (long)this.f.getConnectedServerRouteExpire(), (CacheService)this.b);
            return null;
        });
    }

    @Override
    public void sendPreAdoptRequest(String deviceMac, a deviceContext) {
        a.debug("going to send v1 PRE_ADOPT_REQUEST to {}", (Object)deviceMac);
        int adoptServerPort = this.f.getAdoptPortV1() > 0 ? this.f.getAdoptPortV1() : this.g.g();
        EcspMessage preAdoptRequest = com.tplink.smb.ecsp.server.e.c.a(deviceContext, adoptServerPort);
        this.e.a(preAdoptRequest, deviceContext.B());
    }

    @Override
    public Runnable newTimeoutRunnable(String deviceMac, a deviceContext) {
        DeviceNetStatus deviceNetStatus = deviceContext.q();
        return () -> {
            switch (deviceNetStatus) {
                case DISCOVERY: {
                    a.info("pending device {} time out, remove device context", (Object)deviceMac);
                    this.e.b(deviceMac, deviceContext);
                    break;
                }
                case ADOPTING_PENDING_PRE_ADOPT: 
                case ADOPTING_PRE_ADOPT: 
                case ADOPTING_PRE_CONNECT: {
                    a.info("device of status {} time out for {}", (Object)deviceNetStatus, (Object)deviceMac);
                    this.e.c(deviceMac, deviceContext);
                    break;
                }
                case ADOPT_SUCCESS: 
                case CONNECTED: {
                    a.info("device of status {} time out for {}", (Object)deviceNetStatus, (Object)deviceMac);
                    this.e.d(deviceMac, deviceContext);
                    break;
                }
                default: {
                    a.info("Invalid net status {} of {}", (Object)deviceNetStatus, (Object)deviceMac);
                }
            }
        };
    }

    @Override
    public a newTimeoutDeviceContext(a deviceContext) {
        if (deviceContext == null) {
            return null;
        }
        DeviceNetStatus deviceNetStatus = deviceContext.q();
        switch (deviceNetStatus) {
            case ADOPTING_PENDING_PRE_ADOPT: 
            case ADOPTING_PRE_ADOPT: 
            case ADOPTING_PRE_CONNECT: {
                return new a(deviceContext.j(), deviceContext.p(), DeviceNetStatus.DISCOVERY, deviceContext.r(), deviceContext.B());
            }
        }
        return null;
    }

    @Override
    public void closeChannels(a deviceContext) {
        if (deviceContext == null) {
            a.info("needn't closeChannel, cause deviceContext is null.");
            return;
        }
        String deviceMac = deviceContext.r();
        this.a(deviceMac, deviceContext.C());
        this.a(deviceMac, deviceContext.E());
    }
}

