/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.context.helper;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.ecsp.common.DeviceInfo;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.message.cache.AdoptInfoCacheUtils;
import com.tplink.smb.ecsp.message.cache.AdoptInfoDTO;
import com.tplink.smb.ecsp.message.cache.ServerRouteCacheUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import com.tplink.smb.ecsp.message.grpc.EcspAdoptInfo;
import com.tplink.smb.ecsp.protocol.DeviceNetStatus;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.server.c.l;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.a;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.context.f;
import com.tplink.smb.ecsp.server.context.g;
import com.tplink.smb.ecsp.server.e.d;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.eventcenter.api.EventCenter;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcspV2DeviceContextHelper
implements f,
com.tplink.smb.ecsp.server.context.helper.a {
    private static final Logger log = LoggerFactory.getLogger(EcspV2DeviceContextHelper.class);
    @Resource
    private CacheService cacheService;
    @Resource
    private EventCenter eventCenter;
    @Resource
    private LockService lockService;
    @Resource
    private b deviceContextHolder;
    @Resource
    private EcspServerProperties ecspServerProperties;
    @Resource(name="ecspV2ManageServerCenter")
    private l ecspV2ManageServerCenter;
    private final ConcurrentHashMap<Channel, String> transferChannelMap = new ConcurrentHashMap();
    private final Subject<DeviceInfo> deviceInfoSubject = BehaviorSubject.create().toSerialized();
    private static final long DEVICE_CONTEXT_TIMEOUT = 900000L;

    @Override
    public Subject<DeviceInfo> getDeviceInfoSubject() {
        return this.deviceInfoSubject;
    }

    @Override
    public EcspVersion getEcspVersion() {
        return EcspVersion.VERSION_2;
    }

    @PostConstruct
    public void init() {
        this.deviceInfoSubject.subscribe(deviceInfo -> {
            String eventTopic = com.tplink.smb.ecsp.server.e.a.c(this.ecspServerProperties.getTopicPrefix());
            com.tplink.smb.ecsp.server.e.a.a(this.eventCenter, deviceInfo, eventTopic, this.ecspServerProperties.isEnableSendEventWithKey());
        });
    }

    @Override
    public boolean updateV2TransferPreConnectDeviceContext(String deviceMac, DeviceType deviceType, Channel transferChannel) {
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.cacheService);
        if (ServerRouteCacheUtils.isManageServerRouteNull((ServerRouteDTO)serverRouteDTO)) {
            log.info("device {} manage server route is null, should close transfer channel {}", (Object)deviceMac, (Object)transferChannel);
            return false;
        }
        return this.deviceContextHolder.a(deviceMac, () -> {
            a oldContext = this.deviceContextHolder.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                log.info("receive v2 transfer pre connect, create new empty connected context for device {}", (Object)deviceMac);
                oldContext = new a(deviceType, null, DeviceNetStatus.CONNECTED, deviceMac, null);
            } else {
                Channel oldTransferChannel = oldContext.F();
                if (Objects.nonNull(oldTransferChannel) && !Objects.equals(oldTransferChannel, transferChannel)) {
                    oldTransferChannel.close();
                }
            }
            oldContext.g(transferChannel);
            oldContext.d(900000L);
            this.deviceContextHolder.a(deviceMac, oldContext);
            return true;
        }, () -> log.warn("failed to update transfer preConnect deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public void removeEcspV2VerifyInfo(String deviceMac, Channel channel) {
        this.deviceContextHolder.a(deviceMac, () -> {
            a oldContext = this.deviceContextHolder.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                return;
            }
            oldContext.c(channel);
            oldContext.b();
            this.deviceContextHolder.a(deviceMac, oldContext);
        }, () -> log.warn("failed to remove ecspv2 verify info of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public void updateDeviceVerifyDeviceContext(String deviceMac, Channel channel, String randomKeyForDeviceVerify) {
        this.deviceContextHolder.a(deviceMac, () -> {
            a oldContext = this.deviceContextHolder.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                return;
            }
            if (DeviceNetStatus.ADOPTING_PRE_CONNECT.equals((Object)oldContext.q())) {
                oldContext.a(DeviceNetStatus.ADOPTING_DEVICE_VERIFY);
                oldContext.a(System.currentTimeMillis());
                oldContext.d(this.ecspServerProperties.getDeviceContextTimeout().getDeviceVerifyTimeout());
                oldContext.a(channel, new g(randomKeyForDeviceVerify, false, System.currentTimeMillis()));
                this.deviceContextHolder.a(deviceMac, oldContext);
                log.debug("refresh device of {} to ADOPTING_DEVICE_VERIFY status", (Object)deviceMac);
            } else if (DeviceNetStatus.CONNECTED.equals((Object)oldContext.q()) || DeviceNetStatus.ADOPT_SUCCESS.equals((Object)oldContext.q())) {
                oldContext.a(channel, new g(randomKeyForDeviceVerify, false, System.currentTimeMillis()));
                this.deviceContextHolder.a(deviceMac, oldContext);
                if (log.isDebugEnabled()) {
                    log.debug("refresh connected / adopt_success device {} randomKeyForVerify to {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)randomKeyForDeviceVerify);
                }
            }
        }, () -> log.warn("failed to update device verify deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public void updateSystemVerifyDeviceContext(String deviceMac, EcspAdoptInfo ecspAdoptInfo, Channel channel) {
        this.deviceContextHolder.a(deviceMac, () -> {
            a oldContext = this.deviceContextHolder.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                return;
            }
            ArrayList<EcspAdoptInfo> adoptInfoList = new ArrayList<EcspAdoptInfo>();
            adoptInfoList.add(ecspAdoptInfo);
            if (DeviceNetStatus.ADOPTING_DEVICE_VERIFY.equals((Object)oldContext.q())) {
                oldContext.a(DeviceNetStatus.ADOPTING_SYSTEM_VERIFY);
                oldContext.a(System.currentTimeMillis());
                oldContext.d(this.ecspServerProperties.getDeviceContextTimeout().getSystemVerifyTimeout());
                oldContext.a(adoptInfoList);
                oldContext.a(channel);
                this.deviceContextHolder.a(deviceMac, oldContext);
                log.debug("refresh device of {} to ADOPTING_SYSTEM_VERIFY status", (Object)deviceMac);
            } else if (DeviceNetStatus.CONNECTED.equals((Object)oldContext.q()) || DeviceNetStatus.ADOPT_SUCCESS.equals((Object)oldContext.q())) {
                oldContext.a(adoptInfoList);
                oldContext.a(channel);
                this.deviceContextHolder.a(deviceMac, oldContext);
                log.debug("set device verify info valid of {} in connected / adopt_success status", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            }
        }, () -> log.warn("failed to update systemVerify deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public boolean updateV2AdoptSuccessDeviceContext(String deviceMac, Channel manageChannel) {
        return this.deviceContextHolder.a(deviceMac, () -> {
            a oldContext = this.deviceContextHolder.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                return false;
            }
            g v2VerifyInfo = oldContext.b(manageChannel);
            if (Objects.isNull(v2VerifyInfo) || StringUtils.isEmpty((String)v2VerifyInfo.a()) || !v2VerifyInfo.b()) {
                log.info("update adopt success for {} failed, cause verify info not valid for channel {}", (Object)deviceMac, (Object)manageChannel.getRemoteAddress());
                return false;
            }
            if (DeviceNetStatus.ADOPTING_SYSTEM_VERIFY.equals((Object)oldContext.q()) || DeviceNetStatus.CONNECTED.equals((Object)oldContext.q()) || DeviceNetStatus.ADOPT_SUCCESS.equals((Object)oldContext.q())) {
                Channel oldManageChannel = oldContext.E();
                if (Objects.nonNull(oldManageChannel) && !Objects.equals(oldManageChannel, manageChannel)) {
                    oldManageChannel.close();
                }
                if (DeviceNetStatus.CONNECTED.equals((Object)oldContext.q())) {
                    ServerMonitor.incV2DeviceReconnectCounter();
                }
                oldContext.a(DeviceNetStatus.ADOPT_SUCCESS);
                oldContext.a(System.currentTimeMillis());
                oldContext.d(this.ecspServerProperties.getDeviceContextTimeout().getAdoptSuccessTimeout());
                oldContext.f(manageChannel);
                oldContext.e();
                this.deviceContextHolder.a(deviceMac, oldContext);
                log.debug("refresh device of {} to ADOPT_SUCCESS status", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                return true;
            }
            return false;
        }, () -> log.warn("failed to update v2 adopt success deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public boolean updateNegotiationContext(String deviceMac, Channel manageChannel) {
        return this.deviceContextHolder.a(deviceMac, () -> {
            a oldContext = this.deviceContextHolder.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                log.info("try to update negotiation context of device {} but context is null", (Object)deviceMac);
                return false;
            }
            if (!Objects.equals(manageChannel, oldContext.E())) {
                log.info("device {} receive device negotiation in other socket, can not handle", (Object)deviceMac);
                return false;
            }
            if (DeviceNetStatus.ADOPT_SUCCESS.equals((Object)oldContext.q())) {
                oldContext.a(System.currentTimeMillis());
                this.deviceContextHolder.a(deviceMac, oldContext);
                return true;
            }
            log.info("failed to refresh adopt success device {}, cause status not match", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            return false;
        }, () -> log.warn("failed to update negotiation context of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public boolean updateInitSyncSuccessContext(String deviceMac, Channel manageChannel) {
        return this.deviceContextHolder.a(deviceMac, () -> {
            a oldContext = this.deviceContextHolder.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                return false;
            }
            if (!Objects.equals(manageChannel, oldContext.E())) {
                log.info("device {} receive init sync result in other socket, can not handle", (Object)deviceMac);
                return false;
            }
            if (DeviceNetStatus.ADOPT_SUCCESS.equals((Object)oldContext.q())) {
                this.deviceContextHolder.a(deviceMac, oldContext, manageChannel);
                log.debug("update device {} status to CONNECTED from sync init setting", (Object)deviceMac);
                return true;
            }
            log.info("failed to update device {} to connected, device status: {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)oldContext.q());
            return false;
        }, () -> log.warn("failed to update initSync success deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public boolean updateV2RebuildingContext(String deviceMac, Channel manageChannel) {
        return this.deviceContextHolder.a(deviceMac, () -> {
            a oldContext = this.deviceContextHolder.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                return false;
            }
            if (!Objects.equals(manageChannel, oldContext.E())) {
                log.info("device {} receive rebuild request in other socket, can not handle", (Object)deviceMac);
                return false;
            }
            if (DeviceNetStatus.ADOPT_SUCCESS.equals((Object)oldContext.q())) {
                this.deviceContextHolder.a(deviceMac, oldContext, manageChannel);
                log.debug("update device {} status to CONNECTED when receive v2 rebuild", (Object)deviceMac);
                ServerMonitor.incV2DeviceRebuildCounter();
                return true;
            }
            log.info("failed to update device {} in rebuilding, device status: {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)oldContext.q());
            return false;
        }, () -> log.warn("failed to update v2 rebuild context of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public void removeTransferServerRoute(@Nonnull Channel transferChannel) {
        String deviceMac = this.transferChannelMap.get(transferChannel);
        if (StringUtils.isNull((String)deviceMac)) {
            return;
        }
        this.transferChannelMap.remove(transferChannel);
        this.deviceContextHolder.a(deviceMac, () -> {
            a oldContext = this.deviceContextHolder.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                return;
            }
            if (Objects.nonNull(oldContext.E())) {
                oldContext.g(null);
                oldContext.c(System.currentTimeMillis());
                this.deviceContextHolder.a(deviceMac, oldContext);
                log.debug("update device {} context's transfer channel {} to null", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)transferChannel);
            } else {
                this.deviceContextHolder.b(deviceMac);
                log.debug("manage channel in other pod, delete device {} connected context for transfer", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            }
        }, () -> log.warn("failed to remove transfer server route of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
        ServerRouteCacheUtils.doWithTryLock((LockService)this.lockService, (String)deviceMac, (int)this.ecspServerProperties.getTryLockTimeout(), () -> {
            ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.cacheService);
            if (Objects.isNull(serverRouteDTO) || Objects.isNull(serverRouteDTO.getUpgradeServerRoute())) {
                log.info("server route has expired for device {}, need not remove transfer route", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                return null;
            }
            serverRouteDTO.setUpgradeServerRoute(null);
            ServerRouteCacheUtils.setServerRouteCache((String)deviceMac, (ServerRouteDTO)serverRouteDTO, (long)this.ecspServerProperties.getConnectedServerRouteExpire(), (CacheService)this.cacheService);
            return null;
        });
    }

    @Override
    public void sendPreAdoptRequest(String deviceMac, a deviceContext) {
        log.debug("going to send v2 PRE_ADOPT_REQUEST to {}", (Object)deviceMac);
        int propertiesPort = this.ecspServerProperties.getAdoptPortV2() > 0 ? this.ecspServerProperties.getAdoptPortV2() : this.ecspV2ManageServerCenter.g();
        int adoptServerPort = deviceContext == null || deviceContext.n() == null ? propertiesPort : deviceContext.n();
        AdoptInfoDTO deviceAdoptInfoCache = AdoptInfoCacheUtils.getDeviceAdoptInfoCache((String)deviceMac, (CacheService)this.cacheService);
        EcspMessage preAdoptRequest = deviceAdoptInfoCache != null && deviceAdoptInfoCache.getEcspVersion() != null ? d.a(deviceContext, adoptServerPort, deviceAdoptInfoCache.getEcspVersion()) : d.a(deviceContext, adoptServerPort);
        this.deviceContextHolder.a(preAdoptRequest, deviceContext.B());
    }

    @Override
    public Runnable newTimeoutRunnable(String deviceMac, a deviceContext) {
        DeviceNetStatus deviceNetStatus = deviceContext.q();
        return () -> {
            switch (deviceNetStatus) {
                case DISCOVERY: {
                    log.info("pending device {} time out, remove device context", (Object)deviceMac);
                    this.deviceContextHolder.b(deviceMac, deviceContext);
                    break;
                }
                case ADOPTING_PENDING_PRE_ADOPT: 
                case ADOPTING_PRE_ADOPT: 
                case ADOPTING_PRE_CONNECT: 
                case ADOPTING_DEVICE_VERIFY: 
                case ADOPTING_SYSTEM_VERIFY: {
                    log.info("device of status {} time out for {}", (Object)deviceNetStatus, (Object)deviceMac);
                    this.deviceContextHolder.c(deviceMac, deviceContext);
                    break;
                }
                case ADOPT_SUCCESS: 
                case CONNECTED: {
                    log.info("device of status {} time out for {}", (Object)deviceNetStatus, (Object)deviceMac);
                    this.deviceContextHolder.d(deviceMac, deviceContext);
                    break;
                }
                default: {
                    log.warn("Invalid net status {} of {}", (Object)deviceNetStatus, (Object)deviceMac);
                }
            }
        };
    }

    @Override
    public a newTimeoutDeviceContext(a deviceContext) {
        if (deviceContext == null) {
            return null;
        }
        DeviceNetStatus deviceNetStatus = deviceContext.q();
        switch (deviceNetStatus) {
            case ADOPTING_PENDING_PRE_ADOPT: 
            case ADOPTING_PRE_ADOPT: 
            case ADOPTING_PRE_CONNECT: 
            case ADOPTING_DEVICE_VERIFY: 
            case ADOPTING_SYSTEM_VERIFY: {
                return new a(deviceContext.j(), deviceContext.p(), DeviceNetStatus.DISCOVERY, deviceContext.r(), deviceContext.B());
            }
        }
        return null;
    }

    @Override
    public void closeChannels(a deviceContext) {
        if (deviceContext == null) {
            log.info("needn't closeChannel, cause deviceContext is null.");
            return;
        }
        this.a(deviceContext.r(), deviceContext.E());
    }
}

