/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.context;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.DeviceInfo;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.common.Pair;
import com.tplink.smb.ecsp.common.monitor.CommonMonitor;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.common.util.TimeUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteCacheUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceAdoptInfoDTO;
import com.tplink.smb.ecsp.message.grpc.EcspAdoptInfo;
import com.tplink.smb.ecsp.protocol.DeviceNetStatus;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.server.config.DeviceContextTimeout;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.a;
import com.tplink.smb.ecsp.server.context.g;
import com.tplink.smb.ecsp.server.context.helper.EcspV2DeviceContextHelper;
import com.tplink.smb.ecsp.server.context.helper.b;
import com.tplink.smb.ecsp.server.n;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.lang.Nullable;

public class c
implements com.tplink.smb.ecsp.server.context.b {
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Resource
    private CacheService b;
    @Resource
    private LockService c;
    @Resource(name="localLockService")
    private com.tplink.smb.ecsp.server.b.b d;
    @Resource
    private n e;
    @Resource
    @Lazy
    private com.tplink.smb.ecsp.server.c.c f;
    @Resource
    @Lazy
    private b g;
    @Resource
    private EcspServerProperties h;
    private final ConcurrentHashMap<String, a> i = new ConcurrentHashMap();
    private final ConcurrentHashMap<Channel, String> j = new ConcurrentHashMap();
    private int k = 10;
    private DeviceContextTimeout l;
    private final AtomicBoolean m = new AtomicBoolean(false);
    private Set<DeviceType> n = new HashSet<DeviceType>();

    @PostConstruct
    public void c() {
        this.k = this.h.getTryLockTimeout();
        this.l = this.h.getDeviceContextTimeout();
        this.d();
    }

    private void d() {
        int scheduleDelay = new Random().nextInt(this.h.getDeviceExpireTaskDelayRange());
        int schedulePeriod = this.h.getDeviceExpireTaskPeriod();
        this.e.a(() -> this.i.forEach((deviceMac, deviceContext) -> {
            this.a((a)deviceContext);
            if (this.b((a)deviceContext)) {
                this.e.a(this.g.b(deviceContext.p(), (String)deviceMac, (a)deviceContext));
            }
        }), scheduleDelay, schedulePeriod, TimeUnit.SECONDS);
        a.info("start schedule remove expire device... period = {}", (Object)schedulePeriod);
    }

    private void a(a deviceContext) {
        if (CollectionUtils.isEmptyMap(deviceContext.c())) {
            return;
        }
        int verifyTimeout = this.h.getDeviceContextTimeout().getDeviceVerifyTimeout() + this.h.getDeviceContextTimeout().getSystemVerifyTimeout();
        Iterator<Map.Entry<Channel, g>> iterator = deviceContext.c().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Channel, g> entry = iterator.next();
            if (!TimeUtils.isTimeout((long)entry.getValue().c(), (int)verifyTimeout)) continue;
            entry.getKey().close();
            iterator.remove();
            a.debug("device {} pre link verify timeout, close channel {}", (Object)deviceContext.r(), (Object)entry.getKey());
        }
    }

    @Override
    public void a(String deviceMac, com.tplink.smb.ecsp.server.b.c onSuccess, com.tplink.smb.ecsp.server.b.c onFail) {
        try {
            this.d.a("device-cache-lock", (Object)deviceMac, (long)this.k, TimeUnit.SECONDS, onSuccess, onFail);
        }
        catch (InterruptedException e2) {
            a.warn("get device lock fail. mac = {}, exception: {}", new Object[]{OmadaPIIUtils.encryptWithCache((String)deviceMac), e2.getMessage(), e2});
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Boolean a(String deviceMac, BooleanSupplier onSuccess, com.tplink.smb.ecsp.server.b.c onFail) {
        Boolean result = null;
        try {
            result = this.d.a("device-cache-lock", (Object)deviceMac, (long)this.k, TimeUnit.SECONDS, onSuccess, onFail);
        }
        catch (InterruptedException e2) {
            a.warn("get device lock fail. mac = {}, exception: {}", new Object[]{OmadaPIIUtils.encryptWithCache((String)deviceMac), e2.getMessage(), e2});
            Thread.currentThread().interrupt();
        }
        return result == null ? Boolean.FALSE : result;
    }

    @Override
    @Nullable
    public a a(String deviceMac) {
        a deviceContext = this.i.get(deviceMac);
        if (Objects.isNull(deviceContext) || !this.b(deviceContext)) {
            return deviceContext;
        }
        return this.g.a(deviceContext.p(), deviceContext);
    }

    @Override
    public void b(String deviceMac) {
        this.i.remove(deviceMac);
    }

    private void e(String deviceMac, a context) {
        this.i.put(deviceMac, context);
    }

    @Override
    public String a(Channel manageSocket) {
        return this.j.get(manageSocket);
    }

    private void c(Channel manageChannel) {
        this.j.remove(manageChannel);
    }

    private void a(Channel manageChannel, String deviceMac) {
        this.j.put(manageChannel, deviceMac);
    }

    @Override
    public void a(String deviceMac, a newContext) {
        this.e(deviceMac, newContext);
    }

    @Override
    public void a(String deviceMac, a oldContext, Channel manageChannel) {
        Channel oldManageChannel;
        oldContext.a(DeviceNetStatus.CONNECTED);
        oldContext.a(System.currentTimeMillis());
        oldContext.c(System.currentTimeMillis());
        oldContext.a(Boolean.TRUE);
        oldContext.d(this.h.getDeviceContextTimeout().getInformChannelTimeout());
        oldContext.b(0L);
        Channel adoptChannel = oldContext.C();
        if (Objects.nonNull(adoptChannel)) {
            adoptChannel.close();
            oldContext.d((Channel)null);
        }
        if (Objects.nonNull(oldManageChannel = oldContext.E()) && !Objects.equals(oldManageChannel, manageChannel)) {
            oldManageChannel.close();
        }
        oldContext.f(manageChannel);
        oldContext.b();
        oldContext.e();
        this.e(deviceMac, oldContext);
        this.a(manageChannel, deviceMac);
        DeviceInfo deviceInfo = DeviceInfo.builder().mac(oldContext.r()).deviceType(oldContext.j()).netStatus(oldContext.q()).address(oldContext.a()).serverAddress(Objects.nonNull(oldContext.E()) ? oldContext.E().getLocalAddress() : null).updateTime(oldContext.u()).build();
        this.g.a(oldContext.p()).onNext((Object)deviceInfo);
    }

    @Override
    public boolean a(EcspVersion ecspVersion, String deviceMac, EcspMessage discovery, Pair<InetSocketAddress, InetSocketAddress> discoveryAddress) {
        if (this.f(deviceMac)) {
            if (this.c(ecspVersion, deviceMac, discovery, discoveryAddress)) {
                this.g.a(ecspVersion.getVersion(), deviceMac, this.a(deviceMac));
            }
            a.debug("device {} is in PRE_ADOPT status, need not send event", (Object)deviceMac);
            return false;
        }
        a oldContext = this.a(deviceMac);
        if (Objects.isNull(oldContext)) {
            return this.b(ecspVersion, deviceMac, discovery, discoveryAddress);
        }
        DeviceNetStatus deviceStatus = oldContext.q();
        if (DeviceNetStatus.isDiscovering((DeviceNetStatus)deviceStatus)) {
            return this.a(ecspVersion, deviceMac, discovery.getDeviceType(), discoveryAddress);
        }
        if (!TimeUtils.isTimeout((long)oldContext.u(), (int)this.l.getManageCoolDownTimeout())) {
            a.debug("Ignore this discovery msg for {} as device already in {} and in cool time", (Object)deviceMac, (Object)deviceStatus);
            ServerMonitor.incIgnoreCoolDownDiscoveryCounter((EcspVersion)ecspVersion);
            return false;
        }
        return true;
    }

    private boolean f(String deviceMac) {
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.b);
        boolean isPreAdoptStatus = Objects.nonNull(serverRouteDTO) && DeviceNetStatus.isPreAdopt((int)serverRouteDTO.getDeviceStatusValue());
        a.debug("receive discovery for {}, server route pre adopt status is {}", (Object)deviceMac, (Object)isPreAdoptStatus);
        return isPreAdoptStatus;
    }

    private boolean b(EcspVersion ecspVersion, String deviceMac, EcspMessage msg, Pair<InetSocketAddress, InetSocketAddress> discoveryAddress) {
        return this.a(deviceMac, () -> {
            if (this.a(deviceMac) == null) {
                a.debug("context is null, init discovery status device context for {}", (Object)deviceMac);
                a newContext = new a(DeviceType.resolve((String)msg.getDeviceType()), ecspVersion.getVersion(), DeviceNetStatus.DISCOVERY, deviceMac, discoveryAddress);
                this.a(deviceMac, newContext);
                return true;
            }
            return false;
        }, () -> a.warn("failed to init discovery deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    private boolean c(EcspVersion ecspVersion, String deviceMac, EcspMessage msg, Pair<InetSocketAddress, InetSocketAddress> discoveryAddress) {
        return this.a(deviceMac, () -> {
            a oldContext = this.a(deviceMac);
            if (oldContext == null) {
                a.debug("context is null when pre adopt, init pre adopt status device context for {}", (Object)deviceMac);
                oldContext = new a(DeviceType.resolve((String)msg.getDeviceType()), ecspVersion.getVersion(), DeviceNetStatus.ADOPTING_PRE_ADOPT, deviceMac, discoveryAddress);
            }
            long updateTime = DeviceNetStatus.ADOPTING_PRE_ADOPT.equals((Object)oldContext.q()) ? oldContext.u() : System.currentTimeMillis();
            oldContext.a(discoveryAddress);
            oldContext.a(DeviceNetStatus.ADOPTING_PRE_ADOPT);
            oldContext.a(updateTime);
            oldContext.d(this.l.getAdoptChannelTimeout());
            this.a(deviceMac, oldContext);
            a.debug("refresh updateTime of {} in PRE_ADOPT status", (Object)deviceMac);
            this.g.b(oldContext.p(), oldContext);
            return true;
        }, () -> a.warn("failed to update preAdopt deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    private boolean a(EcspVersion ecspVersion, String deviceMac, String deviceType, Pair<InetSocketAddress, InetSocketAddress> discoveryAddress) {
        return this.a(deviceMac, () -> {
            a oldContext = this.a(deviceMac);
            if (oldContext != null) {
                a newContext = new a(DeviceType.resolve((String)deviceType), ecspVersion.getVersion(), DeviceNetStatus.DISCOVERY, deviceMac, discoveryAddress);
                this.a(deviceMac, newContext);
                a.debug("{} update to DISCOVERY, last status is {}", (Object)deviceMac, (Object)oldContext.q());
                this.g.b(ecspVersion.getVersion(), oldContext);
                return true;
            }
            a.info("adopting / connected device {} reset to discovery status failed, cause context is null", (Object)deviceMac);
            return false;
        }, () -> a.warn("failed to reset to discovery of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public boolean a(@Nonnull DeviceAdoptInfoDTO deviceInfoDTO) {
        String deviceMac = deviceInfoDTO.getMac();
        return this.a(deviceMac, () -> {
            a oldContext = this.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                a.debug("receive send pre adopt request, create new pre adopt context for device {}", (Object)deviceMac);
                oldContext = new a(DeviceType.resolve((String)deviceInfoDTO.getDeviceType()), deviceInfoDTO.getVersion(), DeviceNetStatus.ADOPTING_PENDING_PRE_ADOPT, deviceMac, null);
            }
            switch (oldContext.q()) {
                case DISCOVERY: {
                    oldContext.a(DeviceNetStatus.ADOPTING_PENDING_PRE_ADOPT);
                    break;
                }
                case ADOPTING_PENDING_PRE_ADOPT: 
                case ADOPTING_PRE_ADOPT: {
                    break;
                }
                default: {
                    oldContext.a(DeviceNetStatus.ADOPTING_PENDING_PRE_ADOPT);
                    oldContext.a((Pair<InetSocketAddress, InetSocketAddress>)null);
                }
            }
            oldContext.b(deviceInfoDTO.getDest());
            oldContext.a(deviceInfoDTO.getVersion());
            oldContext.d(this.l.getPendingPreAdoptTimeout());
            oldContext.a(deviceInfoDTO.getAdoptInfoList());
            oldContext.c(deviceInfoDTO.getDestIp());
            oldContext.a(deviceInfoDTO.getDestPort());
            oldContext.b(deviceInfoDTO.getPreAdoptPort());
            oldContext.c(deviceInfoDTO.getDestDiscPort());
            this.a(deviceMac, oldContext);
            a.debug("update pre adopt context for {}, status is {}", (Object)deviceMac, (Object)oldContext.q());
            return true;
        }, () -> a.warn("failed to update preConnect deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public void a(String deviceMac, EcspMessage msg, Channel channel) {
        this.a(deviceMac, () -> {
            a oldContext = this.a(deviceMac);
            if (oldContext != null) {
                a newContext = new a(DeviceType.resolve((String)msg.getDeviceType()), msg.getVersion(), DeviceNetStatus.DISCOVERY, deviceMac, null);
                this.a(deviceMac, newContext);
                a.debug("reset device {} to discovery status from {}, close connection", (Object)deviceMac, (Object)oldContext.q());
                channel.close();
                return true;
            }
            a.info("adopting device {} reset to discovery status failed, cause context is null", (Object)deviceMac);
            return false;
        }, () -> a.warn("failed to reset adopting to discovery of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public boolean a(String deviceMac, Channel manageChannel, MessageType messageType) {
        return this.a(deviceMac, () -> {
            a oldContext = this.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                a.info("failed to update device for connected {}, old context is null", (Object)deviceMac);
                return false;
            }
            if (!Objects.equals(manageChannel, oldContext.E())) {
                a.info("connected device {} receive message in other socket, can not handle", (Object)deviceMac);
                return false;
            }
            if (!DeviceNetStatus.CONNECTED.equals((Object)oldContext.q())) {
                a.info("failed to update {} connected lastSeen, status {} is not match", (Object)deviceMac, (Object)oldContext.q());
                return false;
            }
            if (TimeUtils.isTimeout((long)oldContext.w(), (long)this.h.getUpdateServerRoutePeriod())) {
                a.debug("local last update timeout, refresh device {} server route expire time", (Object)deviceMac);
                oldContext.c(System.currentTimeMillis());
                this.e.a(() -> ServerRouteCacheUtils.updateManageServerRouteExpire((String)deviceMac, (LockService)this.c, (CacheService)this.b, (int)this.h.getTryLockTimeout(), (long)this.h.getConnectedServerRouteExpire()));
            }
            oldContext.b();
            long currentTime = System.currentTimeMillis();
            if (MessageType.INFORM_REQUEST.equals((Object)messageType)) {
                if (oldContext.y() > (long)this.l.getInformChannelTimeout() && TimeUtils.isTimeout((long)oldContext.u(), (int)this.l.getInformResetTimeout())) {
                    oldContext.d(this.l.getInformChannelTimeout());
                }
                if (oldContext.v() != 0L) {
                    ServerMonitor.getDeviceInformIntervalTimer().record(currentTime - oldContext.v(), TimeUnit.MILLISECONDS);
                }
                oldContext.b(currentTime);
            }
            oldContext.a(currentTime);
            this.a(deviceMac, oldContext);
            return true;
        }, () -> a.warn("failed to update connected deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    private com.tplink.smb.ecsp.server.context.helper.c e() {
        return (com.tplink.smb.ecsp.server.context.helper.c)this.g.a(EcspVersion.VERSION_1);
    }

    @Override
    public void a(String deviceMac, byte[] decryptedKey, ServerRouteDTO serverRouteDTO) {
        this.e().a(deviceMac, decryptedKey, serverRouteDTO);
    }

    @Override
    public boolean b(String deviceMac, EcspMessage preConnectInfo, Channel manageChannel) {
        return this.e().b(deviceMac, preConnectInfo, manageChannel);
    }

    @Override
    public boolean a(String deviceMac, String deviceType, Channel manageChannel) {
        return this.e().a(deviceMac, deviceType, manageChannel);
    }

    @Override
    public boolean a(String deviceMac, DeviceType deviceType, Channel upgradeChannel) {
        return this.e().a(deviceMac, deviceType, upgradeChannel);
    }

    @Override
    public void b(@Nonnull Channel upgradeChannel) {
        this.e().b(upgradeChannel);
    }

    private EcspV2DeviceContextHelper f() {
        return (EcspV2DeviceContextHelper)this.g.a(EcspVersion.VERSION_2);
    }

    @Override
    public void updateDeviceVerifyDeviceContext(String deviceMac, Channel channel, String randomKeyForDeviceVerify) {
        this.f().updateDeviceVerifyDeviceContext(deviceMac, channel, randomKeyForDeviceVerify);
    }

    @Override
    public boolean updateV2TransferPreConnectDeviceContext(String deviceMac, DeviceType deviceType, Channel transferChannel) {
        return this.f().updateV2TransferPreConnectDeviceContext(deviceMac, deviceType, transferChannel);
    }

    @Override
    public void updateSystemVerifyDeviceContext(String deviceMac, EcspAdoptInfo ecspAdoptInfo, Channel channel) {
        this.f().updateSystemVerifyDeviceContext(deviceMac, ecspAdoptInfo, channel);
    }

    @Override
    public void removeEcspV2VerifyInfo(String deviceMac, Channel channel) {
        this.f().removeEcspV2VerifyInfo(deviceMac, channel);
    }

    @Override
    public boolean updateV2AdoptSuccessDeviceContext(String deviceMac, Channel manageChannel) {
        return this.f().updateV2AdoptSuccessDeviceContext(deviceMac, manageChannel);
    }

    @Override
    public boolean updateNegotiationContext(String deviceMac, Channel manageChannel) {
        return this.f().updateNegotiationContext(deviceMac, manageChannel);
    }

    @Override
    public boolean updateInitSyncSuccessContext(String deviceMac, Channel manageChannel) {
        return this.f().updateInitSyncSuccessContext(deviceMac, manageChannel);
    }

    @Override
    public boolean updateV2RebuildingContext(String deviceMac, Channel manageChannel) {
        return this.f().updateV2RebuildingContext(deviceMac, manageChannel);
    }

    @Override
    public void removeTransferServerRoute(Channel transferChannel) {
        this.f().removeTransferServerRoute(transferChannel);
    }

    @Override
    public void a(String deviceMac, long timeout) {
        if (timeout <= (long)this.l.getInformChannelTimeout()) {
            return;
        }
        this.a(deviceMac, () -> {
            a oldContext = this.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                a.info("Failed to update timeout for device {}, cause context is null", (Object)deviceMac);
                return;
            }
            if (timeout <= oldContext.y()) {
                return;
            }
            ServerMonitor.incResetDeviceTimeoutCounter();
            oldContext.d(timeout);
            oldContext.a(System.currentTimeMillis());
            this.a(deviceMac, oldContext);
            a.debug("update device {} manage timeout to {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)timeout);
        }, () -> a.warn("failed to update manage timeout of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public void c(String deviceMac) {
        this.a(deviceMac, () -> {
            a oldContext = this.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                a.info("Failed to enable remove when disconnected for device {}, cause context is null", (Object)deviceMac);
                return;
            }
            oldContext.b(true);
            this.a(deviceMac, oldContext);
            a.debug("enabled remove device context when disconnected for device {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
        }, () -> a.warn("failed to enable remove disconnected deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public void a(String deviceMac, boolean isFirstInform) {
        this.a(deviceMac, () -> {
            a oldContext = this.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                a.info("Failed to modify isFirstInform for device {}, cause context is null", (Object)deviceMac);
                return;
            }
            oldContext.a(isFirstInform);
            this.a(deviceMac, oldContext);
            a.debug("modify isFirstInform of device {} to {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)isFirstInform);
        }, () -> a.warn("failed to modify is first Inform of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public boolean a(String deviceMac, String ecspVersion) {
        return this.a(deviceMac, () -> {
            a oldContext = this.a(deviceMac);
            if (Objects.isNull(oldContext)) {
                a.info("Failed to update ecsp version for device {}, cause context is null", (Object)deviceMac);
                return false;
            }
            oldContext.a(ecspVersion);
            this.a(deviceMac, oldContext);
            a.debug("update device {} ecsp version to {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)ecspVersion);
            return true;
        }, () -> a.warn("failed to update ecspVersion of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    @Trace(operationName="device.disconnect")
    public void a(@Nonnull Channel manageChannel, EcspVersion ecspVersion) {
        boolean hasNewChannel;
        String deviceMac = this.a(manageChannel);
        if (StringUtils.isNull((String)deviceMac)) {
            return;
        }
        this.c(manageChannel);
        a deviceContext = this.a(deviceMac);
        boolean isDisconnectedByServer = Optional.ofNullable(deviceContext).map(a::z).orElse(false);
        if (isDisconnectedByServer) {
            a.info("connection disconnected by controller, mac:{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            ServerMonitor.incDeviceDisconnectedCounter((EcspVersion)ecspVersion, (String)"server");
        } else {
            a.info("connection disconnected by device, mac:{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            ServerMonitor.incDeviceDisconnectedCounter((EcspVersion)ecspVersion, (String)"device");
        }
        boolean bl = hasNewChannel = Objects.nonNull(deviceContext) && Objects.nonNull(deviceContext.E()) && !Objects.equals(deviceContext.E(), manageChannel);
        if (hasNewChannel) {
            a.info("need not set server route expire for device {}, as device reconnect: {}", (Object)deviceMac, (Object)deviceContext.E());
            CommonMonitor.incServerRouteIgnoreCounter();
            return;
        }
        ServerRouteCacheUtils.doWithTryLock((LockService)this.c, (String)deviceMac, (int)this.k, () -> {
            ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.b);
            if (Objects.isNull(serverRouteDTO) || Objects.isNull(serverRouteDTO.getManageServerRoute())) {
                a.info("server route has expired for device {}", (Object)deviceMac);
                CommonMonitor.incServerRouteIgnoreCounter();
                return null;
            }
            AddressDTO manageServerRoute = serverRouteDTO.getManageServerRoute();
            String localHost = manageChannel.getLocalAddress().getAddress().getHostAddress();
            a.debug("going to expire server route for device {}, server localHost: {}, current manage server route: {}", new Object[]{deviceMac, localHost, manageServerRoute.getHost()});
            if (!Objects.equals(localHost, manageServerRoute.getHost())) {
                CommonMonitor.incServerRouteIgnoreCounter();
                a.info("not subject connected error, cause device {} connect to other pod {}", (Object)deviceMac, (Object)manageServerRoute.getHost());
                return null;
            }
            serverRouteDTO.setManageServerRoute(null);
            ServerRouteCacheUtils.setServerRouteCache((String)deviceMac, (ServerRouteDTO)serverRouteDTO, (long)this.h.getAdoptingServerRouteExpire(), (CacheService)this.b);
            if (Objects.isNull(deviceContext)) {
                a.info("device context is null, can not subject CONNECTED_ERROR for device {}", (Object)deviceMac);
                return null;
            }
            DeviceInfo disconnectedDevice = DeviceInfo.builder().mac(deviceMac).deviceType(deviceContext.j()).netStatus(DeviceNetStatus.CONNECTED_ERROR).updateTime(System.currentTimeMillis()).build();
            this.g.a(deviceContext.p()).onNext((Object)disconnectedDevice);
            if (deviceContext.z()) {
                a.debug("remove device context for device {} when channel disconnected", (Object)deviceMac);
                this.b(deviceMac);
            }
            return null;
        });
    }

    @Override
    public void b(String deviceMac, a oldContext) {
        if (Objects.isNull(oldContext) || !DeviceNetStatus.DISCOVERY.equals((Object)oldContext.q())) {
            a.debug("{} context had been removed, or not in discovery.", (Object)deviceMac);
            return;
        }
        this.a(deviceMac, () -> this.b(deviceMac), () -> a.warn("failed to handle pending timeout of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    @Trace(operationName="adopting.timeout")
    public void c(String deviceMac, a oldContext) {
        if (Objects.isNull(oldContext)) {
            a.info("failed to find context for {} when adopting timeout", (Object)deviceMac);
            return;
        }
        if (!DeviceNetStatus.isAdopting((DeviceNetStatus)oldContext.q())) {
            a.info("failed to handle adopting timeout as device {} net status is {}", (Object)deviceMac, (Object)oldContext.q());
            return;
        }
        this.g.b(oldContext.p(), oldContext);
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.b);
        this.a(deviceMac, () -> {
            oldContext.a(DeviceNetStatus.DISCOVERY);
            oldContext.a(System.currentTimeMillis());
            oldContext.d(this.l.getPendingTimeout());
            oldContext.d((Channel)null);
            oldContext.f(null);
            this.a(deviceMac, oldContext);
            a.debug("reset context to discovery for {} when adopting timeout", (Object)deviceMac);
            DeviceInfo adoptFailedDevice = DeviceInfo.builder().mac(deviceMac).deviceType(oldContext.j()).address(oldContext.a()).netStatus(DeviceNetStatus.ADOPTING_TIMEOUT).updateTime(System.currentTimeMillis()).build();
            this.a(oldContext, adoptFailedDevice, serverRouteDTO);
        }, () -> a.warn("failed to update adopting timeout of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    @Trace(operationName="adopted.timeout")
    public void d(String deviceMac, a oldContext) {
        DeviceNetStatus subjectDeviceStatus;
        if (Objects.isNull(oldContext)) {
            a.info("failed to find context for adopted device {} when timeout", (Object)deviceMac);
            return;
        }
        if (DeviceNetStatus.ADOPT_SUCCESS.equals((Object)oldContext.q())) {
            subjectDeviceStatus = DeviceNetStatus.ADOPTED_TIMEOUT;
        } else if (DeviceNetStatus.CONNECTED.equals((Object)oldContext.q())) {
            subjectDeviceStatus = DeviceNetStatus.CONNECTED_TIMEOUT;
        } else {
            a.info("failed timeout task for adopted device {}, status is {}", (Object)deviceMac, (Object)oldContext.q());
            return;
        }
        this.g.b(oldContext.p(), oldContext);
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.b);
        this.a(deviceMac, () -> {
            this.b(deviceMac);
            DeviceInfo removedDevice = DeviceInfo.builder().mac(deviceMac).deviceType(oldContext.j()).netStatus(subjectDeviceStatus).updateTime(System.currentTimeMillis()).build();
            this.a(oldContext, removedDevice, serverRouteDTO);
        }, () -> a.warn("failed to handle adopted timeout of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    private void a(a oldContext, DeviceInfo deviceInfo, ServerRouteDTO serverRouteDTO) {
        String localHost;
        String deviceMac = oldContext.r();
        if (Objects.isNull(serverRouteDTO)) {
            a.info("device {} server route expired, send adopting / connected timeout event", (Object)deviceMac);
            this.g.a(oldContext.p()).onNext((Object)deviceInfo);
            return;
        }
        if (serverRouteDTO.getDeviceStatusValue() == DeviceNetStatus.ADOPTING_PENDING_PRE_ADOPT.getValue()) {
            a.debug("device {} server route is pre adopt status, do not send adopting timeout event", (Object)deviceMac);
            return;
        }
        if (Objects.nonNull(serverRouteDTO.getAdoptServerRoute())) {
            String localHost2;
            if (Objects.nonNull(oldContext.C()) && Objects.nonNull(oldContext.C().getLocalAddress()) && Objects.equals(localHost2 = oldContext.C().getLocalAddress().getAddress().getHostAddress(), serverRouteDTO.getAdoptServerRoute().getHost())) {
                a.debug("going to send v1 adopting timeout event for {}", (Object)deviceMac);
                this.g.a(oldContext.p()).onNext((Object)deviceInfo);
            }
            a.debug("device {} adopt server route is other pod, do not send adopting timeout event", (Object)deviceMac);
            return;
        }
        if (Objects.isNull(serverRouteDTO.getManageServerRoute())) {
            a.info("device {} manage server route is null, send adopting / connected timeout event", (Object)deviceMac);
            this.g.a(oldContext.p()).onNext((Object)deviceInfo);
            return;
        }
        AddressDTO manageServerRoute = serverRouteDTO.getManageServerRoute();
        if (Objects.nonNull(oldContext.E()) && Objects.nonNull(oldContext.E().getLocalAddress()) && Objects.equals(localHost = oldContext.E().getLocalAddress().getAddress().getHostAddress(), manageServerRoute.getHost())) {
            a.debug("going to send adopting / connected timeout event for {}", (Object)deviceMac);
            this.g.a(oldContext.p()).onNext((Object)deviceInfo);
        }
    }

    private boolean b(a deviceContext) {
        return TimeUtils.isTimeout((long)deviceContext.u(), (long)deviceContext.y());
    }

    @Override
    public void a(EcspMessage ecspMessage, Pair<InetSocketAddress, InetSocketAddress> deviceAddress) {
        String deviceMac = ecspMessage.getMac();
        this.f.a(ecspMessage, deviceAddress).subscribeOn(this.e.c()).subscribe((response, throwable) -> {
            if (Objects.nonNull(throwable)) {
                a.warn("send Udp Data to {} error", (Object)deviceMac, throwable);
                return;
            }
            if (response.isOk()) {
                a.debug("send Udp Data to {} success.", (Object)deviceMac);
                ServerMonitor.incOutgoingEcspUdpCounter((MessageType)MessageType.PRE_ADOPT_REQUEST, (EcspVersion)EcspVersion.getEcspVersion((String)ecspMessage.getVersion()));
            } else {
                a.warn("send Udp Data to {} error on transport", (Object)deviceMac);
            }
        });
    }

    @Override
    public boolean a(a deviceContext, DeviceNetStatus status) {
        return deviceContext != null && status != null && status.equals((Object)deviceContext.q());
    }

    @Override
    public Map<DeviceNetStatus, Long> a() {
        Map<DeviceNetStatus, Long> sum = this.i.values().stream().collect(Collectors.groupingBy(a::q, Collectors.summingLong(p2 -> 1L)));
        sum.forEach((deviceNetStatus, count) -> {
            a.debug("monitor: device count of status {} is {}", (Object)deviceNetStatus.name(), count);
            ServerMonitor.getDeviceStatusGauge((String)deviceNetStatus.name()).getAndSet((long)count);
        });
        return sum;
    }

    @Override
    public void b() {
        Function<a, List> keyExtractor = deviceContext -> Arrays.asList(deviceContext.j().getType(), deviceContext.p());
        Map<List, Long> deviceNumMap = this.i.values().stream().filter(deviceContext -> DeviceNetStatus.CONNECTED.equals((Object)deviceContext.q())).collect(Collectors.groupingBy(keyExtractor, Collectors.summingLong(p2 -> 1L)));
        deviceNumMap.forEach((keyList, deviceNum) -> {
            if (CollectionUtils.isNotEmpty((Collection)keyList) && keyList.size() >= 2) {
                a.info("[STAT] {\"statName\":\"{}\",\"deviceType\":\"{}\",\"ecspVer\":\"{}\",\"deviceNum\":\"{}\"}", new Object[]{this.h.getDeviceStatName(), keyList.get(0), keyList.get(1), deviceNum});
            }
        });
    }

    @Override
    public boolean d(String deviceMac) {
        return this.a(deviceMac, () -> {
            Map<Channel, g> v2VerifyInfoMap;
            Channel upgradeChannel;
            Channel manageChannel;
            a deviceContext = this.a(deviceMac);
            if (Objects.isNull(deviceContext)) {
                a.debug("kickDevice: device {} context is null", (Object)deviceMac);
                return false;
            }
            if (!deviceContext.i()) {
                return false;
            }
            Channel adoptChannel = deviceContext.C();
            if (Objects.nonNull(adoptChannel)) {
                adoptChannel.close();
            }
            if (Objects.nonNull(manageChannel = deviceContext.E())) {
                manageChannel.close();
            }
            if (Objects.nonNull(upgradeChannel = deviceContext.D())) {
                upgradeChannel.close();
            }
            if (CollectionUtils.isNotEmptyMap(v2VerifyInfoMap = deviceContext.A())) {
                for (Channel channel : v2VerifyInfoMap.keySet()) {
                    channel.close();
                }
            }
            return true;
        }, () -> a.warn("failed to kick device of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    @Override
    public void a(boolean deviceKicking, int kickNum, int kickBatchNum, int kickIntervalMs, int restTimeMs) {
        this.m.set(deviceKicking);
        if (!deviceKicking || kickNum <= 0 || kickBatchNum <= 0 || kickIntervalMs < 0 || restTimeMs < 0) {
            a.info("need not kick devices, kicking = {}, please check params", (Object)this.m.get());
            return;
        }
        new Thread(() -> {
            int kickedNum = 0;
            int batchKickedNum = 0;
            Iterator<Map.Entry<String, a>> it = this.i.entrySet().iterator();
            while (it.hasNext() && kickedNum <= kickNum && this.m.get()) {
                try {
                    Map.Entry<String, a> deviceContextEntry = it.next();
                    if (!this.d(deviceContextEntry.getKey())) continue;
                    it.remove();
                    ++kickedNum;
                    if (++batchKickedNum >= kickBatchNum) {
                        a.debug("kickPartDevices: kick {} devices done, remain = {}, rest {}ms", new Object[]{batchKickedNum, this.i.size(), restTimeMs});
                        Thread.sleep(restTimeMs);
                        batchKickedNum = 0;
                        continue;
                    }
                    Thread.sleep(kickIntervalMs);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
            a.info("kick devices done...");
        }).start();
    }

    @Override
    public boolean e(String deviceTypeString) {
        DeviceType deviceType = DeviceType.resolve((String)deviceTypeString);
        return Objects.nonNull(deviceType) && this.n.contains(deviceType);
    }

    @Override
    public void a(Set<DeviceType> neededAddDeviceTypeSet) {
        this.n.addAll(neededAddDeviceTypeSet);
    }
}

