/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.c;

import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.ecsp.common.util.MacUtils;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.protocol.DebugUtils;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.transport.api.Channel;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class p {
    private static final Logger a = LoggerFactory.getLogger(p.class);
    private static final String b = "READ";
    private static final String c = "WRITE";
    private static final String d = "default";
    private static AtomicBoolean e = new AtomicBoolean(false);
    private static Set<String> f = new CopyOnWriteArraySet<String>();

    private p() {
    }

    static void a(@Nullable Channel channel, @Nonnull EcspMessage ecspMessage) {
        if (!a.isDebugEnabled() || !DebugUtils.isDeviceMsgEnable()) {
            return;
        }
        boolean needLog = true;
        if (!DebugUtils.isDeviceInformEnable() && MessageType.skipLog((Integer)ecspMessage.getMessageType())) {
            needLog = p.a(ecspMessage.getMac());
        }
        if (needLog) {
            p.a(channel, ecspMessage, b, null);
        }
    }

    static void b(@Nonnull Channel channel, @Nonnull EcspMessage ecspMessage) {
        if (!a.isDebugEnabled() || !DebugUtils.isDeviceMsgEnable()) {
            return;
        }
        p.a(channel, ecspMessage, b, null);
    }

    public static void a(@Nullable Channel channel, @Nonnull EcspMessage ecspMessage, String deviceType) {
        if (!a.isDebugEnabled() || !DebugUtils.isDeviceMsgEnable()) {
            return;
        }
        boolean needLog = true;
        if (MessageType.skipLog((Integer)ecspMessage.getMessageType())) {
            needLog = p.a(ecspMessage.getMac());
        }
        if (needLog) {
            p.a(channel, ecspMessage, c, deviceType);
        }
    }

    static void a(@Nonnull String messageJson, @Nonnull MessageType messageType, @Nonnull String mac, String deviceType, @Nonnull Channel channel) {
        if (!a.isDebugEnabled() || !DebugUtils.isDeviceMsgEnable()) {
            return;
        }
        boolean needLog = true;
        if (MessageType.skipLog((MessageType)messageType)) {
            needLog = p.a(mac);
        }
        if (needLog) {
            p.a(channel, messageJson, deviceType, messageType, c);
        }
    }

    public static boolean a(String mac, boolean enable) {
        if (!enable) {
            e.set(false);
            f.clear();
            a.info("disable inform log switch, and clear device set success.");
            return true;
        }
        if (MacUtils.validatorMac((String)mac)) {
            e.set(true);
            f.add(mac);
            a.info("enable inform log switch, and add device {} success.", (Object)OmadaPIIUtils.encryptWithCache((String)mac));
            return true;
        }
        if (CollectionUtils.isEmpty(f)) {
            e.set(false);
            a.info("cannot enable inform log switch, cause mac {} invalid.", (Object)OmadaPIIUtils.encryptWithCache((String)mac));
            return false;
        }
        a.info("mac {} invalid, do nothing.", (Object)OmadaPIIUtils.encryptWithCache((String)mac));
        return false;
    }

    private static boolean a(String mac) {
        if (!e.get()) {
            return false;
        }
        String formatMac = MacUtils.formatMacDb((String)mac);
        return f.contains(formatMac);
    }

    private static void a(Channel channel, EcspMessage ecspMessage, String eventName, String writeMessageDeviceType) {
        String messageJson = PIIJacksonUtil.parseToStr((Object)ecspMessage);
        if (Objects.isNull(messageJson)) {
            return;
        }
        if (Objects.isNull(writeMessageDeviceType)) {
            writeMessageDeviceType = ecspMessage.getDeviceType();
        }
        if (Objects.isNull(writeMessageDeviceType)) {
            a.warn("device type is still null, message type:{}", (Object)ecspMessage.getMessageType());
        }
        MessageType messageType = MessageType.fromInteger((int)ecspMessage.getMessageType());
        p.a(channel, messageJson, writeMessageDeviceType, messageType, eventName);
    }

    private static void a(@Nullable Channel channel, @Nonnull String messageJson, @Nullable String deviceType, @Nonnull MessageType messageType, @Nonnull String eventName) {
        if (Objects.isNull(deviceType)) {
            deviceType = d;
        }
        try {
            Map piiMaskStrategyMap = DebugUtils.getMaskMessageMapForDevice((String)deviceType);
            if (CollectionUtils.isNotEmptyMap((Map)piiMaskStrategyMap)) {
                messageJson = PIIJacksonUtil.maskPIIStr((String)messageJson, (Map)piiMaskStrategyMap);
            }
            p.a(channel, messageJson, eventName);
        }
        catch (Exception e2) {
            a.debug("pii failed for message: {}, error: {}", new Object[]{messageJson, e2.getMessage(), e2});
        }
    }

    private static void a(Channel channel, String messageJson, String eventName) {
        if (Objects.isNull(channel)) {
            a.debug(eventName + ": ecsp message = {}", (Object)messageJson);
        } else {
            a.debug("[L:{} - R:{}] " + eventName + ": ecsp message = {}", new Object[]{channel.getLocalAddress().toString(), OmadaPIIUtils.encryptWithCache((String)channel.getRemoteAddress().toString()), messageJson});
        }
    }
}

