/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.c;

import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.DeviceInformMessage;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.message.grpc.EcspAdoptInfo;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.EcspPacket;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.server.c;
import com.tplink.smb.ecsp.server.c.a;
import com.tplink.smb.ecsp.server.c.p;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.e;
import com.tplink.smb.ecsp.server.g;
import com.tplink.smb.ecsp.server.i;
import com.tplink.smb.ecsp.server.o;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.monitor.DailyMonitor;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerAdapter;
import com.tplink.smb.eventcenter.api.EventCenter;
import java.net.InetSocketAddress;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class n
extends ChannelHandlerAdapter {
    private static final Logger a = LoggerFactory.getLogger(n.class);
    private final EventCenter b;
    private final a c;
    private final com.tplink.smb.ecsp.server.a.b d;
    private final b e;
    private final EcspServerProperties f;
    private final i g;
    private final g h;
    private final e i;
    private final c j;

    n(EventCenter eventCenter, a serverCenter, com.tplink.smb.ecsp.server.a.b ecspHandlerStrategyFactory, b deviceContextHolder, EcspServerProperties ecspServerProperties, o serviceCollection) {
        this.b = eventCenter;
        this.c = serverCenter;
        this.d = ecspHandlerStrategyFactory;
        this.e = deviceContextHolder;
        this.f = ecspServerProperties;
        this.g = serviceCollection.b();
        this.h = serviceCollection.c();
        this.i = serviceCollection.d();
        this.j = serviceCollection.e();
    }

    public void received(Channel channel, Object message) throws RemotingException {
        super.received(channel, message);
        EcspMessage ecspMessage = EcspPacket.parseEcspMessage((EcspPacket)((EcspPacket)message), (InetSocketAddress)channel.getRemoteAddress());
        if (EcspMessage.isNotValid((EcspMessage)ecspMessage) || !this.e.e(ecspMessage.getDeviceType())) {
            a.info("invalid device message {}. close channel {}", message, (Object)channel);
            channel.close();
            return;
        }
        try {
            p.a(channel, ecspMessage);
        }
        catch (Exception e2) {
            a.warn("Exception occured when trying to log received ecsp v2 manage message:{}", (Object)e2.getMessage(), (Object)e2);
        }
        this.d.a(() -> this.a(ecspMessage, channel));
    }

    @Trace(operationName="ecspV2manager.handle")
    private void a(EcspMessage ecspMessage, Channel channel) {
        String deviceMac = ecspMessage.getMac();
        MessageType messageType = MessageType.fromInteger((int)ecspMessage.getMessageType());
        ServerMonitor.incIncomingEcspTcpCounter((MessageType)messageType, (EcspVersion)EcspVersion.VERSION_2);
        switch (messageType) {
            case PRE_CONNECT_INFO: {
                int deviceConnectTimes = DailyMonitor.incAndGetDeviceConnectGauge((String)deviceMac, (int)this.f.getDeviceDailyConnectionThreshold(), (int)this.f.getDeviceDailyConnectionTimesPeriod1(), (int)this.f.getDeviceDailyConnectionTimesPeriod2(), (int)this.f.getDeviceDailyConnectionTimesPeriod3(), (boolean)this.f.isEnableMonitor());
                if (a.isInfoEnabled()) {
                    a.info("[STAT] {\"device\":\"{}\",\"operation\":\"Online\",\"connection-times\":{}}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)deviceConnectTimes);
                }
                this.d.a(com.tplink.smb.ecsp.server.a.c.e, ecspMessage, channel, this.c);
                int serverPort = channel.getLocalAddress().getPort();
                ServerType serverType = this.c.b().get(serverPort);
                if (!ServerType.TRANSFER.equals((Object)serverType)) break;
                this.b(ecspMessage, channel, messageType);
                break;
            }
            case DEVICE_VERIFY_INFO: {
                if (DailyMonitor.isDeviceBlackList((String)deviceMac)) {
                    a.info("device {} has connected for limit times, refuse connection.", (Object)deviceMac);
                    channel.close();
                    break;
                }
                this.a(ecspMessage, channel, messageType, com.tplink.smb.ecsp.server.a.c.f);
                break;
            }
            case SYSTEM_VERIFY_RESULT: {
                boolean needSendDeviceEvent = this.d.a(com.tplink.smb.ecsp.server.a.c.g, ecspMessage, channel, this.c);
                if (!needSendDeviceEvent) break;
                this.a(ecspMessage, channel, messageType, true);
                this.e.removeEcspV2VerifyInfo(deviceMac, channel);
                break;
            }
            case DEVICE_NEGOTIATION: {
                boolean needSendDeviceEvent = this.d.a(com.tplink.smb.ecsp.server.a.c.h, ecspMessage, channel, this.c);
                if (ecspMessage.isFragMsg()) {
                    OperationResponse<EcspMessage> getMessageResponse = this.j.a(deviceMac, messageType);
                    if (!getMessageResponse.isOk()) {
                        a.warn("save easy manager frag to cache but failed, mac: {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                        needSendDeviceEvent = false;
                    } else {
                        EcspMessage responseMessage = (EcspMessage)getMessageResponse.getResult();
                        if (Objects.nonNull(responseMessage)) {
                            ecspMessage = responseMessage;
                        } else {
                            needSendDeviceEvent = false;
                        }
                    }
                }
                if (!needSendDeviceEvent) break;
                this.b(ecspMessage, channel, messageType);
                break;
            }
            case INIT_SYNC_RESULT: {
                this.a(ecspMessage, channel, messageType, com.tplink.smb.ecsp.server.a.c.h);
                break;
            }
            case INFORM_REQUEST: {
                this.a(ecspMessage, channel, messageType);
                break;
            }
            case NOTIFY_REQUEST: 
            case NOTIFY_REQUEST_V2: {
                int serverPort = channel.getLocalAddress().getPort();
                ServerType serverType = this.c.b().get(serverPort);
                if (ServerType.TRANSFER.equals((Object)serverType)) {
                    long now = System.currentTimeMillis();
                    com.tplink.smb.ecsp.server.context.a context = this.e.a(deviceMac);
                    if (Objects.nonNull(context)) {
                        context.a(now);
                        this.e.a(deviceMac, context);
                    }
                    this.b(ecspMessage, channel, messageType);
                    break;
                }
                this.a(ecspMessage, channel, messageType, com.tplink.smb.ecsp.server.a.c.j);
                break;
            }
            case UPGRADE_NOTIFY_REQUEST: 
            case EVENT_PORTAL_QUERY: {
                this.a(ecspMessage, channel, messageType, com.tplink.smb.ecsp.server.a.c.j);
                break;
            }
            case REBUILD_REQUEST: {
                this.a(ecspMessage, channel, messageType, com.tplink.smb.ecsp.server.a.c.i);
                break;
            }
            case SET_RESPONSE: 
            case GET_RESPONSE: 
            case UPGRADE_RESPONSE_V2: 
            case EVENT_PORTAL_AUTH_RESPONSE: 
            case REBUILD_RESULT: {
                if (ecspMessage.getSeq() == null || !this.e.a(deviceMac, channel, messageType)) break;
                this.c.a(ecspMessage);
                break;
            }
            case FORGET_RESPONSE: 
            case FORGET_RESPONSE_NO_RESET: {
                this.c.a(ecspMessage);
                break;
            }
            case REPORT: {
                boolean isValidReport = this.d.a(com.tplink.smb.ecsp.server.a.c.j, ecspMessage, channel, this.c);
                if (!isValidReport) break;
                this.g.a(ecspMessage);
                break;
            }
            case FILE_TRANSFER_RESPONSE_V2: {
                this.i.a(ecspMessage);
                break;
            }
            default: {
                a.info("v2 manage server do not handle messageType {} for {}, close {}", new Object[]{messageType, deviceMac, channel});
                channel.close();
            }
        }
    }

    @Trace(operationName="ecspV2inform.handle")
    private void a(EcspMessage ecspMessage, Channel channel, MessageType messageType) {
        boolean isValidInform = this.d.a(com.tplink.smb.ecsp.server.a.c.j, ecspMessage, channel, this.c);
        if (Boolean.FALSE.equals(isValidInform)) {
            return;
        }
        boolean relayInformDirect = this.f.isRelayInformDirect();
        if (Boolean.TRUE.equals(relayInformDirect)) {
            this.b(ecspMessage, channel, messageType);
        } else {
            String mac = ecspMessage.getMac();
            Integer serverGrpcPort = this.f.getGrpcPort();
            AddressDTO localServerRoute = com.tplink.smb.ecsp.server.e.e.a(channel, serverGrpcPort);
            com.tplink.smb.ecsp.server.context.a deviceContext = this.e.a(mac);
            if (Objects.isNull(deviceContext)) {
                try {
                    this.disconnected(channel);
                    return;
                }
                catch (Exception e2) {
                    a.warn("Exception: {} occured when disconnect the channel of {}", new Object[]{e2.getMessage(), OmadaPIIUtils.encryptWithCache((String)mac), e2});
                    return;
                }
            }
            boolean isFirstInform = deviceContext.x();
            this.h.a(DeviceInformMessage.builder().isFirstInform(isFirstInform).addressDTO(localServerRoute).ecspMessage(ecspMessage).build());
            if (Boolean.TRUE.equals(isFirstInform)) {
                p.b(channel, ecspMessage);
                this.e.a(mac, Boolean.FALSE);
            }
        }
    }

    private void a(EcspMessage ecspMessage, Channel channel, MessageType messageType, com.tplink.smb.ecsp.server.a.c v2EcspHandler) {
        boolean needSendDeviceEvent = this.d.a(v2EcspHandler, ecspMessage, channel, this.c);
        if (needSendDeviceEvent) {
            this.b(ecspMessage, channel, messageType);
        }
    }

    private void b(EcspMessage ecspMessage, Channel channel, MessageType messageType) {
        this.a(ecspMessage, channel, messageType, false);
    }

    private void a(EcspMessage ecspMessage, Channel channel, MessageType messageType, boolean sendAdoptInfo) {
        com.tplink.smb.ecsp.server.context.a deviceContext;
        String deviceMac = ecspMessage.getMac();
        EcspAdoptInfo adoptInfo = null;
        if (sendAdoptInfo && Objects.nonNull(deviceContext = this.e.a(deviceMac)) && CollectionUtils.isNotEmpty(deviceContext.t()) && deviceContext.t().size() == 1) {
            a.debug("send event with real adopt info for device {} ", (Object)deviceMac);
            adoptInfo = deviceContext.t().get(0);
        }
        Boolean sendWithKey = this.f.isEnableSendEventWithKey();
        String topicPrefix = this.f.getTopicPrefix();
        int serverPort = channel.getLocalAddress().getPort();
        ServerType serverType = this.c.b().get(serverPort);
        String eventTopic = com.tplink.smb.ecsp.server.e.a.b(serverType, ecspMessage, messageType, topicPrefix);
        Integer serverGrpcPort = this.f.getGrpcPort();
        AddressDTO localServerRoute = com.tplink.smb.ecsp.server.e.e.a(channel, serverGrpcPort);
        com.tplink.smb.ecsp.server.e.a.a(this.b, ecspMessage, adoptInfo, localServerRoute, eventTopic, sendWithKey);
    }

    public void connected(Channel channel) throws RemotingException {
        super.connected(channel);
        if (!this.f.isEnableHandleNewChannel()) {
            channel.close();
            ServerMonitor.incRefuseDeviceConnectCounter((EcspVersion)EcspVersion.VERSION_2);
        }
        if (this.a(channel)) {
            a.trace("V2 Transfer server new channel {} connected.", (Object)channel);
            ServerMonitor.getV2TransferConnectionsGauge().incrementAndGet();
        } else {
            a.trace("V2 Manage server new channel {} connected.", (Object)channel);
            ServerMonitor.getV2ManageConnectionsGauge().incrementAndGet();
        }
    }

    public void disconnected(Channel channel) throws RemotingException {
        super.disconnected(channel);
        String deviceMac = this.e.a(channel);
        if (Objects.nonNull(deviceMac)) {
            int deviceConnectTimes = DailyMonitor.getDeviceConnectGauge((String)deviceMac);
            if (a.isInfoEnabled()) {
                a.info("[STAT] {\"device\":\"{}\",\"operation\":\"Offline\",\"connection-times\":{} }", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)deviceConnectTimes);
            }
        }
        if (Objects.isNull(channel)) {
            a.debug("Ecsp v2 manage disconnect channel is null, failed to decrease connection gauge.");
            return;
        }
        if (this.a(channel)) {
            a.trace("V2 Transfer server new channel {} disconnected.", (Object)channel);
            ServerMonitor.getV2TransferConnectionsGauge().decrementAndGet();
        } else {
            a.trace("V2 Manage server channel {} disconnected.", (Object)channel);
            ServerMonitor.getV2ManageConnectionsGauge().decrementAndGet();
        }
        this.e.a(channel, EcspVersion.VERSION_2);
    }

    private boolean a(@Nonnull Channel channel) {
        int serverPort = channel.getLocalAddress().getPort();
        ServerType serverType = this.c.b().get(serverPort);
        return ServerType.TRANSFER.equals((Object)serverType);
    }

    public void caught(Channel channel, Throwable exception) {
        a.warn("EcspV2 TCP channel caught exception: {}", (Object)exception.getMessage(), (Object)exception);
    }
}

