/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.c;

import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.EcspPacket;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.server.a.c;
import com.tplink.smb.ecsp.server.c.p;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.e.a;
import com.tplink.smb.ecsp.server.m;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerAdapter;
import com.tplink.smb.eventcenter.api.EventCenter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class k
extends ChannelHandlerAdapter {
    private static final Logger a = LoggerFactory.getLogger(k.class);
    private final EventCenter b;
    private final m c;
    private final com.tplink.smb.ecsp.server.a.b d;
    private final b e;
    private final EcspServerProperties f;

    k(EventCenter eventCenter, m serverCenter, com.tplink.smb.ecsp.server.a.b ecspHandlerStrategyFactory, b deviceContextHolder, EcspServerProperties ecspServerProperties) {
        this.b = eventCenter;
        this.c = serverCenter;
        this.d = ecspHandlerStrategyFactory;
        this.e = deviceContextHolder;
        this.f = ecspServerProperties;
    }

    public void received(Channel channel, Object message) throws RemotingException {
        super.received(channel, message);
        EcspMessage ecspMessage = EcspPacket.parseEcspMessage((EcspPacket)((EcspPacket)message));
        if (EcspMessage.isNotValid((EcspMessage)ecspMessage) || !this.e.e(ecspMessage.getDeviceType())) {
            a.info("invalid device message {}. close channel {}", message, (Object)channel);
            channel.close();
            return;
        }
        try {
            p.a(channel, ecspMessage);
        }
        catch (Exception e2) {
            a.warn("Exception occured when trying to log upgrade message from udp packet: {}", (Object)e2.getMessage(), (Object)e2);
        }
        this.d.a(() -> this.a(ecspMessage, channel));
    }

    private void a(EcspMessage ecspMessage, Channel channel) {
        MessageType messageType = MessageType.fromInteger((int)ecspMessage.getMessageType());
        if (messageType != MessageType.PRE_CONNECT_INFO) {
            a.info("upgrade server do not handle message type {} for {}, close channel {}", new Object[]{messageType, ecspMessage.getMac(), channel});
            channel.close();
            return;
        }
        ServerMonitor.incIncomingEcspTcpCounter((MessageType)MessageType.PRE_CONNECT_INFO, (EcspVersion)EcspVersion.VERSION_1);
        boolean handleSuccess = this.d.a(com.tplink.smb.ecsp.server.a.c.b, ecspMessage, channel, this.c);
        if (handleSuccess) {
            this.a(ecspMessage);
        }
    }

    private void a(EcspMessage ecspMessage) {
        Boolean sendWithKey = this.f.isEnableSendEventWithKey();
        String topicPrefix = this.f.getTopicPrefix();
        String eventTopic = com.tplink.smb.ecsp.server.e.a.b(topicPrefix);
        com.tplink.smb.ecsp.server.e.a.a(this.b, ecspMessage, null, eventTopic, sendWithKey);
    }

    public void connected(Channel channel) throws RemotingException {
        super.connected(channel);
        if (!this.f.isEnableHandleNewChannel()) {
            channel.close();
            ServerMonitor.incRefuseDeviceConnectCounter((EcspVersion)EcspVersion.VERSION_1);
        }
        a.trace("V1 upgrade server new channel {} connected.", (Object)channel);
        ServerMonitor.getV1UpgradeConnectionsGauge().incrementAndGet();
    }

    public void disconnected(Channel channel) throws RemotingException {
        super.disconnected(channel);
        if (Objects.isNull(channel)) {
            a.debug("Ecsp v1 upgrade disconnect channel is null, failed to decrease connection gauge.");
            return;
        }
        a.trace("V1 upgrade server channel {} disconnected.", (Object)channel);
        ServerMonitor.getV1UpgradeConnectionsGauge().decrementAndGet();
        this.e.b(channel);
    }

    public void caught(Channel channel, Throwable exception) {
        a.warn("EcspV1 TCP upgrade channel caught exception: {}", (Object)exception.getMessage(), (Object)exception);
    }
}

