/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.c;

import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.DeviceInformMessage;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.EcspPacket;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.server.a.c;
import com.tplink.smb.ecsp.server.c.a;
import com.tplink.smb.ecsp.server.c.p;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.e.e;
import com.tplink.smb.ecsp.server.g;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.monitor.DailyMonitor;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerAdapter;
import com.tplink.smb.eventcenter.api.EventCenter;
import java.net.InetSocketAddress;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class h
extends ChannelHandlerAdapter {
    private static final Logger a = LoggerFactory.getLogger(h.class);
    private final EventCenter b;
    private final a c;
    private final com.tplink.smb.ecsp.server.a.b d;
    private final b e;
    private final EcspServerProperties f;
    private final g g;

    h(EventCenter eventCenter, a serverCenter, com.tplink.smb.ecsp.server.a.b ecspHandlerStrategyFactory, b deviceContextHolder, EcspServerProperties ecspServerProperties, g informService) {
        this.b = eventCenter;
        this.c = serverCenter;
        this.d = ecspHandlerStrategyFactory;
        this.e = deviceContextHolder;
        this.f = ecspServerProperties;
        this.g = informService;
    }

    public void received(Channel channel, Object message) throws RemotingException {
        super.received(channel, message);
        EcspMessage ecspMessage = EcspPacket.parseEcspMessage((EcspPacket)((EcspPacket)message), (InetSocketAddress)channel.getRemoteAddress());
        if (EcspMessage.isNotValid((EcspMessage)ecspMessage) || !this.e.e(ecspMessage.getDeviceType())) {
            a.info("invalid device message {}. close channel {}", message, (Object)channel);
            channel.close();
            return;
        }
        try {
            p.a(channel, ecspMessage);
        }
        catch (Exception e2) {
            a.warn("Exception occured when trying to log ecsp v1 manage message from udp packet: {}", (Object)e2.getMessage(), (Object)e2);
        }
        this.d.a(() -> this.a(ecspMessage, channel));
    }

    @Trace(operationName="ecspV1manager.handle")
    private void a(EcspMessage ecspMessage, Channel channel) {
        String deviceMac = ecspMessage.getMac();
        MessageType messageType = MessageType.fromInteger((int)ecspMessage.getMessageType());
        ServerMonitor.incIncomingEcspTcpCounter((MessageType)messageType, (EcspVersion)EcspVersion.VERSION_1);
        switch (messageType) {
            case PRE_CONNECT_INFO: {
                boolean ecspMessageHandleSuccess;
                int deviceConnectTimes = DailyMonitor.incAndGetDeviceConnectGauge((String)deviceMac, (int)this.f.getDeviceDailyConnectionThreshold(), (int)this.f.getDeviceDailyConnectionTimesPeriod1(), (int)this.f.getDeviceDailyConnectionTimesPeriod2(), (int)this.f.getDeviceDailyConnectionTimesPeriod3(), (boolean)this.f.isEnableMonitor());
                if (a.isInfoEnabled()) {
                    a.info("[STAT] {\"device\":\"{}\",\"operation\":\"Online\",\"connection-times\":{}}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)deviceConnectTimes);
                }
                if (!(ecspMessageHandleSuccess = this.d.a(com.tplink.smb.ecsp.server.a.c.b, ecspMessage, channel, this.c))) break;
                this.b(ecspMessage, channel, messageType);
                break;
            }
            case ADOPT_RESPONSE: {
                if (DailyMonitor.isDeviceBlackList((String)deviceMac)) {
                    a.info("device {} has connected for limit times, refuse connection.", (Object)deviceMac);
                    channel.close();
                    break;
                }
                boolean ecspMessageHandleSuccess = this.d.a(com.tplink.smb.ecsp.server.a.c.a, ecspMessage, channel, this.c);
                if (!ecspMessageHandleSuccess) break;
                this.b(ecspMessage, channel, messageType);
                break;
            }
            case INFORM_REQUEST: {
                this.a(ecspMessage, channel, messageType);
                break;
            }
            case UPGRADE_RESPONSE: 
            case NOTIFY_REQUEST: 
            case EVENT_PORTAL_QUERY: {
                boolean ecspMessageHandleSuccess = this.d.a(com.tplink.smb.ecsp.server.a.c.c, ecspMessage, channel, this.c);
                if (!ecspMessageHandleSuccess) break;
                this.b(ecspMessage, channel, messageType);
                break;
            }
            case REBUILD_REQUEST: {
                boolean ecspMessageHandleSuccess = this.d.a(com.tplink.smb.ecsp.server.a.c.d, ecspMessage, channel, this.c);
                if (!ecspMessageHandleSuccess) break;
                this.b(ecspMessage, channel, messageType);
                break;
            }
            case SET_RESPONSE: 
            case GET_RESPONSE: {
                if (!this.e.a(deviceMac, channel, messageType)) break;
                this.c.a(ecspMessage);
                break;
            }
            case FORGET_RESPONSE: 
            case FORGET_RESPONSE_NO_RESET: {
                this.c.a(ecspMessage);
                break;
            }
            default: {
                a.info("v1 tcp server do not handle messageType {} for {}, close {}", new Object[]{messageType, deviceMac, channel});
                channel.close();
            }
        }
    }

    @Trace(operationName="ecspV1inform.handle")
    private void a(EcspMessage ecspMessage, Channel channel, MessageType messageType) {
        boolean isValidInform = this.d.a(com.tplink.smb.ecsp.server.a.c.c, ecspMessage, channel, this.c);
        if (Boolean.FALSE.equals(isValidInform)) {
            return;
        }
        boolean relayInformDirect = this.f.isRelayInformDirect();
        if (Boolean.TRUE.equals(relayInformDirect)) {
            this.b(ecspMessage, channel, messageType);
        } else {
            String mac = ecspMessage.getMac();
            Integer serverGrpcPort = this.f.getGrpcPort();
            AddressDTO localServerRoute = com.tplink.smb.ecsp.server.e.e.a(channel, serverGrpcPort);
            com.tplink.smb.ecsp.server.context.a deviceContext = this.e.a(mac);
            if (Objects.isNull(deviceContext)) {
                try {
                    this.disconnected(channel);
                    return;
                }
                catch (Exception e2) {
                    a.warn("Exception: {} occured when disconnect the channel of {}", new Object[]{e2.getMessage(), OmadaPIIUtils.encryptWithCache((String)mac), e2});
                    return;
                }
            }
            boolean isFirstInform = deviceContext.x();
            this.g.a(DeviceInformMessage.builder().isFirstInform(isFirstInform).addressDTO(localServerRoute).ecspMessage(ecspMessage).build());
            if (Boolean.TRUE.equals(isFirstInform)) {
                p.b(channel, ecspMessage);
                this.e.a(mac, Boolean.FALSE);
            }
        }
    }

    private void b(EcspMessage ecspMessage, Channel channel, MessageType messageType) {
        Boolean sendWithKey = this.f.isEnableSendEventWithKey();
        String topicPrefix = this.f.getTopicPrefix();
        int serverPort = channel.getLocalAddress().getPort();
        ServerType serverType = this.c.b().get(serverPort);
        String eventTopic = com.tplink.smb.ecsp.server.e.a.a(serverType, ecspMessage, messageType, topicPrefix);
        Integer serverGrpcPort = this.f.getGrpcPort();
        AddressDTO localServerRoute = com.tplink.smb.ecsp.server.e.e.a(channel, serverGrpcPort);
        com.tplink.smb.ecsp.server.e.a.a(this.b, ecspMessage, null, localServerRoute, eventTopic, sendWithKey);
    }

    public void connected(Channel channel) throws RemotingException {
        super.connected(channel);
        if (!this.f.isEnableHandleNewChannel()) {
            channel.close();
            ServerMonitor.incRefuseDeviceConnectCounter((EcspVersion)EcspVersion.VERSION_1);
        }
        if (this.a(channel)) {
            ServerMonitor.getV1AdoptConnectionsGauge().incrementAndGet();
            return;
        }
        a.trace("V1 Manage server new channel {} connected.", (Object)channel);
        ServerMonitor.getV1ManageConnectionsGauge().incrementAndGet();
    }

    public void disconnected(Channel channel) throws RemotingException {
        super.disconnected(channel);
        if (Objects.isNull(channel)) {
            a.debug("Ecsp v1 manage disconnect channel is null, failed to decrease connection gauge.");
            return;
        }
        String deviceMac = this.e.a(channel);
        if (Objects.nonNull(deviceMac)) {
            int deviceConnectTimes = DailyMonitor.getDeviceConnectGauge((String)deviceMac);
            if (a.isInfoEnabled()) {
                a.info("[STAT] {\"device\":\"{}\",\"operation\":\"Offline\",\"connection-times\":{} }", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)deviceConnectTimes);
            }
        }
        if (this.a(channel)) {
            ServerMonitor.getV1AdoptConnectionsGauge().decrementAndGet();
            return;
        }
        a.trace("V1 Manage server channel {} disconnected.", (Object)channel);
        ServerMonitor.getV1ManageConnectionsGauge().decrementAndGet();
        this.e.a(channel, EcspVersion.VERSION_1);
    }

    private boolean a(@Nonnull Channel channel) {
        int serverPort = channel.getLocalAddress().getPort();
        ServerType serverType = this.c.b().get(serverPort);
        return ServerType.ADOPT.equals((Object)serverType);
    }

    public void caught(Channel channel, Throwable exception) {
        a.warn("EcspV1 TCP channel caught exception: {}", (Object)exception.getMessage(), (Object)exception);
    }
}

