/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.c;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteCacheUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceDatagramDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceMessageInfo;
import com.tplink.smb.ecsp.message.grpc.DeviceSocketDTO;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.DeviceNetStatus;
import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.server.c.a;
import com.tplink.smb.ecsp.server.c.h;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.e.c;
import com.tplink.smb.ecsp.server.g;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.Server;
import com.tplink.smb.ecsp.transport.api.Transporters;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerAdapter;
import com.tplink.smb.eventcenter.api.EventCenter;
import io.reactivex.Single;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class f
extends a
implements com.tplink.smb.ecsp.server.d.b {
    private static final Logger a = LoggerFactory.getLogger(f.class);
    @Resource
    private Transporters b;
    @Resource
    private EventCenter c;
    @Autowired
    private CacheService d;
    @Resource
    private EcspServerProperties e;
    @Resource
    @Lazy
    private b f;
    @Resource
    private com.tplink.smb.ecsp.server.a.b g;
    @Resource
    private com.tplink.smb.ecsp.server.b h;
    @Resource
    private g i;
    private final ConcurrentHashMap<Integer, Server> j = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ServerType> k = new ConcurrentHashMap();

    @Override
    public ConcurrentHashMap<Integer, Server> a() {
        return this.j;
    }

    @Override
    public ConcurrentHashMap<Integer, ServerType> b() {
        return this.k;
    }

    @Override
    public ChannelHandlerAdapter c() {
        return new h(this.c, this, this.g, this.f, this.e, this.i);
    }

    @Override
    public Transporters d() {
        return this.b;
    }

    @Override
    public Logger e() {
        return a;
    }

    public Single<OperationResponse<EcspMessage>> b(DeviceDatagramDTO deviceDatagramDTO) {
        String deviceMac = deviceDatagramDTO.getDeviceMac();
        DeviceMessageInfo deviceMessageInfo = deviceDatagramDTO.getDeviceMessageInfo();
        int messageType = deviceMessageInfo.getMessageType();
        Channel channel = this.a(deviceMac, (ServerType)null);
        com.tplink.smb.ecsp.server.context.a deviceContext = this.f.a(deviceMac);
        if (Objects.nonNull(deviceContext)) {
            deviceDatagramDTO.setDeviceType(deviceContext.j().getType());
        }
        if (this.a(messageType, channel)) {
            if (!this.a(deviceMac, channel)) {
                return Single.just((Object)OperationResponse.error((Integer)9000));
            }
            return this.a(deviceDatagramDTO);
        }
        return this.a(deviceDatagramDTO).map(sendResponseResult -> this.a(deviceMac, messageType, (OperationResponse<EcspMessage>)sendResponseResult, channel));
    }

    private boolean a(int messageType, Channel channel) {
        InetSocketAddress serverUrl;
        if (MessageType.SET_REQUEST.getValue() != messageType) {
            return false;
        }
        InetSocketAddress inetSocketAddress = serverUrl = channel == null ? null : channel.getLocalAddress();
        if (serverUrl == null) {
            return false;
        }
        ServerType serverType = this.b().get(serverUrl.getPort());
        return ServerType.ADOPT.equals((Object)serverType);
    }

    private OperationResponse<EcspMessage> a(String deviceMac, int messageType, OperationResponse<EcspMessage> sendResult, Channel channel) {
        if (MessageType.REBUILD_RESPONSE.getValue() != messageType) {
            return sendResult;
        }
        if (!sendResult.isOk()) {
            a.info("need not reinit handler for {}, cause send REBUILD_RESPONSE failed", (Object)deviceMac);
            return sendResult;
        }
        return this.a(deviceMac, channel) ? OperationResponse.ok() : OperationResponse.error((Integer)9000);
    }

    public Single<OperationResponse<Void>> b(DeviceSocketDTO deviceSocketDTO) {
        return Single.just(this.a(deviceSocketDTO));
    }

    public boolean a(String deviceMac, @Nonnull Channel channel) {
        if (!this.a(channel)) {
            a.info("failed to re init channel handler for {}, cause: no connect channel", (Object)deviceMac);
            return false;
        }
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.d);
        if (Objects.isNull(serverRouteDTO)) {
            a.info("failed to re init channel handler for {}, cause: server route is null", (Object)deviceMac);
            return false;
        }
        byte[] key = serverRouteDTO.getKey();
        if (Objects.isNull(key)) {
            a.info("failed to re init channel handler for {}, cause: rc4 key is null", (Object)deviceMac);
            return false;
        }
        return channel.reinitRc4Handler(key);
    }

    @Override
    public int g() {
        return this.k.entrySet().stream().filter(entry -> ServerType.ADOPT.equals(entry.getValue())).findFirst().map(Map.Entry::getKey).orElse(29812);
    }

    @Override
    public b h() {
        return this.f;
    }

    @Override
    public String a(@Nonnull DeviceMessageInfo deviceMessageInfo) {
        String deviceMac = deviceMessageInfo.getDeviceMac();
        com.tplink.smb.ecsp.server.context.a context = this.f.a(deviceMac);
        if (Objects.isNull(context)) {
            a.info("build ecsp message error for {}, cause: v1 device context is null", (Object)deviceMac);
            return null;
        }
        if (!StringUtils.isEquals((String)context.p(), (String)deviceMessageInfo.getVersion()) && !this.f.a(deviceMac, deviceMessageInfo.getVersion())) {
            a.info("build ecsp message error for {}, cause: update v1 device context ecsp version fail", (Object)deviceMac);
            return null;
        }
        String bodyStr = deviceMessageInfo.getMessageBody();
        MessageType messageType = MessageType.fromInteger((int)deviceMessageInfo.getMessageType());
        a.debug("v1 server send message type {} for {}", (Object)messageType, (Object)deviceMac);
        String ecspMessage = null;
        switch (messageType) {
            case ADOPT_REQUEST: {
                ecspMessage = com.tplink.smb.ecsp.server.e.c.a(context);
                break;
            }
            case INIT_SYNC: 
            case SET_REQUEST: {
                ecspMessage = com.tplink.smb.ecsp.server.e.c.a(context, bodyStr, MessageType.SET_REQUEST);
                break;
            }
            case GET_REQUEST: {
                ecspMessage = com.tplink.smb.ecsp.server.e.c.a(context, bodyStr, MessageType.GET_REQUEST);
                break;
            }
            case INFORM_RESPONSE: {
                ecspMessage = com.tplink.smb.ecsp.server.e.c.a(context, null, messageType);
                break;
            }
            case EVENT_PORTAL_AUTH: 
            case NOTIFY_REPLY: 
            case UPGRADE_REQUEST: 
            case FORGET_REQUEST: 
            case FORGET_REQUEST_NO_RESET: {
                ecspMessage = com.tplink.smb.ecsp.server.e.c.a(context, bodyStr, messageType);
                break;
            }
            case REBUILD_RESPONSE: {
                ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.d);
                if (Objects.isNull(serverRouteDTO) || Objects.isNull(serverRouteDTO.getKey())) {
                    a.info("build rebuild response error for {}, cause: key is null", (Object)deviceMac);
                    return null;
                }
                ecspMessage = com.tplink.smb.ecsp.server.e.c.a(context, bodyStr, serverRouteDTO.getKey());
                break;
            }
        }
        return ecspMessage;
    }

    @Override
    public Channel a(@Nonnull String deviceMac, ServerType serverType) {
        com.tplink.smb.ecsp.server.context.a deviceContext = this.f.a(deviceMac);
        if (Objects.isNull(deviceContext)) {
            a.info("build ecsp message error for {}, cause: device context is null", (Object)deviceMac);
            return null;
        }
        return DeviceNetStatus.isV1AdoptConnected((DeviceNetStatus)deviceContext.q()) ? deviceContext.C() : deviceContext.E();
    }

    @Override
    EcspVersion i() {
        return EcspVersion.VERSION_1;
    }

    @Override
    com.tplink.smb.ecsp.server.b j() {
        return this.h;
    }
}

