/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.c;

import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.XSSAttackUtils;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.EcspPacket;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.server.a.a;
import com.tplink.smb.ecsp.server.c.p;
import com.tplink.smb.ecsp.server.n;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerAdapter;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class e
extends ChannelHandlerAdapter {
    private static final Logger a = LoggerFactory.getLogger(e.class);
    private final a b;
    private final n c;

    e(a discoveryHandler, n executorService) {
        this.b = discoveryHandler;
        this.c = executorService;
    }

    @Trace(operationName="discovery.received")
    public void received(Channel channel, Object message) throws RemotingException {
        super.received(channel, message);
        EcspPacket ecspPacket = (EcspPacket)message;
        OperationResponse<String> xssOperationResponse = this.a(ecspPacket);
        String payloadJson = (String)xssOperationResponse.getResult();
        if (!xssOperationResponse.isOk()) {
            a.warn("discovery packet contain xss, attacker: {}, payload: {}", (Object)ecspPacket.getRemoteAddress(), (Object)payloadJson);
            ServerMonitor.incXSSAttackCounter((MessageType)MessageType.DISCOVERY);
            return;
        }
        EcspMessage ecspMessage = EcspPacket.parseEcspMessage((String)payloadJson, (InetSocketAddress)ecspPacket.getRemoteAddress());
        if (EcspMessage.isNotValid((EcspMessage)ecspMessage) || !Objects.equals(MessageType.DISCOVERY.getValue(), ecspMessage.getMessageType()) || !this.b.a(ecspMessage.getDeviceType())) {
            a.info("invalid device message {}, ignore.", message);
            return;
        }
        try {
            p.a(channel, ecspMessage);
            if (a.isTraceEnabled()) {
                a.trace("receive udp packet mac: {}, local address: {}, remote address: {}", new Object[]{OmadaPIIUtils.encryptWithCache((String)ecspMessage.getMac()), OmadaPIIUtils.encryptWithoutCache((String)ecspPacket.getLocalAddress().getHostString()), OmadaPIIUtils.encryptWithoutCache((String)ecspPacket.getRemoteAddress().getHostString())});
            }
        }
        catch (Exception e2) {
            a.warn("Exception occured when trying to log discovery message from udp packet: {}", (Object)e2.getMessage(), (Object)e2);
        }
        this.c.a(() -> this.b.a(ecspMessage, ecspPacket.getLocalAddress(), ecspPacket.getRemoteAddress()));
    }

    private OperationResponse<String> a(EcspPacket ecspPacket) {
        String payloadJson = StandardCharsets.UTF_8.decode(ecspPacket.getPayload()).toString();
        boolean containXSS = XSSAttackUtils.containXSS((String)payloadJson);
        if (containXSS) {
            return new OperationResponse(Integer.valueOf(1610), (Object)payloadJson);
        }
        return OperationResponse.ok((Object)payloadJson);
    }

    public void caught(Channel channel, Throwable exception) {
        a.warn("UDP channel caught exception: {}", (Object)exception.getMessage(), (Object)exception);
    }
}

