/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.c;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.RateLimiter;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.common.Pair;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.message.cache.AdoptInfoCacheUtils;
import com.tplink.smb.ecsp.message.cache.AdoptInfoDTO;
import com.tplink.smb.ecsp.message.cache.ServerRouteCacheUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceAdoptInfoDTO;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.DeviceNetStatus;
import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.EcspPacket;
import com.tplink.smb.ecsp.protocol.packet.Message;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.server.c.d;
import com.tplink.smb.ecsp.server.c.e;
import com.tplink.smb.ecsp.server.c.f;
import com.tplink.smb.ecsp.server.c.l;
import com.tplink.smb.ecsp.server.c.p;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.a;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.m;
import com.tplink.smb.ecsp.server.n;
import com.tplink.smb.ecsp.transport.api.Server;
import com.tplink.smb.ecsp.transport.api.Transporters;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerAdapter;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class c
implements com.tplink.smb.ecsp.server.d.a,
m {
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Resource
    private Transporters b;
    @Resource
    private com.tplink.smb.ecsp.server.a.a c;
    @Resource
    private n d;
    @Resource
    private b e;
    @Autowired(required=false)
    private f f;
    @Autowired(required=false)
    private l g;
    @Autowired(required=false)
    @Qualifier(value="deviceGatewayServiceGrpcClient")
    private com.tplink.smb.ecsp.a.a.b h;
    @Resource
    private CacheService i;
    @Resource
    private LockService j;
    @Resource
    private EcspServerProperties k;
    private final ConcurrentHashMap<Integer, Server> l = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ServerType> m = new ConcurrentHashMap();
    private static final ReadWriteLock n = new ReentrantReadWriteLock();
    private static LoadingCache<String, RateLimiter> o;

    @PostConstruct
    public void g() {
        com.tplink.smb.ecsp.server.c.c.a(this.k.getMaxAdoptSyncNum());
    }

    public static void a(double permitsPerSecond) {
        n.writeLock().lock();
        try {
            o = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new d(permitsPerSecond));
            a.info("update rateLimiterCache, permitsPerSecond = {}", (Object)permitsPerSecond);
        }
        finally {
            n.writeLock().unlock();
        }
    }

    @Override
    public ConcurrentHashMap<Integer, Server> a() {
        return this.l;
    }

    @Override
    public ConcurrentHashMap<Integer, ServerType> b() {
        return this.m;
    }

    @Override
    public ChannelHandlerAdapter c() {
        return new e(this.c, this.d);
    }

    @Override
    public Transporters d() {
        return this.b;
    }

    @Override
    public Logger e() {
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Single<OperationResponse<Void>> a(DeviceAdoptInfoDTO deviceInfoDTO) {
        if (Objects.isNull(deviceInfoDTO) || StringUtils.isEmpty((String)deviceInfoDTO.getMac()) || StringUtils.isEmpty((String)deviceInfoDTO.getVersion())) {
            return Single.just((Object)OperationResponse.error((Integer)7000, (String)"Failed to send udp data async. case: device info is null."));
        }
        String deviceMac = deviceInfoDTO.getMac();
        String gRpcClientHostName = deviceInfoDTO.getGRpcClientHostName();
        if (StringUtils.isEmpty((String)gRpcClientHostName)) {
            gRpcClientHostName = "localhost";
        }
        n.readLock().lock();
        try {
            a.trace("start acquire rate limiter for {}, from {}", (Object)deviceMac, (Object)gRpcClientHostName);
            ((RateLimiter)o.get((Object)gRpcClientHostName)).acquire();
        }
        catch (ExecutionException e2) {
            a.warn("Failed acquire limiter for {}, from {}, exception: {}", new Object[]{deviceMac, gRpcClientHostName, e2.getMessage(), e2});
            Single single = Single.just((Object)OperationResponse.error((Integer)7000, (String)"Failed to send udp data async. case: acquire rate limiter failed."));
            return single;
        }
        finally {
            n.readLock().unlock();
        }
        a.trace("Success acquire rate limiter for {}, from {}", (Object)deviceMac, (Object)gRpcClientHostName);
        long preAdoptTimeout = this.k.getDeviceContextTimeout().getAdoptChannelTimeout();
        this.a(deviceMac, preAdoptTimeout / 1000L);
        this.a(deviceInfoDTO, preAdoptTimeout / 1000L);
        this.e.a(deviceInfoDTO);
        a deviceContext = this.e.a(deviceMac);
        if (Objects.isNull(deviceContext) || Objects.isNull(deviceContext.B())) {
            return Single.just((Object)OperationResponse.ok());
        }
        EcspVersion ecspVersion = EcspVersion.getEcspVersion((String)deviceInfoDTO.getVersion());
        a.debug("going to send PRE_ADOPT_REQUEST to {}, version: {}", (Object)deviceMac, (Object)ecspVersion);
        EcspMessage preAdoptRequest = null;
        if ((EcspVersion.VERSION_2.equals((Object)ecspVersion) || EcspVersion.VERSION_3.equals((Object)ecspVersion)) && Objects.nonNull(this.g)) {
            int propertiesPort = this.k.getAdoptPortV2() > 0 ? this.k.getAdoptPortV2() : this.g.g();
            int adoptServerPort = deviceContext.n() == null ? propertiesPort : deviceContext.n();
            preAdoptRequest = com.tplink.smb.ecsp.server.e.d.a(deviceContext, adoptServerPort);
        } else if (Objects.nonNull(this.f)) {
            int adoptServerPort = this.k.getAdoptPortV1() > 0 ? this.k.getAdoptPortV1() : this.f.g();
            preAdoptRequest = com.tplink.smb.ecsp.server.e.c.a(deviceContext, adoptServerPort);
        }
        return this.a(preAdoptRequest, deviceContext.B()).doOnSuccess(response -> {
            if (response.isOk()) {
                ServerMonitor.incOutgoingEcspUdpCounter((MessageType)MessageType.PRE_ADOPT_REQUEST, (EcspVersion)ecspVersion);
            }
        });
    }

    private void a(String deviceMac, long preAdoptTimeout) {
        ServerRouteCacheUtils.doWithTryLock((LockService)this.j, (String)deviceMac, (int)this.k.getTryLockTimeout(), () -> {
            ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.i);
            if (Objects.nonNull(serverRouteDTO)) {
                com.tplink.smb.ecsp.server.e.e.a(deviceMac, null, serverRouteDTO.getAdoptServerRoute(), serverRouteDTO.getManageServerRoute(), this.d, this.h, this.k.getGrpcTimeout());
            }
            a.debug("create pre adopt status server route for device {}", (Object)deviceMac);
            serverRouteDTO = new ServerRouteDTO();
            serverRouteDTO.setDeviceStatusValue(DeviceNetStatus.ADOPTING_PENDING_PRE_ADOPT.getValue());
            ServerRouteCacheUtils.setServerRouteCache((String)deviceMac, (ServerRouteDTO)serverRouteDTO, (long)preAdoptTimeout, (CacheService)this.i);
            return null;
        });
    }

    private void a(DeviceAdoptInfoDTO deviceInfoDTO, long preAdoptTimeout) {
        AdoptInfoDTO adoptInfoDTO = new AdoptInfoDTO(deviceInfoDTO.getVersion());
        AdoptInfoCacheUtils.setDeviceAdoptInfoCache((String)deviceInfoDTO.getMac(), (AdoptInfoDTO)adoptInfoDTO, (long)preAdoptTimeout, (CacheService)this.i);
    }

    public Single<OperationResponse<Void>> a(EcspMessage ecspMessage, Pair<InetSocketAddress, InetSocketAddress> deviceAddress) {
        if (EcspMessage.isNotValid((EcspMessage)ecspMessage)) {
            return Single.just((Object)OperationResponse.error((Integer)1050, (String)("Failed to send message " + ecspMessage + ". case: message is un valid.")));
        }
        if (Objects.isNull(deviceAddress) || Objects.isNull(deviceAddress.getValue())) {
            return Single.just((Object)OperationResponse.error((Integer)7000, (String)("Failed to send message " + ecspMessage + ". case: device address is null.")));
        }
        if (Objects.isNull(deviceAddress.getKey())) {
            return this.b(ecspMessage, (InetSocketAddress)deviceAddress.getValue()).flatMap(response -> response.isOk() ? Single.just((Object)OperationResponse.ok()) : this.b(ecspMessage, (InetSocketAddress)deviceAddress.getValue()));
        }
        return this.a(ecspMessage, ((InetSocketAddress)deviceAddress.getKey()).getPort(), (InetSocketAddress)deviceAddress.getValue()).flatMap(response -> response.isOk() ? Single.just((Object)OperationResponse.ok()) : this.a(ecspMessage, ((InetSocketAddress)deviceAddress.getKey()).getPort(), (InetSocketAddress)deviceAddress.getValue()));
    }

    private EcspPacket a(EcspMessage message, InetSocketAddress deviceAddress) {
        return EcspPacket.buildFromMessage((Message)message).toBuilder().remoteAddress(deviceAddress).build();
    }

    @Deprecated
    private Single<OperationResponse<Void>> b(EcspMessage message, InetSocketAddress deviceAddress) {
        p.a(null, message, (String)Optional.ofNullable(this.e.a(message.getMac())).map(a::j).map(DeviceType::getType).orElse(null));
        return this.a().values().stream().findAny().map(server -> Single.zip((SingleSource)server.send((Object)this.a(message, deviceAddress)), (SingleSource)server.send((Object)this.a(message, deviceAddress)), (SingleSource)server.send((Object)this.a(message, deviceAddress)), (aBoolean, aBoolean2, aBoolean3) -> this.a((Boolean)aBoolean) || this.a((Boolean)aBoolean2) || this.a((Boolean)aBoolean3) ? OperationResponse.ok() : OperationResponse.error((Integer)7000))).orElseGet(() -> Single.just((Object)OperationResponse.error((Integer)7000)));
    }

    private Single<OperationResponse<Void>> a(EcspMessage message, Integer port, InetSocketAddress deviceAddress) {
        p.a(null, message, (String)Optional.ofNullable(this.e.a(message.getMac())).map(a::j).map(DeviceType::getType).orElse(null));
        Server server = this.a().get(port);
        if (Objects.isNull(server)) {
            a.error("send udp with unknown server port: {}", (Object)port);
            return Single.just((Object)OperationResponse.error((Integer)7000));
        }
        return Single.zip((SingleSource)server.send((Object)this.a(message, deviceAddress)), (SingleSource)server.send((Object)this.a(message, deviceAddress)), (SingleSource)server.send((Object)this.a(message, deviceAddress)), (aBoolean, aBoolean2, aBoolean3) -> this.a((Boolean)aBoolean) || this.a((Boolean)aBoolean2) || this.a((Boolean)aBoolean3) ? OperationResponse.ok() : OperationResponse.error((Integer)7000));
    }

    private boolean a(Boolean aBoolean) {
        return Boolean.TRUE.equals(aBoolean);
    }
}

