/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.c;

import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.message.grpc.DeviceDatagramDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceMessageInfo;
import com.tplink.smb.ecsp.message.grpc.DeviceSocketDTO;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.EcspPacket;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.server.c.p;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.m;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import io.micrometer.core.instrument.Timer;
import io.reactivex.Single;
import io.reactivex.subjects.Subject;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class a
implements m {
    private static final Logger a = LoggerFactory.getLogger(a.class);

    void a(EcspMessage ecspMessage) {
        MessageType messageType = MessageType.fromInteger((int)ecspMessage.getMessageType());
        Subject<EcspMessage> responseResultSubject = this.j().a(ecspMessage.getMac(), ecspMessage.getMessageType(), ecspMessage.getSeq());
        if (responseResultSubject != null) {
            responseResultSubject.onNext((Object)ecspMessage);
        } else {
            a.info("publish response failed for {}, type = {}, cause subject is null", (Object)ecspMessage.getMac(), (Object)messageType);
        }
    }

    @Trace(operationName="sever.sendTcpMessage")
    Single<OperationResponse<EcspMessage>> a(DeviceDatagramDTO deviceDatagramDTO) {
        String deviceMac = deviceDatagramDTO.getDeviceMac();
        String deviceType = deviceDatagramDTO.getDeviceType();
        DeviceMessageInfo deviceMessageInfo = deviceDatagramDTO.getDeviceMessageInfo();
        String ecspMessage = this.a(deviceMessageInfo);
        if (Objects.isNull(ecspMessage)) {
            return Single.just((Object)OperationResponse.error((Integer)1000, (String)("cause: buildEcspMessage error: " + deviceMessageInfo)));
        }
        long startTime = System.nanoTime();
        MessageType messageType = MessageType.fromInteger((int)deviceMessageInfo.getMessageType());
        Integer seq = deviceMessageInfo.getMessageSeq();
        long deviceContextTimeout = deviceDatagramDTO.getDeviceContextTimeout();
        long waitTimeout = deviceDatagramDTO.getTimeout();
        Boolean needResponse = deviceDatagramDTO.getNeedResponse();
        ServerType serverType = deviceDatagramDTO.getServerType();
        Channel channel = this.a(deviceMac, serverType);
        return this.a(ecspMessage, messageType, deviceMac, deviceType, channel).flatMap(sendResult -> {
            if (!sendResult.isOk()) {
                return Single.just((Object)new OperationResponse(sendResult.getErrorCode(), (Object)EcspMessage.builder().build()));
            }
            ServerMonitor.incOutgoingEcspTcpCounter((MessageType)messageType, (EcspVersion)this.i());
            boolean needWaitResponse = this.a(needResponse, messageType, seq);
            if (!needWaitResponse) {
                return Single.just((Object)new OperationResponse((Object)EcspMessage.builder().build()));
            }
            if (messageType == MessageType.FORGET_REQUEST || messageType == MessageType.FORGET_REQUEST_NO_RESET) {
                this.h().c(deviceMac);
            } else {
                this.h().a(deviceMac, deviceContextTimeout);
            }
            Subject<EcspMessage> responseResultSubject = this.a(deviceMac, messageType, seq);
            if (Objects.isNull(responseResultSubject)) {
                return Single.just((Object)new OperationResponse((Object)EcspMessage.builder().build()));
            }
            return responseResultSubject.filter(message -> this.a(deviceMac, messageType, seq, (EcspMessage)message)).firstOrError().map(responseMessage -> {
                Timer timer = ServerMonitor.getEcspWaitResponseTimer((MessageType)messageType, (EcspVersion)this.i());
                timer.record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                return OperationResponse.ok((Object)responseMessage);
            });
        }).doFinally(() -> this.b(deviceMac, messageType, seq)).timeout(waitTimeout, TimeUnit.MILLISECONDS);
    }

    private boolean a(String deviceMac, MessageType messageType, Integer seq, EcspMessage message) {
        if (messageType == MessageType.FORGET_REQUEST || messageType == MessageType.FORGET_REQUEST_NO_RESET) {
            return deviceMac.equals(message.getMac());
        }
        return deviceMac.equals(message.getMac()) && Objects.equals(seq, message.getSeq());
    }

    private boolean a(Boolean needResponse, MessageType messageType, Integer seq) {
        if (!Boolean.TRUE.equals(needResponse)) {
            return false;
        }
        if (messageType == MessageType.GET_REQUEST || messageType == MessageType.SET_REQUEST || messageType == MessageType.FORGET_REQUEST || messageType == MessageType.FORGET_REQUEST_NO_RESET || messageType == MessageType.UPGRADE_REQUEST_V2 || messageType == MessageType.REBUILD_RESPONSE) {
            return true;
        }
        return messageType == MessageType.EVENT_PORTAL_AUTH && seq != null;
    }

    private Subject<EcspMessage> a(String deviceMac, MessageType messageType, Integer seq) {
        switch (messageType) {
            case SET_REQUEST: {
                return this.j().a(deviceMac, MessageType.SET_RESPONSE.getValue(), seq);
            }
            case GET_REQUEST: {
                return this.j().a(deviceMac, MessageType.GET_RESPONSE.getValue(), seq);
            }
            case EVENT_PORTAL_AUTH: {
                return this.j().a(deviceMac, MessageType.EVENT_PORTAL_AUTH_RESPONSE.getValue(), seq);
            }
            case UPGRADE_REQUEST_V2: {
                return this.j().a(deviceMac, MessageType.UPGRADE_RESPONSE_V2.getValue(), seq);
            }
            case REBUILD_RESPONSE: {
                return this.j().a(deviceMac, MessageType.REBUILD_RESULT.getValue(), seq);
            }
            case FORGET_REQUEST: {
                return this.j().a(deviceMac, MessageType.FORGET_RESPONSE.getValue(), null);
            }
            case FORGET_REQUEST_NO_RESET: {
                return this.j().a(deviceMac, MessageType.FORGET_RESPONSE_NO_RESET.getValue(), null);
            }
        }
        return null;
    }

    private void b(String deviceMac, MessageType messageType, Integer seq) {
        switch (messageType) {
            case SET_REQUEST: {
                this.j().b(deviceMac, MessageType.SET_RESPONSE.getValue(), seq);
                break;
            }
            case GET_REQUEST: {
                this.j().b(deviceMac, MessageType.GET_RESPONSE.getValue(), seq);
                break;
            }
            case EVENT_PORTAL_AUTH: {
                this.j().b(deviceMac, MessageType.EVENT_PORTAL_AUTH_RESPONSE.getValue(), seq);
                break;
            }
            case UPGRADE_REQUEST_V2: {
                this.j().b(deviceMac, MessageType.UPGRADE_RESPONSE_V2.getValue(), seq);
                break;
            }
            case FORGET_REQUEST: {
                this.j().b(deviceMac, MessageType.FORGET_RESPONSE.getValue(), null);
                break;
            }
            case FORGET_REQUEST_NO_RESET: {
                this.j().b(deviceMac, MessageType.FORGET_RESPONSE_NO_RESET.getValue(), null);
                break;
            }
            case REBUILD_RESPONSE: {
                this.j().b(deviceMac, MessageType.REBUILD_RESULT.getValue(), null);
                break;
            }
        }
    }

    OperationResponse<Void> a(DeviceSocketDTO deviceSocketDTO) {
        Channel channel;
        String deviceMac = deviceSocketDTO.getDeviceMac();
        com.tplink.smb.ecsp.server.context.a deviceContext = this.h().a(deviceMac);
        if (Objects.isNull(deviceContext)) {
            a.debug("need not to close channel for mac {}, cause device context is null", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            return OperationResponse.ok();
        }
        if (Boolean.TRUE.equals(deviceSocketDTO.getRemoveDeviceContext())) {
            this.h().c(deviceMac);
        }
        if (Objects.isNull(channel = this.c(deviceSocketDTO))) {
            return OperationResponse.error((Integer)9500);
        }
        if (this.a(channel)) {
            channel.close();
        }
        return OperationResponse.ok();
    }

    private Channel c(DeviceSocketDTO deviceSocketDTO) {
        ServerType serverType = deviceSocketDTO.getServerType();
        String deviceMac = deviceSocketDTO.getDeviceMac();
        Channel deviceChannel = Objects.nonNull(serverType) ? this.a(deviceMac, serverType) : this.a(deviceMac, ServerType.MANAGE);
        a.debug("get channel:{} for device mac:{} ", (Object)deviceChannel, (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
        return deviceChannel;
    }

    protected Single<OperationResponse<Void>> a(@Nonnull String message, @Nonnull MessageType messageType, @Nonnull String mac, String deviceType, @Nonnull Channel channel) {
        EcspPacket packet = EcspPacket.buildFromMessageStr((String)message);
        if (!this.a(channel)) {
            return Single.just((Object)OperationResponse.error((Integer)8000, (String)("Failed to send tcp data  cause: not connect channel " + channel)));
        }
        p.a(message, messageType, mac, deviceType, channel);
        return channel.send((Object)packet).map(aBoolean -> Boolean.TRUE.equals(aBoolean) ? OperationResponse.ok() : OperationResponse.error((Integer)7500));
    }

    public abstract int g();

    public abstract b h();

    public abstract String a(@Nonnull DeviceMessageInfo var1);

    public abstract Channel a(@Nonnull String var1, ServerType var2);

    abstract EcspVersion i();

    abstract com.tplink.smb.ecsp.server.b j();
}

