/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.a.b;

import com.google.common.util.concurrent.RateLimiter;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.ecsp.common.CipherType;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.common.Pair;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteCacheUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceAdoptInfoDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceRequestDTO;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.DeviceNetStatus;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.EcspPacket;
import com.tplink.smb.ecsp.protocol.packet.Message;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.PreConnectInfo;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.proxy.service.DeviceAdoptInfoService;
import com.tplink.smb.ecsp.server.a.b.f;
import com.tplink.smb.ecsp.server.c.p;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.a;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.e.d;
import com.tplink.smb.ecsp.server.n;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class g
implements DomainEventSubscriber<f> {
    private static final Logger a = LoggerFactory.getLogger(g.class);
    @Resource
    private CacheService b;
    @Resource
    private LockService c;
    @Resource
    private EcspServerProperties d;
    @Resource
    private b e;
    @Resource
    private n f;
    @Resource
    private DeviceAdoptInfoService g;
    private RateLimiter h;

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().register(f.class, (DomainEventSubscriber)this, this.f.d());
        this.a(this.d.getMaxAdoptSyncNum() * 2.0);
    }

    public void a(double permitsPerSecond) {
        this.h = RateLimiter.create((double)permitsPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean a(RateLimiter rateLimiter) {
        g g2 = this;
        synchronized (g2) {
            a.debug("limiter now : {}", (Object)rateLimiter);
            return rateLimiter.tryAcquire();
        }
    }

    public void a(f event) {
        if (Objects.isNull((Object)event) || event.a()) {
            a.info("receive invalid v2 pre connect event: {}", (Object)JacksonUtils.pojo2Json((Object)((Object)event)));
            return;
        }
        String deviceMac = event.c();
        a.debug("handle PreConnectInfo event for v2 device {}", (Object)deviceMac);
        Channel channel = event.e();
        EcspMessage preConnectInfo = event.d();
        if (this.a(deviceMac, preConnectInfo, channel)) {
            a deviceContext = this.e.a(deviceMac);
            if (Objects.isNull(deviceContext)) {
                a.info("handle PreConnectInfo failed for {}, close channel {}, cause device context is null", (Object)deviceMac, (Object)channel);
                channel.close();
                return;
            }
            this.a(deviceContext);
            this.a(channel, deviceContext, preConnectInfo);
            return;
        }
        a.info("update v2 pre connect device context failed for device: {}, close channel", (Object)deviceMac);
        channel.close();
    }

    private boolean a(String deviceMac, EcspMessage preConnectInfo, Channel manageChannel) {
        a oldContext = this.e.a(deviceMac);
        if (Objects.isNull(oldContext)) {
            oldContext = new a(DeviceType.resolve((String)preConnectInfo.getDeviceType()), preConnectInfo.getVersion(), DeviceNetStatus.ADOPTING_PRE_CONNECT, deviceMac, null);
            return this.a(deviceMac, oldContext, manageChannel, preConnectInfo);
        }
        switch (oldContext.q()) {
            case DISCOVERY: 
            case ADOPTING_PENDING_PRE_ADOPT: 
            case ADOPTING_PRE_ADOPT: 
            case ADOPTING_PRE_CONNECT: 
            case ADOPTING_DEVICE_VERIFY: 
            case ADOPTING_SYSTEM_VERIFY: {
                return this.a(deviceMac, oldContext, manageChannel, preConnectInfo);
            }
            case CONNECTED: 
            case ADOPT_SUCCESS: {
                return this.a(deviceMac, oldContext, preConnectInfo);
            }
        }
        a.info("{} status is {}, but should be DISCOVERY / ADOPTING / CONNECTED while receiving manage server PRE_CONNECT_INFO", (Object)deviceMac, (Object)oldContext.q());
        return false;
    }

    private boolean a(String deviceMac, @Nonnull a oldContext, Channel manageChannel, EcspMessage preConnectInfo) {
        long start = System.currentTimeMillis();
        a deviceContext = CollectionUtils.isEmpty(oldContext.t()) ? this.a(deviceMac, preConnectInfo) : oldContext;
        long end = System.currentTimeMillis();
        a.debug("getAdoptInfoList cost time: {} ms", (Object)(end - start));
        if (Objects.isNull(deviceContext) || !EcspVersion.isEcspVersion2((String)deviceContext.p()) && !EcspVersion.isEcspVersion3((String)deviceContext.p())) {
            a.info("close {} device {} channel {}, cause not match pre connect status", new Object[]{Objects.isNull(deviceContext) ? "Unknown" : deviceContext.p(), deviceMac, manageChannel});
            return false;
        }
        return this.e.a(deviceMac, () -> {
            Channel oldManageChannel = oldContext.E();
            if (Objects.nonNull(oldManageChannel)) {
                a.debug("v2 device {} status is {}, close old manage channel", (Object)deviceMac, (Object)oldContext.q());
                oldManageChannel.close();
            }
            oldContext.a(DeviceNetStatus.ADOPTING_PRE_CONNECT);
            oldContext.a(System.currentTimeMillis());
            oldContext.d(this.d.getDeviceContextTimeout().getAdoptChannelTimeout());
            oldContext.a((Pair<InetSocketAddress, InetSocketAddress>)null);
            oldContext.d((Channel)null);
            oldContext.f(manageChannel);
            oldContext.a(deviceContext.t());
            oldContext.c(deviceContext.l());
            oldContext.a(deviceContext.p());
            oldContext.a(deviceContext.m());
            oldContext.b(deviceContext.n());
            oldContext.c(deviceContext.o());
            this.e.a(deviceMac, oldContext);
            a.debug("update v2 device {} status to ADOPTING_PRE_CONNECT", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            return true;
        }, () -> a.warn("failed to update deviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    private a a(String deviceMac, EcspMessage preConnectInfo) {
        OperationResponse response;
        if (!this.a(this.h)) {
            a.info("Failed to retrieve adoptinfo from the manager due to ratelimiter acquisition failure for device {}", (Object)deviceMac);
            return null;
        }
        a.debug("v2 device {} adopt info is null, going to get device adopt info from manager", (Object)deviceMac);
        try {
            response = (OperationResponse)this.g.getDeviceAdoptInfoAsync(new DeviceRequestDTO(deviceMac, preConnectInfo)).timeout(this.d.getGrpcTimeout(), TimeUnit.MILLISECONDS).blockingGet();
        }
        catch (Exception e2) {
            a.warn("get v2 device adopt info for {} error when handle new pre connect, exception: ", (Object)deviceMac, (Object)e2);
            return null;
        }
        if (Objects.nonNull(response) && response.isOk() && Objects.nonNull(response.getResult())) {
            a.debug("get v2 device adopt info for {} success, build ADOPTING_PRE_ADOPT context", (Object)deviceMac);
            DeviceAdoptInfoDTO deviceInfoDTO = (DeviceAdoptInfoDTO)response.getResult();
            a deviceContext = new a(DeviceType.resolve((String)preConnectInfo.getDeviceType()), deviceInfoDTO.getVersion(), DeviceNetStatus.ADOPTING_PRE_ADOPT, deviceMac, null);
            deviceContext.d(this.d.getDeviceContextTimeout().getAdoptChannelTimeout());
            deviceContext.a(deviceInfoDTO.getAdoptInfoList());
            deviceContext.c(deviceInfoDTO.getDestIp());
            deviceContext.a(deviceInfoDTO.getDestPort());
            deviceContext.b(deviceInfoDTO.getPreAdoptPort());
            deviceContext.c(deviceInfoDTO.getDestDiscPort());
            return deviceContext;
        }
        a.info("v2 device {} adopt info is null, can not auto adopt", (Object)deviceMac);
        return null;
    }

    private boolean a(String deviceMac, a oldContext, EcspMessage preConnectInfo) {
        boolean allowReLink = oldContext.d() < this.d.getDeviceLinkMaxSize();
        a.debug("connected v2 device {} re link, link size is {}, allowable is {}", new Object[]{deviceMac, oldContext.d(), allowReLink});
        if (!allowReLink) {
            return false;
        }
        a deviceContext = this.a(deviceMac, preConnectInfo);
        if (Objects.isNull(deviceContext) || !EcspVersion.isEcspVersion2((String)deviceContext.p()) && !EcspVersion.isEcspVersion3((String)deviceContext.p())) {
            return false;
        }
        return this.e.a(deviceMac, () -> {
            oldContext.a(deviceContext.t());
            oldContext.c(deviceContext.l());
            oldContext.a(deviceContext.m());
            oldContext.b(deviceContext.n());
            oldContext.c(deviceContext.o());
            oldContext.a(deviceContext.p());
            this.e.a(deviceMac, oldContext);
            return true;
        }, () -> a.warn("failed to update adopt list when connected of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    private void a(Channel channel, a deviceContext, EcspMessage preConnectInfo) {
        String deviceMac = deviceContext.r();
        String deviceVerifyKey = UUID.randomUUID().toString();
        PreConnectInfo preConnectInfoBody = (PreConnectInfo)preConnectInfo.getBody();
        boolean needReplyUsername = Boolean.TRUE.equals(preConnectInfoBody.getNeedUsername());
        String usernameToReply = needReplyUsername ? deviceContext.f() : null;
        List<Integer> cipherCap = CipherType.getAllAlgorithms().keySet().stream().toList();
        EcspMessage preConnectInfoResponse = com.tplink.smb.ecsp.server.e.d.a(deviceContext, preConnectInfo.getSeq(), deviceVerifyKey, usernameToReply, cipherCap);
        this.e.updateDeviceVerifyDeviceContext(deviceMac, channel, deviceVerifyKey);
        p.a(channel, preConnectInfoResponse, (String)Optional.ofNullable(deviceContext.j()).map(DeviceType::getType).orElse(null));
        channel.send((Object)EcspPacket.buildFromMessage((Message)preConnectInfoResponse)).subscribe((sendResult, throwable) -> {
            if (Objects.nonNull(throwable)) {
                a.warn("send PRE_CONNECT_INFO_RESPONSE to {} error", (Object)deviceMac, throwable);
                this.a(deviceContext, preConnectInfo, channel);
                return;
            }
            if (Boolean.TRUE.equals(sendResult)) {
                a.debug("send PRE_CONNECT_INFO_RESPONSE to {} success.", (Object)deviceMac);
                ServerMonitor.incOutgoingEcspTcpCounter((MessageType)MessageType.PRE_CONNECT_INFO_RESPONSE, (EcspVersion)EcspVersion.VERSION_2);
            } else {
                a.warn("send PRE_CONNECT_INFO_RESPONSE to {} failed on transport", (Object)deviceMac);
                this.a(deviceContext, preConnectInfo, channel);
            }
        });
    }

    private void a(a deviceContext) {
        if (!this.e.a(deviceContext, DeviceNetStatus.ADOPTING_PRE_CONNECT)) {
            return;
        }
        String deviceMac = deviceContext.r();
        ServerRouteCacheUtils.doWithTryLock((LockService)this.c, (String)deviceMac, (int)this.d.getTryLockTimeout(), () -> {
            ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.b);
            if (Objects.isNull(serverRouteDTO) || serverRouteDTO.getDeviceStatusValue() != DeviceNetStatus.ADOPTING_PENDING_PRE_ADOPT.getValue()) {
                return null;
            }
            a.debug("adopting pre connect, set pre adopt status to false for device {}", (Object)deviceMac);
            serverRouteDTO.setDeviceStatusValue(0);
            ServerRouteCacheUtils.setServerRouteCache((String)deviceMac, (ServerRouteDTO)serverRouteDTO, (long)this.d.getAdoptingServerRouteExpire(), (CacheService)this.b);
            return null;
        });
    }

    private void a(a deviceContext, EcspMessage preConnectInfo, Channel channel) {
        if (this.e.a(deviceContext, DeviceNetStatus.ADOPTING_PRE_CONNECT) || this.e.a(deviceContext, DeviceNetStatus.ADOPTING_DEVICE_VERIFY)) {
            this.e.a(deviceContext.r(), preConnectInfo, channel);
            return;
        }
        if (this.e.a(deviceContext, DeviceNetStatus.CONNECTED)) {
            this.e.removeEcspV2VerifyInfo(deviceContext.r(), channel);
        }
        channel.close();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((f)((Object)object));
    }
}

