/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.a.b;

import com.tplink.smb.ecsp.common.CipherType;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.common.util.encrypt.CipherUtils;
import com.tplink.smb.ecsp.message.grpc.EcspAdoptInfo;
import com.tplink.smb.ecsp.protocol.DeviceNetStatus;
import com.tplink.smb.ecsp.protocol.EcspUtils;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.EcspPacket;
import com.tplink.smb.ecsp.protocol.packet.Message;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.DeviceVerifyInfo;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.protocol.packet.header.MessageHeader;
import com.tplink.smb.ecsp.server.a.d;
import com.tplink.smb.ecsp.server.c.p;
import com.tplink.smb.ecsp.server.context.a;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.m;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class c
implements d {
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Resource
    private b b;

    @Override
    public String a() {
        return com.tplink.smb.ecsp.server.a.c.f.a();
    }

    @Override
    public boolean a(EcspMessage deviceVerifyMessage, Channel channel, m serverCenter) {
        a deviceContext;
        MessageHeader header = deviceVerifyMessage.getHeader();
        String deviceMac = header.getMac();
        if (a.isDebugEnabled()) {
            a.debug("handle device verify Message for {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
        }
        if (Objects.isNull(deviceContext = this.b.a(deviceVerifyMessage.getMac()))) {
            ServerMonitor.incEcspVerifyFailedCounter((MessageType)MessageType.DEVICE_VERIFY_INFO, (String)"status.error");
            a.info("handle device verify failed for {}, close channel {}, cause device context is null", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)channel);
            channel.close();
            return false;
        }
        if (!(this.b.a(deviceContext, DeviceNetStatus.ADOPTING_DEVICE_VERIFY) || this.b.a(deviceContext, DeviceNetStatus.CONNECTED) || this.b.a(deviceContext, DeviceNetStatus.ADOPT_SUCCESS))) {
            ServerMonitor.incEcspVerifyFailedCounter((MessageType)MessageType.DEVICE_VERIFY_INFO, (String)"status.error");
            a.info("handle device verify failed for {}, close channel {}, cause device status {} not matched", new Object[]{OmadaPIIUtils.encryptWithCache((String)deviceMac), channel, deviceContext.q()});
            channel.close();
            return false;
        }
        int deviceVerifyError = deviceVerifyMessage.getError();
        if (0 != deviceVerifyError) {
            ServerMonitor.incEcspVerifyFailedCounter((MessageType)MessageType.DEVICE_VERIFY_INFO, (String)"errcode");
            a.info("handle device verify failed for {}, close channel {}, cause message error code {}", new Object[]{OmadaPIIUtils.encryptWithCache((String)deviceMac), channel, deviceVerifyError});
            this.a(deviceContext, deviceVerifyMessage, channel);
            return true;
        }
        boolean isDeviceValid = false;
        EcspAdoptInfo ecspAdoptInfo = null;
        DeviceVerifyInfo deviceVerifyInfo = (DeviceVerifyInfo)deviceVerifyMessage.getBody();
        if (Objects.isNull(deviceVerifyInfo.getRandomKeyForSystemVerify()) || deviceVerifyInfo.getRandomKeyForSystemVerify().length() < 36) {
            a.warn("handle device verify failed for {}, close channel {}, cause getRandomKeyForSystemVerify is empty {}", new Object[]{OmadaPIIUtils.encryptWithCache((String)deviceMac), channel, deviceVerifyError});
            ServerMonitor.incEcspVerifyFailedCounter((MessageType)MessageType.DEVICE_VERIFY_INFO, (String)"auth.random.key");
            this.a(deviceContext, deviceVerifyMessage, channel);
            return true;
        }
        Integer cipherTypeCode = deviceVerifyInfo.getCipherType();
        CipherType cipherType = CipherType.MD5;
        if (Objects.nonNull(cipherTypeCode) && (cipherType = CipherType.fromCode((Integer)cipherTypeCode)) == null) {
            ServerMonitor.incEcspVerifyFailedCounter((MessageType)MessageType.DEVICE_VERIFY_INFO, (String)"auth.verify");
            this.a(channel, deviceContext, deviceVerifyMessage);
            return true;
        }
        try {
            for (EcspAdoptInfo adoptInfo : deviceContext.t()) {
                String devicePassword = this.a(deviceMac, cipherType, adoptInfo.getPassword(), deviceVerifyInfo.getSalt(), deviceVerifyMessage.getVerCap());
                if (StringUtils.isEmpty((String)devicePassword)) continue;
                String verifyRandomKey = deviceContext.b(channel).a();
                String deviceAuth = EcspUtils.calculateEcsp2Auth((String)adoptInfo.getUsername(), (String)devicePassword, (String)verifyRandomKey);
                if (!StringUtils.isNotEmpty((String)deviceAuth) || !deviceAuth.equalsIgnoreCase(deviceVerifyInfo.getAuth())) continue;
                if (a.isDebugEnabled()) {
                    a.debug("deviceAuthPair match deviceVerifyInfo auth success for {}.", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                }
                isDeviceValid = true;
                adoptInfo.setCipherType(Integer.valueOf(cipherType.getCode()));
                adoptInfo.setSalt(deviceVerifyInfo.getSalt());
                ecspAdoptInfo = adoptInfo;
                break;
            }
        }
        catch (Exception e2) {
            ServerMonitor.incEcspVerifyFailedCounter((MessageType)MessageType.DEVICE_VERIFY_INFO, (String)"auth.calculate");
            a.info("handle device verify failed for {}, close channel {}, cause calculate deviceAuth failed", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)channel);
            this.a(deviceContext, deviceVerifyMessage, channel);
            return true;
        }
        if (!isDeviceValid) {
            ServerMonitor.incEcspVerifyFailedCounter((MessageType)MessageType.DEVICE_VERIFY_INFO, (String)"auth.verify");
        }
        this.a(deviceVerifyMessage, channel, deviceContext, deviceVerifyInfo.getRandomKeyForSystemVerify(), isDeviceValid, ecspAdoptInfo, cipherType, deviceVerifyInfo.getSalt());
        return !isDeviceValid;
    }

    private void a(EcspMessage deviceVerifyMessage, Channel channel, a deviceContext, String randomKeyForSystemVerify, boolean isDeviceValid, EcspAdoptInfo ecspAdoptInfo, CipherType cipherType, String salt) {
        String deviceMac = deviceVerifyMessage.getMac();
        String systemAuth = null;
        if (isDeviceValid && Objects.nonNull(ecspAdoptInfo)) {
            this.b.updateSystemVerifyDeviceContext(deviceMac, ecspAdoptInfo, channel);
            try {
                String devicePassword = this.a(deviceMac, cipherType, ecspAdoptInfo.getPassword(), salt, deviceVerifyMessage.getVerCap());
                systemAuth = EcspUtils.calculateEcsp2Auth((String)ecspAdoptInfo.getUsername(), (String)devicePassword, (String)randomKeyForSystemVerify);
            }
            catch (Exception e2) {
                a.info("Fail to send DEVICE_VERIFY_RESPONSE message to {}, close channel {}, cause calculate system auth failed", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)channel);
                ServerMonitor.incEcspVerifyFailedCounter((MessageType)MessageType.DEVICE_VERIFY_INFO, (String)"auth.calculate");
                this.a(deviceContext, deviceVerifyMessage, channel);
                return;
            }
        }
        EcspMessage deviceVerifyResponse = com.tplink.smb.ecsp.server.e.d.a(deviceContext, isDeviceValid, systemAuth);
        p.a(channel, deviceVerifyResponse, (String)Optional.ofNullable(deviceContext.j()).map(DeviceType::getType).orElse(null));
        channel.send((Object)EcspPacket.buildFromMessage((Message)deviceVerifyResponse)).subscribe((aBoolean, throwable) -> {
            if (Objects.nonNull(throwable)) {
                a.warn("send DEVICE_VERIFY_RESPONSE to {} error", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), throwable);
                this.a(deviceContext, deviceVerifyMessage, channel);
                return;
            }
            if (Boolean.TRUE.equals(aBoolean)) {
                if (a.isDebugEnabled()) {
                    a.debug("send DEVICE_VERIFY_RESPONSE to {} success.", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                }
                ServerMonitor.incOutgoingEcspTcpCounter((MessageType)MessageType.DEVICE_VERIFY_RESPONSE, (EcspVersion)EcspVersion.VERSION_2);
                if (!isDeviceValid) {
                    a.info("valid device_verify auth for {} failed, adopt info is wrong!", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                    this.a(deviceContext, deviceVerifyMessage, channel);
                }
            } else {
                a.warn("send DEVICE_VERIFY_RESPONSE to {} failed on transport", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                this.a(deviceContext, deviceVerifyMessage, channel);
            }
        });
    }

    private void a(Channel channel, a deviceContext, EcspMessage deviceVerifyMessage) {
        EcspMessage deviceVerifyResponse = com.tplink.smb.ecsp.server.e.d.a(deviceContext);
        p.a(channel, deviceVerifyResponse, (String)Optional.ofNullable(deviceContext.j()).map(DeviceType::getType).orElse(null));
        String deviceMac = deviceContext.r();
        channel.send((Object)EcspPacket.buildFromMessage((Message)deviceVerifyResponse)).subscribe((aBoolean, throwable) -> {
            if (Objects.nonNull(throwable)) {
                a.warn("send unknown cipherType DEVICE_VERIFY_RESPONSE to {} error", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), throwable);
                this.a(deviceContext, deviceVerifyMessage, channel);
                return;
            }
            if (Boolean.TRUE.equals(aBoolean)) {
                if (a.isDebugEnabled()) {
                    a.debug("send unknown cipherType DEVICE_VERIFY_RESPONSE to {} success.", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                }
                ServerMonitor.incOutgoingEcspTcpCounter((MessageType)MessageType.DEVICE_VERIFY_RESPONSE, (EcspVersion)EcspVersion.VERSION_2);
            } else {
                a.warn("send unknown cipherType DEVICE_VERIFY_RESPONSE to {} failed on transport, ", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            }
        });
        this.a(deviceContext, deviceVerifyMessage, channel);
    }

    private void a(a deviceContext, EcspMessage deviceVerifyMessage, Channel channel) {
        if (this.b.a(deviceContext, DeviceNetStatus.ADOPTING_DEVICE_VERIFY) || this.b.a(deviceContext, DeviceNetStatus.ADOPTING_SYSTEM_VERIFY)) {
            this.b.a(deviceContext.r(), deviceVerifyMessage, channel);
            return;
        }
        if (this.b.a(deviceContext, DeviceNetStatus.CONNECTED)) {
            this.b.removeEcspV2VerifyInfo(deviceContext.r(), channel);
        }
        channel.close();
    }

    private String a(String deviceMac, CipherType cipherType, String originPassword, String salt, Integer verCap) {
        if (originPassword == null) {
            a.warn("CIPHER: originPassword is null for {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            return null;
        }
        try {
            switch (cipherType) {
                case SHA256: {
                    if (!c.a(salt)) {
                        a.warn("CIPHER: handle device verify failed for {}, cause lack of salt", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
                        return null;
                    }
                    return CipherUtils.encryptSHA256WithSalt((String)originPassword, (String)salt);
                }
            }
            return CipherUtils.encryptMD5Str((String)originPassword);
        }
        catch (Exception e2) {
            a.warn("Fail to encrypt password for device {}, cause {}", new Object[]{OmadaPIIUtils.encryptWithCache((String)deviceMac), e2.getMessage(), e2});
            return "";
        }
    }

    public static boolean a(String salt) {
        if (salt == null || salt.isEmpty() || salt.length() < 12) {
            return false;
        }
        Pattern hexPattern = Pattern.compile("^[0-9A-F]+$");
        return hexPattern.matcher(salt).matches();
    }
}

