/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.a.a;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.encrypt.CipherUtils;
import com.tplink.smb.ecsp.common.util.encrypt.RC4Utils;
import com.tplink.smb.ecsp.common.util.encrypt.RsaCipher;
import com.tplink.smb.ecsp.message.cache.ServerRouteCacheUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import com.tplink.smb.ecsp.protocol.DeviceNetStatus;
import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.body.data.AdoptDeviceInfo;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseAdoptResponse;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.protocol.packet.header.MessageHeader;
import com.tplink.smb.ecsp.server.a.d;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.a;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.e.e;
import com.tplink.smb.ecsp.server.m;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class c
implements d {
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    private CacheService b;
    @Resource
    private EcspServerProperties c;
    @Resource
    @Lazy
    private b d;

    @Override
    public String a() {
        return com.tplink.smb.ecsp.server.a.c.a.a();
    }

    @Override
    public boolean a(EcspMessage adoptResponse, Channel channel, m serverCenter) {
        MessageHeader header = adoptResponse.getHeader();
        String mac = adoptResponse.getMac();
        a.debug("handle adopt response Message for {}", (Object)OmadaPIIUtils.encryptWithCache((String)mac));
        int serverPort = channel.getLocalAddress().getPort();
        ServerType serverType = serverCenter.b().get(serverPort);
        if (!ServerType.ADOPT.equals((Object)serverType)) {
            a.info("handle adopt response failed for {}, close channel {}, cause not adopt server", (Object)OmadaPIIUtils.encryptWithCache((String)mac), (Object)channel);
            channel.close();
            return false;
        }
        Integer serverGrpcPort = this.c.getGrpcPort();
        AddressDTO localServerRoute = e.a(channel, serverGrpcPort);
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)mac, (CacheService)this.b);
        if (ServerRouteCacheUtils.isAdoptServerRouteNull((ServerRouteDTO)serverRouteDTO) || !Objects.equals(serverRouteDTO.getAdoptServerRoute(), localServerRoute) || !ServerRouteCacheUtils.isManageServerRouteNull((ServerRouteDTO)serverRouteDTO)) {
            a.info("device {} server route not match, should close adopt server channel {}", (Object)OmadaPIIUtils.encryptWithCache((String)mac), (Object)channel);
            channel.close();
            return false;
        }
        a deviceContext = this.d.a(mac);
        if (deviceContext == null || !EcspVersion.isEcspVersion1((String)deviceContext.p()) || !DeviceNetStatus.ADOPTING_PRE_CONNECT.equals((Object)deviceContext.q())) {
            a.info("device {} context not match, should close adopt server channel {}", (Object)OmadaPIIUtils.encryptWithCache((String)mac), (Object)channel);
            channel.close();
            return false;
        }
        if (header.getError() == 0) {
            try {
                BaseAdoptResponse baseAdoptResponse = (BaseAdoptResponse)adoptResponse.getBody();
                String responseKey = baseAdoptResponse.getKey();
                byte[] key = CipherUtils.decryptBASE64((String)responseKey);
                byte[] decryptedRc4Key = RsaCipher.decryptByPrivateKey((byte[])key);
                AdoptDeviceInfo deviceInfo = baseAdoptResponse.getDeviceInfo();
                if (deviceInfo != null) {
                    byte[] encryptedHwId = CipherUtils.decryptBASE64((String)deviceInfo.getEncryptedHwId());
                    String hwId = new String(RC4Utils.crypt((byte[])encryptedHwId, (byte[])decryptedRc4Key), StandardCharsets.UTF_8);
                    baseAdoptResponse.getDeviceInfo().setEncryptedHwId(hwId);
                    byte[] encryptedOemId = CipherUtils.decryptBASE64((String)deviceInfo.getEncryptedOemId());
                    String oemId = new String(RC4Utils.crypt((byte[])encryptedOemId, (byte[])decryptedRc4Key), StandardCharsets.UTF_8);
                    baseAdoptResponse.getDeviceInfo().setEncryptedOemId(oemId);
                }
                this.d.a(mac, decryptedRc4Key, serverRouteDTO);
                return true;
            }
            catch (Exception e2) {
                a.warn("handle adopt response error for mac: {}", (Object)OmadaPIIUtils.encryptWithCache((String)mac), (Object)e2);
                ServerMonitor.incEcspVerifyFailedCounter((MessageType)MessageType.ADOPT_RESPONSE, (String)"key.decrypt");
                this.d.a(mac, adoptResponse, channel);
                return true;
            }
        }
        a.info("handle adopt fail response for {}, errcode = {}", (Object)OmadaPIIUtils.encryptWithCache((String)mac), (Object)header.getError());
        ServerMonitor.incEcspVerifyFailedCounter((MessageType)MessageType.ADOPT_RESPONSE, (String)"errcode");
        this.d.a(mac, adoptResponse, channel);
        return true;
    }
}

