/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server.a.a;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.common.Pair;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteCacheUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceAdoptInfoDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceRequestDTO;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.DeviceNetStatus;
import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.proxy.service.DeviceAdoptInfoService;
import com.tplink.smb.ecsp.server.a.a.a;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.e.e;
import com.tplink.smb.ecsp.server.m;
import com.tplink.smb.ecsp.server.n;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class b
implements DomainEventSubscriber<a> {
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    @Qualifier(value="ecspV1ManageServerCenter")
    private m b;
    @Autowired
    private EventCenter c;
    @Autowired
    private CacheService d;
    @Autowired(required=false)
    @Qualifier(value="deviceGatewayServiceGrpcClient")
    private com.tplink.smb.ecsp.a.a.b e;
    @Resource
    private LockService f;
    @Resource
    private EcspServerProperties g;
    @Resource
    private n h;
    @Resource
    private com.tplink.smb.ecsp.server.context.b i;
    @Resource
    private DeviceAdoptInfoService j;

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().register(a.class, (DomainEventSubscriber)this, this.h.d());
    }

    public void a(a event) {
        if (Objects.isNull((Object)event) || event.a()) {
            a.info("receive invalid v1 adopt pre connect event: {}", (Object)JacksonUtils.pojo2Json((Object)((Object)event)));
            return;
        }
        String deviceMac = event.c();
        Channel channel = event.e();
        a.debug("handle PreConnectInfo event for v1 device {}", (Object)deviceMac);
        EcspMessage preConnectInfo = event.d();
        Integer serverGrpcPort = this.g.getGrpcPort();
        AddressDTO localServerRoute = com.tplink.smb.ecsp.server.e.e.a(channel, serverGrpcPort);
        if (this.a(deviceMac, preConnectInfo, channel)) {
            this.a(deviceMac, localServerRoute);
            this.a(preConnectInfo, localServerRoute);
        } else {
            a.info("handle v1 PreConnectInfo failed for {}, close channel {}, cause update adopt context error", (Object)deviceMac, (Object)channel);
            channel.close();
        }
    }

    private boolean a(String deviceMac, EcspMessage preConnectInfo, Channel adoptChannel) {
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.d);
        if (Objects.isNull(serverRouteDTO) || serverRouteDTO.getDeviceStatusValue() != DeviceNetStatus.ADOPTING_PENDING_PRE_ADOPT.getValue()) {
            a.info("v1 device {} server route not match, should close adopt server channel {}", (Object)deviceMac, (Object)adoptChannel);
            return false;
        }
        com.tplink.smb.ecsp.server.context.a oldContext = this.i.a(deviceMac);
        if (Objects.nonNull(oldContext) && !DeviceNetStatus.isDiscovering((DeviceNetStatus)oldContext.q())) {
            Channel oldUpgradeChannel;
            Channel oldManageChannel;
            a.debug("v1 device {} status is {}, close old channels, remain this adopt channel", (Object)deviceMac, (Object)oldContext.q());
            Channel oldAdoptChannel = oldContext.C();
            if (Objects.nonNull(oldAdoptChannel)) {
                oldAdoptChannel.close();
            }
            if (Objects.nonNull(oldManageChannel = oldContext.E())) {
                oldManageChannel.close();
            }
            if (Objects.nonNull(oldUpgradeChannel = oldContext.D())) {
                oldUpgradeChannel.close();
            }
        }
        if (Objects.isNull(oldContext = this.a(deviceMac, preConnectInfo, oldContext)) || !EcspVersion.isEcspVersion1((String)oldContext.p())) {
            a.info("v1 device {} context not match, should close adopt server channel {}", (Object)deviceMac, (Object)adoptChannel);
            return false;
        }
        return this.a(deviceMac, oldContext, adoptChannel);
    }

    private boolean a(String deviceMac, com.tplink.smb.ecsp.server.context.a oldContext, Channel adoptChannel) {
        return this.i.a(deviceMac, () -> {
            oldContext.a(DeviceNetStatus.ADOPTING_PRE_CONNECT);
            oldContext.a(System.currentTimeMillis());
            oldContext.d(this.g.getDeviceContextTimeout().getAdoptChannelTimeout());
            oldContext.a((Pair<InetSocketAddress, InetSocketAddress>)null);
            oldContext.d(adoptChannel);
            this.i.a(deviceMac, oldContext);
            a.debug("update v1 device {} status to ADOPTING_PRE_CONNECT", (Object)deviceMac);
            return true;
        }, () -> a.warn("failed to update v1 adopt preConnect DeviceContext of mac :{}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac)));
    }

    private com.tplink.smb.ecsp.server.context.a a(String deviceMac, EcspMessage preConnectInfo, com.tplink.smb.ecsp.server.context.a oldContext) {
        if (Objects.isNull(oldContext) || CollectionUtils.isEmpty(oldContext.t())) {
            OperationResponse response;
            a.debug("v1 device {} adopt info is null, going to get device adopt info from manager", (Object)deviceMac);
            try {
                response = (OperationResponse)this.j.getDeviceAdoptInfoAsync(new DeviceRequestDTO(deviceMac, preConnectInfo)).timeout(this.g.getGrpcTimeout(), TimeUnit.MILLISECONDS).blockingGet();
            }
            catch (Exception e2) {
                a.warn("get v1 device adopt info for {} error when handle new pre connect, exception: ", (Object)deviceMac, (Object)e2);
                return null;
            }
            if (Objects.nonNull(response) && response.isOk() && Objects.nonNull(response.getResult())) {
                a.debug("get v1 device adopt info for {} success, build ADOPTING_PRE_ADOPT context", (Object)deviceMac);
                DeviceAdoptInfoDTO deviceInfoDTO = (DeviceAdoptInfoDTO)response.getResult();
                com.tplink.smb.ecsp.server.context.a deviceContext = new com.tplink.smb.ecsp.server.context.a(DeviceType.resolve((String)preConnectInfo.getDeviceType()), deviceInfoDTO.getVersion(), DeviceNetStatus.ADOPTING_PRE_ADOPT, deviceMac, null);
                deviceContext.d(this.g.getDeviceContextTimeout().getAdoptChannelTimeout());
                deviceContext.a(deviceInfoDTO.getAdoptInfoList());
                deviceContext.c(deviceInfoDTO.getDestIp());
                deviceContext.a(deviceInfoDTO.getDestPort());
                deviceContext.b(deviceInfoDTO.getPreAdoptPort());
                deviceContext.c(deviceInfoDTO.getDestDiscPort());
                return deviceContext;
            }
            a.info("v1 device {} adopt info is null, can not auto adopt", (Object)deviceMac);
            return null;
        }
        a.debug("v1 device {} get AdoptInfo through old deviceContext", (Object)deviceMac);
        com.tplink.smb.ecsp.server.context.a deviceContext = new com.tplink.smb.ecsp.server.context.a(DeviceType.resolve((String)preConnectInfo.getDeviceType()), oldContext.p(), DeviceNetStatus.ADOPTING_PRE_ADOPT, deviceMac, null);
        deviceContext.d(this.g.getDeviceContextTimeout().getAdoptChannelTimeout());
        deviceContext.a(oldContext.t());
        deviceContext.c(oldContext.l());
        deviceContext.a(oldContext.m());
        deviceContext.b(oldContext.n());
        deviceContext.c(oldContext.o());
        return deviceContext;
    }

    private void a(String deviceMac, AddressDTO localServerRoute) {
        ServerRouteCacheUtils.doWithTryLock((LockService)this.f, (String)deviceMac, (int)this.g.getTryLockTimeout(), () -> {
            ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.d);
            if (Objects.nonNull(serverRouteDTO)) {
                com.tplink.smb.ecsp.server.e.e.a(deviceMac, localServerRoute, serverRouteDTO.getAdoptServerRoute(), serverRouteDTO.getManageServerRoute(), this.h, this.e, this.g.getGrpcTimeout());
            }
            serverRouteDTO = new ServerRouteDTO();
            serverRouteDTO.setAdoptServerRoute(localServerRoute);
            ServerRouteCacheUtils.setServerRouteCache((String)deviceMac, (ServerRouteDTO)serverRouteDTO, (long)this.g.getAdoptingServerRouteExpire(), (CacheService)this.d);
            return null;
        });
    }

    private void a(EcspMessage ecspMessage, AddressDTO localServerRoute) {
        Boolean sendWithKey = this.g.isEnableSendEventWithKey();
        String topicPrefix = this.g.getTopicPrefix();
        String eventTopic = com.tplink.smb.ecsp.server.e.a.a(ServerType.ADOPT, ecspMessage, MessageType.PRE_CONNECT_INFO, topicPrefix);
        com.tplink.smb.ecsp.server.e.a.a(this.c, ecspMessage, null, localServerRoute, eventTopic, sendWithKey);
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((a)((Object)object));
    }
}

