/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.server;

import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.dmp.server.d;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.common.exception.TransException;
import com.tplink.smb.ecsp.common.monitor.MonitorHelper;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.ecsp.common.util.ExecutorUtils;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.encrypt.RsaCipher;
import com.tplink.smb.ecsp.message.cache.ServerRouteCacheUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.ecsp.server.TransporterStarter;
import com.tplink.smb.ecsp.server.c.c;
import com.tplink.smb.ecsp.server.c.j;
import com.tplink.smb.ecsp.server.c.l;
import com.tplink.smb.ecsp.server.c.p;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.server.context.a;
import com.tplink.smb.ecsp.server.context.b;
import com.tplink.smb.ecsp.server.e.e;
import com.tplink.smb.ecsp.server.e.f;
import com.tplink.smb.ecsp.server.k;
import com.tplink.smb.ecsp.server.m;
import com.tplink.smb.ecsp.server.n;
import com.tplink.smb.ecsp.transport.api.Transporters;
import com.tplink.smb.ecsp.transport.api.monitor.DailyMonitor;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.Scheduled;

public class EcspTransporterStarter
implements TransporterStarter,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(EcspTransporterStarter.class);
    private static String DEBUG_DEVICE_INFORM_ENABLE = "debug.device.inform.enable";
    @Resource
    private Set<m> serverCenters;
    @Resource
    private Transporters transporters;
    @Autowired(required=false)
    private MeterRegistry meterRegistry;
    @Resource
    private n serverExecutorService;
    @Resource
    k monitorExecutorService;
    @Resource
    private EcspServerProperties ecspServerProperties;
    @Resource
    private b deviceContextHolder;
    @Resource
    private com.tplink.smb.dmp.server.b.c monitorContextHolder;
    @Autowired(required=false)
    @Qualifier(value="deviceGatewayServiceGrpcClient")
    private com.tplink.smb.ecsp.a.a.b deviceGatewayService;
    @Resource
    private CacheService cacheService;
    private final ScheduledExecutorService metricExecutorService = Executors.newSingleThreadScheduledExecutor();
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    @PostConstruct
    public void init() {
        RsaCipher.initialize();
        System.setProperty(DEBUG_DEVICE_INFORM_ENABLE, String.valueOf(this.ecspServerProperties.isEnableLogInform()));
        if (this.ecspServerProperties.isEnableMonitor()) {
            MonitorHelper.loadMeterRegistry((MeterRegistry)this.meterRegistry);
            this.metricExecutorService.scheduleWithFixedDelay(() -> {
                this.gaugeNettyUsedMemory();
                this.deviceContextHolder.a();
            }, 30L, this.ecspServerProperties.getMonitorPeriod(), TimeUnit.SECONDS);
            this.monitorExecutorService.a(() -> {
                try {
                    long currentTime = System.currentTimeMillis();
                    Iterator iterator = DailyMonitor.deviceBlackList.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (currentTime - (Long)entry.getValue() <= DailyMonitor.TWENTY_FOUR_HOURS) continue;
                        String mac = (String)entry.getKey();
                        log.info("Device {} removed from blacklist", (Object)OmadaPIIUtils.encryptWithCache((String)mac));
                        iterator.remove();
                        DailyMonitor.deviceLastConnectTime.remove(mac);
                    }
                }
                catch (Exception e2) {
                    log.error("Blacklist cleanup failed", (Throwable)e2);
                }
            }, this.ecspServerProperties.getDeviceBlackListCheckPeriod(), this.ecspServerProperties.getDeviceBlackListCheckPeriod(), TimeUnit.HOURS);
            this.monitorExecutorService.a(() -> {
                try {
                    DailyMonitor.deviceDailyConnectGaugeMap.clear();
                    log.info("Clear device daily connections gauge map.");
                }
                catch (Exception e2) {
                    log.error("Reset task failed", (Throwable)e2);
                }
            }, this.ecspServerProperties.getDailyMonitorPeriod(), this.ecspServerProperties.getDailyMonitorPeriod(), TimeUnit.HOURS);
        }
    }

    @Scheduled(cron="20 8 * * * ?")
    public void logDeviceStat() {
        if (this.ecspServerProperties.isEnableMonitor()) {
            this.deviceContextHolder.b();
        }
    }

    private void gaugeNettyUsedMemory() {
        long heapMemory = this.transporters.usedHeapMemory() / 1024L / 1024L;
        long directMemory = this.transporters.usedDirectMemory() / 1024L / 1024L;
        log.debug("netty used heap memory: {} MB, used direct memory: {} MB", (Object)heapMemory, (Object)directMemory);
        ServerMonitor.getNettyHeapMemoryGauge().getAndSet(heapMemory);
        ServerMonitor.getNettyDirectMemoryGauge().getAndSet(directMemory);
    }

    @Override
    public void start(List<URL> urls, Map<String, Map<String, PIIMaskStrategy>> maskMessageMap) {
        if (this.ecspServerProperties.isEnablePortCheck()) {
            urls.forEach(url -> this.checkPort(url.getPort(), url.getProtocol()));
        }
        this.transporters.setMaskMessageMap(maskMessageMap);
        Map<ServerType, List<URL>> serverTypeListMap = urls.stream().collect(Collectors.groupingBy(url -> ServerType.fromString((String)url.getParameter("server-type"))));
        ArrayList<URL> v1ManageServerUrls = new ArrayList<URL>();
        ArrayList<URL> v2ManageServerUrls = new ArrayList<URL>();
        ArrayList<URL> rttyUrls = new ArrayList<URL>();
        List<URL> monitorUrls = serverTypeListMap.getOrDefault(ServerType.MONITOR, Collections.emptyList());
        this.sortURL(serverTypeListMap, v1ManageServerUrls, v2ManageServerUrls, rttyUrls);
        for (m serverCenter : this.serverCenters) {
            if (serverCenter instanceof c) {
                serverCenter.a(serverTypeListMap.get(ServerType.DISCOVERY));
                continue;
            }
            if (serverCenter instanceof com.tplink.smb.ecsp.server.c.f) {
                serverCenter.a(v1ManageServerUrls);
                continue;
            }
            if (serverCenter instanceof j) {
                serverCenter.a(serverTypeListMap.get(ServerType.UPGRADE));
                continue;
            }
            if (serverCenter instanceof l) {
                serverCenter.a(v2ManageServerUrls);
                continue;
            }
            if (serverCenter instanceof com.tplink.smb.rtty.server.b.a) {
                serverCenter.a(rttyUrls);
                continue;
            }
            if (!(serverCenter instanceof d)) continue;
            serverCenter.a(monitorUrls);
        }
    }

    private void sortURL(Map<ServerType, List<URL>> serverTypeListMap, List<URL> v1ManageServerUrls, List<URL> v2ManageServerUrls, List<URL> rttyUrls) {
        if (CollectionUtils.isNotEmpty((Collection)serverTypeListMap.get(ServerType.ADOPT))) {
            v1ManageServerUrls.addAll((Collection<URL>)serverTypeListMap.get(ServerType.ADOPT));
        }
        if (CollectionUtils.isNotEmpty((Collection)serverTypeListMap.get(ServerType.MANAGE))) {
            for (URL url : serverTypeListMap.get(ServerType.MANAGE)) {
                String ecspVer = url.getParameter("ecsp-version");
                if (EcspVersion.isEcspVersion2((String)ecspVer) || EcspVersion.isEcspVersion3((String)ecspVer)) {
                    v2ManageServerUrls.add(url);
                    continue;
                }
                v1ManageServerUrls.add(url);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)serverTypeListMap.get(ServerType.TRANSFER))) {
            v2ManageServerUrls.addAll((Collection<URL>)serverTypeListMap.get(ServerType.TRANSFER));
        }
        if (CollectionUtils.isNotEmpty((Collection)serverTypeListMap.get(ServerType.RTTY))) {
            rttyUrls.addAll((Collection<URL>)serverTypeListMap.get(ServerType.RTTY));
        }
    }

    @Override
    public void close(List<URL> urls) {
        Set ports = urls.stream().map(URL::getPort).collect(Collectors.toSet());
        this.serverCenters.forEach(serverCenter -> ports.forEach(serverCenter::a));
    }

    @Override
    public void listenDevice(Set<DeviceType> managedDeviceType) {
        this.deviceContextHolder.a(managedDeviceType);
    }

    @Override
    public Map<Integer, Integer> getServerConnections() {
        HashMap<Integer, Integer> serverConnections = new HashMap<Integer, Integer>();
        for (m serverCenter : this.serverCenters) {
            serverCenter.a().values().forEach(server -> serverConnections.put(server.getLocalAddress().getPort(), server.getConnections()));
        }
        return serverConnections;
    }

    @Override
    public void kickAllDevices(int kickBatchNum, int kickIntervalMs, int restTimeMs) {
        for (m serverCenter : this.serverCenters) {
            serverCenter.a().values().forEach(server -> server.kickChannels(kickBatchNum, kickIntervalMs, restTimeMs));
        }
    }

    @Override
    public void kickSomeDevices(boolean deviceKicking, int kickNum, int kickBatchNum, int kickIntervalMs, int restTimeMs) {
        this.deviceContextHolder.a(deviceKicking, kickNum, kickBatchNum, kickIntervalMs, restTimeMs);
        this.monitorContextHolder.a(deviceKicking, kickNum, kickBatchNum, kickIntervalMs, restTimeMs);
    }

    @Override
    public void kickDevice(String deviceMac) {
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.cacheService);
        if (Objects.nonNull(serverRouteDTO)) {
            e.a(deviceMac, null, serverRouteDTO.getAdoptServerRoute(), serverRouteDTO.getManageServerRoute(), null, this.deviceGatewayService, this.ecspServerProperties.getGrpcTimeout());
        }
    }

    @Override
    public void setEnableHandleNewChannel(boolean enableHandleNewChannel) {
        this.ecspServerProperties.setEnableHandleNewChannel(enableHandleNewChannel);
    }

    @Override
    public String getDeviceContext(String deviceMac) {
        ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache((String)deviceMac, (CacheService)this.cacheService);
        if (Objects.nonNull(serverRouteDTO)) {
            return e.a(deviceMac, serverRouteDTO.getManageServerRoute(), this.deviceGatewayService, this.ecspServerProperties.getGrpcTimeout());
        }
        a deviceContext = this.deviceContextHolder.a(deviceMac);
        return deviceContext == null ? null : deviceContext.toString();
    }

    @Override
    public void setAdoptPermitsPerSecond(double permitsPerSecond) {
        c.a(permitsPerSecond);
    }

    @Override
    public boolean enableDeviceLog(String deviceMac) {
        return p.a(deviceMac, true);
    }

    @Override
    public boolean disableDeviceLog() {
        return p.a(null, false);
    }

    @Override
    public void destroy() {
        log.info("going to shutdown ecsp servers & executors");
        this.serverCenters.forEach(m::f);
        this.serverExecutorService.b();
        this.monitorExecutorService.b();
        ExecutorUtils.gracefulShutdown((Executor)this.metricExecutorService, (int)0);
        OmadaPIIUtils.clearCache();
    }

    private void checkPort(int port, String type) {
        try {
            boolean portOccupied = f.a(port, type);
            if (portOccupied) {
                throw new TransException(5000, "port " + port + " is already in use.");
            }
        }
        catch (IOException e2) {
            throw new TransException(4000, e2.getMessage(), (Throwable)e2);
        }
    }
}

