/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.dmp.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.dmp.dto.DmpParamDTO;
import com.tplink.smb.dmp.server.a.c;
import com.tplink.smb.dmp.server.b;
import com.tplink.smb.dmp.server.b.b;
import com.tplink.smb.dmp.server.c.a;
import com.tplink.smb.dmp.server.h;
import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.util.MacUtils;
import com.tplink.smb.ecsp.common.util.TimeUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteCacheUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.packet.EcspPacket;
import com.tplink.smb.ecsp.server.config.EcspServerProperties;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerAdapter;
import com.tplink.smb.omada.proto.device.monitor.MonitorMessageDTO;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class e
extends ChannelHandlerAdapter
implements com.tplink.smb.a.a.c {
    private static final Logger a = LoggerFactory.getLogger(e.class);
    private final com.tplink.smb.dmp.server.b.c b;
    private final com.tplink.smb.ecsp.proxy.service.a c;
    private final a d;
    private final ExecutorService e;
    private final b f;
    private final CacheService g;
    private final LockService h;
    private final EcspServerProperties i;
    private final c j = com.tplink.smb.dmp.server.a.c.a();
    private final com.tplink.smb.dmp.server.a.b k = com.tplink.smb.dmp.server.a.b.a();

    public e(com.tplink.smb.dmp.server.b.c monitorContextHolder, com.tplink.smb.ecsp.proxy.service.a deviceMonitorInternalService, a monitorMessageDispatcher, ExecutorService monitorMessageHandlerExecutor, b dmpParamCache, CacheService cacheService, LockService lockService, EcspServerProperties ecspServerProperties) {
        this.b = monitorContextHolder;
        this.c = deviceMonitorInternalService;
        this.d = monitorMessageDispatcher;
        this.e = monitorMessageHandlerExecutor;
        this.f = dmpParamCache;
        this.g = cacheService;
        this.h = lockService;
        this.i = ecspServerProperties;
    }

    static boolean a(@Nonnull MonitorMessageDTO message) {
        return !message.getHeader().hasMac() || !message.getHeader().hasToken() || !message.getHeader().hasPath() || !StringUtils.hasText((String)message.getHeader().getPath()) || !message.getHeader().hasVersion() || !StringUtils.hasText((String)message.getHeader().getVersion());
    }

    @Override
    public byte a() {
        return 0;
    }

    public void connected(Channel channel) throws RemotingException {
        if (!this.i.isEnableHandleNewChannel()) {
            channel.close();
            ServerMonitor.incRefuseDeviceMonitorConnectCounter();
            a.debug("Refuse to handle new channel {}", (Object)channel);
            return;
        }
        this.b.a(channel, com.tplink.smb.dmp.server.b.b.a(channel));
        a.trace("Monitor server new channel {} connected.", (Object)channel);
        ServerMonitor.getMonitorConnectionsGauge().incrementAndGet();
    }

    public void disconnected(Channel channel) {
        ServerMonitor.getMonitorConnectionsGauge().decrementAndGet();
        if (channel == null) {
            return;
        }
        a.info("Handling disconnect channel {}", (Object)channel);
        com.tplink.smb.dmp.server.b.b monitorContext = this.b.a(channel);
        if (monitorContext == null) {
            return;
        }
        this.b.b(channel);
        String mac = monitorContext.c();
        if (mac == null) {
            return;
        }
        this.a(channel, mac);
        a.trace("Monitor server channel {} disconnected.", (Object)channel);
    }

    public void received(Channel channel, Object message) throws RemotingException {
        if (a.isTraceEnabled()) {
            a.trace("MONITOR: Received message.");
        }
        ServerMonitor.incIncomingMonitorTcpCounter();
        this.a(channel, message);
    }

    public void caught(Channel channel, Throwable exception) {
        a.warn("MONITOR: Channel {} caught exception.", (Object)channel, (Object)exception);
    }

    @VisibleForTesting
    void a(Channel channel, Object message) {
        com.tplink.smb.dmp.server.b.b monitorContext = this.b.a(channel, () -> com.tplink.smb.dmp.server.b.b.a(channel));
        if (monitorContext.e() != channel) {
            a.error("MONITOR: Mismatched message received channel {} and MonitorContext channel. context: {}", (Object)channel, (Object)monitorContext);
            return;
        }
        Assert.isInstanceOf(EcspPacket.class, (Object)message, (String)"MONITOR: Invalid TCP message type, should be EcspPacket!");
        MonitorMessageDTO dmpMessage = this.k.a((EcspPacket)message);
        if (dmpMessage == null) {
            channel.close();
            a.info("MONITOR: Received invalid message, disconnecting channel {}", (Object)channel);
            ServerMonitor.incMonitorInvalidMessageCounter();
            return;
        }
        if (a.isTraceEnabled()) {
            a.trace("MONITOR: Parsed Message: {}", (Object)dmpMessage);
        } else if (a.isDebugEnabled()) {
            a.debug("MONITOR: Parsed Message Header: {}", (Object)dmpMessage.getHeader());
        }
        this.e.execute(() -> this.a(monitorContext, dmpMessage));
    }

    @VisibleForTesting
    void a(@Nonnull com.tplink.smb.dmp.server.b.b context, @Nonnull MonitorMessageDTO receivedMessage) {
        Channel channel = context.e();
        String deviceMac = MacUtils.formatDefault((ByteString)receivedMessage.getHeader().getMac());
        a.debug("MONITOR: Handling receivedMessage from {}", (Object)deviceMac);
        h verifyResult = this.c(channel, receivedMessage);
        context = Objects.requireNonNull(this.b.a(channel), "Monitor Channel context should not be null." + channel);
        ServerMonitor.incMonitorVerifyResultCounter((String)verifyResult.name());
        switch (verifyResult) {
            case a: {
                this.b(context, receivedMessage);
                this.b(channel, receivedMessage);
                this.a(context);
                return;
            }
            case b: {
                a.info("MONITOR: Invalid connection, disconnecting {}", (Object)channel);
                channel.close();
                return;
            }
            case d: {
                a.info("MONITOR: Sending invalid token resp {}", (Object)channel);
                this.a(channel, receivedMessage);
                return;
            }
            case g: {
                a.info("MONITOR: Lock failed, channel {}, message ignored", (Object)channel);
                return;
            }
        }
        a.warn("MONITOR: Unhandled channel verification result: {}, channel: {}, message ignored", (Object)verifyResult, (Object)channel);
    }

    void a(com.tplink.smb.dmp.server.b.b context) {
        if (TimeUtils.isTimeout((long)context.l(), (long)this.i.getUpdateServerRoutePeriod())) {
            String deviceMac = context.c();
            this.e.execute(() -> {
                try {
                    ServerRouteCacheUtils.updateManageServerRouteExpire((String)deviceMac, (LockService)this.h, (CacheService)this.g, (int)this.i.getTryLockTimeout(), (long)this.i.getConnectedServerRouteExpire());
                    this.b.a(context.e(), context.b().b(System.currentTimeMillis()).a());
                }
                catch (Exception e2) {
                    a.warn("Failed to Extend Route cache: {}", (Object)context, (Object)e2);
                }
            });
        }
    }

    @VisibleForTesting
    void b(com.tplink.smb.dmp.server.b.b context, MonitorMessageDTO receivedMessage) {
        MonitorMessageDTO message = this.j.a(context, receivedMessage);
        a.trace("MONITOR: Dispatch message: {}", (Object)message);
        this.d.a(message);
    }

    @VisibleForTesting
    void a(@Nonnull Channel channel, @Nonnull MonitorMessageDTO receivedMessage) {
        MonitorMessageDTO invalidTokenResp = this.j.a(receivedMessage);
        a.debug("MONITOR: Sending {}", (Object)invalidTokenResp);
        EcspPacket encode = this.k.a(invalidTokenResp);
        channel.send((Object)encode).subscribe(res -> {
            a.debug("MONITOR: Send INVALID_TOKEN response result: {}", res);
            channel.close();
        }, throwable -> {
            a.warn("MONITOR: Failed to send INVALID_TOKEN response", throwable);
            channel.close();
        });
    }

    @VisibleForTesting
    void b(@Nonnull Channel channel, @Nonnull MonitorMessageDTO message) {
        if (!message.getHeader().getNeedReply()) {
            return;
        }
        MonitorMessageDTO response = this.j.b(message);
        a.debug("MONITOR: Sending {}", (Object)response);
        EcspPacket ecspPacket = this.k.a(response);
        channel.send((Object)ecspPacket).subscribe(res -> a.debug("MONITOR: Send OK response result: {}", res), throwable -> a.warn("MONITOR: Failed to send OK response", throwable));
    }

    @VisibleForTesting
    h c(@Nonnull Channel channel, @Nonnull MonitorMessageDTO message) {
        return this.b.a(channel, () -> {
            com.tplink.smb.dmp.server.b.b monitorContext = this.b.a(channel, () -> com.tplink.smb.dmp.server.b.b.a(channel));
            return switch (monitorContext.d()) {
                case b.a.b -> com.tplink.smb.dmp.server.h.a;
                case b.a.a -> this.d(channel, message);
                default -> throw new IllegalStateException("Unexpected MonitorContext Status: " + monitorContext.d());
            };
        }, () -> com.tplink.smb.dmp.server.h.g);
    }

    @VisibleForTesting
    h d(@Nonnull Channel channel, @Nonnull MonitorMessageDTO message) {
        if (com.tplink.smb.dmp.server.e.a(message)) {
            a.info("MONITOR: Message header is missing a lot of required parameters: {}, channel: {}", (Object)message.getHeader(), (Object)channel);
            return com.tplink.smb.dmp.server.h.c;
        }
        String mac = MacUtils.formatDefault((ByteString)message.getHeader().getMac());
        long headerToken = message.getHeader().getToken();
        String path = message.getHeader().getPath();
        String version = message.getHeader().getVersion();
        return (h)((Object)ServerRouteCacheUtils.tryLock((LockService)this.h, (String)mac, (int)this.i.getTryLockTimeout(), () -> {
            DmpParamDTO dmpParam;
            ServerRouteDTO serverRoutes;
            com.tplink.smb.dmp.server.b.b channelContext = this.b.a(mac);
            if (channelContext != null && channelContext.e() != channel) {
                a.info("MONITOR: Duplicated connection, message header: {}, already exists another channel at this server: {}, closing old channel.", (Object)message.getHeader(), (Object)channelContext.e());
                try {
                    channelContext.e().close();
                }
                catch (Exception e2) {
                    a.debug("MONITOR: Call channel close with exception {}", (Object)channelContext.e(), (Object)e2);
                }
            }
            if ((serverRoutes = ServerRouteCacheUtils.getServerRouteCache((String)mac, (CacheService)this.g)) == null || serverRoutes.getManageServerRoute() == null) {
                a.warn("MONITOR: Management ServerRoute Missing, message header: {}, Management Server Route missing: {}.", (Object)message.getHeader(), (Object)serverRoutes);
                return com.tplink.smb.dmp.server.h.f;
            }
            Integer serverGrpcPort = this.i.getGrpcPort();
            AddressDTO thisServer = com.tplink.smb.ecsp.server.e.e.a(channel, serverGrpcPort);
            if (serverRoutes.getMonitorServerRoute() != null && !Objects.equals(serverRoutes.getMonitorServerRoute(), thisServer)) {
                a.info("MONITOR: Duplicated connection, message header: {}, already exist another channel at server {}, ignore and change to this server", (Object)message.getHeader(), (Object)serverRoutes.getMonitorServerRoute());
            }
            if ((dmpParam = this.a(path, mac)) == null || !dmpParam.isValid()) {
                a.warn("MONITOR: Unexpected DmpParam: {}, channel {}.", (Object)dmpParam, (Object)channel);
                return com.tplink.smb.dmp.server.h.b;
            }
            long token = dmpParam.getToken();
            if (token != headerToken) {
                a.warn("MONITOR: Invalid Token from device: {}, expected:{}", (Object)headerToken, (Object)token);
                return com.tplink.smb.dmp.server.h.d;
            }
            serverRoutes.setMonitorServerRoute(thisServer);
            ServerRouteCacheUtils.setServerRouteCache((String)mac, (ServerRouteDTO)serverRoutes, (long)this.i.getConnectedServerRouteExpire(), (CacheService)this.g);
            com.tplink.smb.dmp.server.b.b newContext = com.tplink.smb.dmp.server.b.b.a().a(mac).a(b.a.b).a(channel).b(dmpParam.getDeviceCompressMethod()).c(version).a((Long)token).d(message.getHeader().getPath()).e(Optional.ofNullable(dmpParam.getDeviceCodec()).orElse("protobuf2")).a();
            this.b.a(channel, newContext);
            return com.tplink.smb.dmp.server.h.a;
        }, () -> com.tplink.smb.dmp.server.h.g));
    }

    @Nullable
    DmpParamDTO a(String path, String mac) {
        return this.f.a(path, mac).orElseGet(() -> {
            OperationResponse dmpParamResp = this.c.a(path, mac);
            if (dmpParamResp != null && dmpParamResp.isOk() && dmpParamResp.getResult() != null) {
                return (DmpParamDTO)dmpParamResp.getResult();
            }
            return null;
        });
    }

    void a(@Nonnull Channel channel, @Nonnull String mac) {
        ServerRouteCacheUtils.doWithTryLock((LockService)this.h, (String)mac, (int)this.i.getTryLockTimeout(), () -> {
            ServerRouteDTO routeDTO = ServerRouteCacheUtils.getServerRouteCache((String)mac, (CacheService)this.g);
            if (routeDTO == null || routeDTO.getMonitorServerRoute() == null) {
                return null;
            }
            AddressDTO thisServer = com.tplink.smb.ecsp.server.e.e.a(channel, this.i.getGrpcPort());
            if (Objects.equals(thisServer, routeDTO.getMonitorServerRoute())) {
                a.debug("Removed MonitorServer RouteAddress {} from serverRoute {}", (Object)thisServer, (Object)routeDTO);
                routeDTO.setMonitorServerRoute(null);
            }
            ServerRouteCacheUtils.setServerRouteCache((String)mac, (ServerRouteDTO)routeDTO, (CacheService)this.g);
            return null;
        });
    }
}

