/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.dmp.server.a;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.tplink.smb.dmp.proto2.ContentType;
import com.tplink.smb.dmp.proto2.compress.CompressUtils;
import com.tplink.smb.dmp.proto2.compress.Compression;
import com.tplink.smb.dmp.server.b.b;
import com.tplink.smb.omada.proto.device.monitor.MonitorMessageDTO;
import com.tplink.smb.omada.proto.device.monitor.MonitorMessageHeaderDTO;
import com.tplink.smb.omada.proto.device.monitor.MsgTypeEnum;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class c {
    private static final c a = new c();
    private static final Logger b = LoggerFactory.getLogger(c.class);

    private c() {
    }

    public static c a() {
        return a;
    }

    @VisibleForTesting
    static ContentType a(b context) {
        return new ContentType(context.f(), context.j());
    }

    public MonitorMessageDTO a(@Nonnull MonitorMessageDTO received) {
        return MonitorMessageDTO.newBuilder().setHeader(MonitorMessageHeaderDTO.newBuilder().setErrorCode(1001).setSeq(received.getHeader().getSeq()).setVersion("1.0").setMsgType(MsgTypeEnum.MSG_EMPTY).build()).build();
    }

    public MonitorMessageDTO b(@Nonnull MonitorMessageDTO received) {
        MonitorMessageHeaderDTO header = MonitorMessageHeaderDTO.newBuilder().setErrorCode(0).setSeq(received.getHeader().getSeq()).setMsgType(MsgTypeEnum.MSG_EMPTY).build();
        return MonitorMessageDTO.newBuilder().setHeader(header).build();
    }

    public MonitorMessageDTO a(@Nonnull b context, @Nonnull MonitorMessageDTO received) {
        MonitorMessageHeaderDTO monitorMessageHeaderDTO = received.getHeader();
        ContentType contentType = ContentType.resolve((String)monitorMessageHeaderDTO.getContentType(), () -> c.a(context));
        b.debug("MonitorMessage: Rebuilding, resolved content type is {}", (Object)contentType);
        MonitorMessageDTO plainData = this.a(contentType, received);
        MonitorMessageHeaderDTO.Builder headerBuilder = monitorMessageHeaderDTO.toBuilder();
        if (!monitorMessageHeaderDTO.hasVersion()) {
            headerBuilder.setVersion(Objects.requireNonNull(context.g(), "MonitorContext#version should not be null."));
        }
        if (!monitorMessageHeaderDTO.hasToken()) {
            headerBuilder.setToken(Objects.requireNonNull(context.h(), "MonitorContext#token should not be null.").longValue());
        }
        if (!monitorMessageHeaderDTO.hasPath()) {
            headerBuilder.setPath(Objects.requireNonNull(context.i(), "MonitorContext#path should not be null."));
        }
        headerBuilder.setContentType("plain/" + contentType.messageCodec());
        MonitorMessageDTO newMessage = plainData.toBuilder().setHeader(headerBuilder).build();
        b.trace("MonitorMessage: Rebuilt message is {}", (Object)newMessage);
        return newMessage;
    }

    @VisibleForTesting
    MonitorMessageDTO a(ContentType contentType, MonitorMessageDTO received) {
        if (!contentType.isCompressed()) {
            return received;
        }
        Assert.notNull((Object)contentType.compressMethod(), (String)"CompressMethod should not be null.");
        Compression compressionFunc = (Compression)CompressUtils.COMPRESS_MAP.get((Object)contentType.compressMethod());
        if (compressionFunc == null) {
            throw new IllegalArgumentException("Unsupported compressMethod: " + contentType.compressMethod());
        }
        ByteString originData = compressionFunc.decompress(received.getData());
        return received.toBuilder().setData(originData).build();
    }
}

