/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.central.components.common.gridquery;

import com.google.common.collect.Lists;
import com.tplink.smb.omada.central.components.common.a.a;
import com.tplink.smb.omada.central.components.common.a.b;
import com.tplink.smb.omada.central.components.common.gridquery.OpenApiQueryDataVO;
import com.tplink.smb.omada.central.components.common.gridquery.d;
import com.tplink.smb.omada.central.components.common.gridquery.g;
import jakarta.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.CollectionUtils;

public class QueryDataVO {
    private int currentPage = 0;
    private int currentPageSize = 0;
    private LinkedHashMap<String, String> sorts;
    private String searchKey;
    private Map<String, Object> filters;
    @Nullable
    private String searchField;
    @Nullable
    private Map<String, String> multiSearchMap;

    public static QueryDataVO buildByOpenApiVO(OpenApiQueryDataVO openApiQueryDataVO) {
        QueryDataVO queryDataVO = new QueryDataVO();
        if (openApiQueryDataVO == null) {
            return queryDataVO;
        }
        queryDataVO.setCurrentPage(openApiQueryDataVO.getPage());
        queryDataVO.setCurrentPageSize(openApiQueryDataVO.getPageSize());
        queryDataVO.setFilters(openApiQueryDataVO.getFilters());
        queryDataVO.setSorts(openApiQueryDataVO.getSorts());
        queryDataVO.setSearchKey(openApiQueryDataVO.getSearchKey());
        queryDataVO.setSearchField(openApiQueryDataVO.getSearchField());
        return queryDataVO;
    }

    public static d transQueryDataWithSort(QueryDataVO queryDataVO, String sortMapKey) {
        return QueryDataVO.transQueryDataWithSortAndFilter(queryDataVO, sortMapKey, null);
    }

    public static d transQueryDataWithSortAndFilter(QueryDataVO queryDataVO, String sortMapKey, String filterMapKey) {
        d queryData = new d();
        queryData.a(queryDataVO.getCurrentPage() <= 0 ? 1 : queryDataVO.getCurrentPage());
        queryData.b(queryDataVO.getCurrentPageSize() <= 0 ? 10 : queryDataVO.getCurrentPageSize());
        queryData.b(queryDataVO.getSearchKey());
        queryData.b(queryDataVO.getMultiSearchMap());
        if (!StringUtils.isBlank((CharSequence)queryDataVO.getSearchField())) {
            List<String> searchFields = Lists.newArrayList((Object[])queryDataVO.getSearchField().split(",")).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            queryData.a(searchFields.isEmpty() ? null : searchFields);
        }
        if (sortMapKey == null) {
            return queryData;
        }
        if (!CollectionUtils.isEmpty(queryDataVO.getSorts())) {
            Map<String, String> sortMap = b.a(sortMapKey);
            queryDataVO.getSorts().forEach((key, direction) -> {
                if (sortMap.get(key) != null) {
                    queryData.a(new g((String)sortMap.get(key), (String)direction));
                }
            });
        }
        if (filterMapKey == null) {
            return queryData;
        }
        if (!CollectionUtils.isEmpty(queryDataVO.getFilters())) {
            Map<String, a.a> filterMap = a.a(filterMapKey);
            queryDataVO.getFilters().forEach((key, value) -> {
                a.a item = (a.a)filterMap.get(key);
                if (item != null) {
                    switch (item.b()) {
                        case b: {
                            Number number = NumberUtils.createNumber((String)value.toString());
                            queryData.a(item.a(), number);
                            break;
                        }
                        case c: {
                            queryData.a(item.a(), Boolean.valueOf(value.toString()));
                            break;
                        }
                        default: {
                            queryData.a(item.a(), value.toString());
                        }
                    }
                }
            });
        }
        return queryData;
    }

    public boolean noNeedPagingQuery() {
        return this.currentPage == 0 && this.currentPageSize == 0;
    }

    @Nullable
    public String getSearchField() {
        return this.searchField;
    }

    public void setSearchField(@Nullable String searchField) {
        this.searchField = searchField;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage <= 0) {
            this.currentPage = 1;
            return;
        }
        this.currentPage = currentPage;
    }

    public LinkedHashMap<String, String> getSorts() {
        return this.sorts;
    }

    public void setSorts(LinkedHashMap<String, String> sorts) {
        this.sorts = sorts;
    }

    public int getCurrentPageSize() {
        return this.currentPageSize;
    }

    public void setCurrentPageSize(int currentPageSize) {
        if (currentPageSize <= 0) {
            this.currentPageSize = 10;
            return;
        }
        this.currentPageSize = currentPageSize;
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public Object getFilterValue(String filterKey) {
        if (Objects.isNull(filterKey)) {
            return null;
        }
        return this.filters.get(filterKey);
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    public Map<String, String> getMultiSearchMap() {
        return this.multiSearchMap;
    }

    public void setMultiSearchMap(Map<String, String> multiSearchMap) {
        this.multiSearchMap = multiSearchMap;
    }

    public String toString() {
        return "QueryDataVO(currentPage=" + this.getCurrentPage() + ", currentPageSize=" + this.getCurrentPageSize() + ", sorts=" + this.getSorts() + ", searchKey=" + this.getSearchKey() + ", filters=" + this.getFilters() + ", searchField=" + this.getSearchField() + ", multiSearchMap=" + this.getMultiSearchMap() + ")";
    }
}

