/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.central.components.common.gridquery;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.validator.constraints.Range;

public class OpenApiQueryDataVO {
    @NotNull(message="page should not be null.")
    @Range(min=1L, message="page should not be less than 1.")
    @Schema(name="page", description="Start from 1.")
    private @NotNull(message="page should not be null.") @Range(min=1L, message="page should not be less than 1.") Integer page;
    @NotNull(message="pageSize should not be null.")
    @Range(min=1L, max=100L, message="pageSize should between 1 and 100.")
    @Schema(name="pageSize", description="It should be within the range of 1\u2013100.")
    private @NotNull(message="pageSize should not be null.") @Range(min=1L, max=100L, message="pageSize should between 1 and 100.") Integer pageSize;
    private LinkedHashMap<String, String> sorts;
    private String searchKey;
    private Map<String, Object> filters;
    @Nullable
    private String searchField;

    public boolean noNeedPagingQuery() {
        return this.page == 0 && this.pageSize == 0;
    }

    @Nullable
    public String getSearchField() {
        return this.searchField;
    }

    public void setSearchField(@Nullable String searchField) {
        this.searchField = searchField;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public LinkedHashMap<String, String> getSorts() {
        return this.sorts;
    }

    public void setSorts(LinkedHashMap<String, String> sorts) {
        this.sorts = sorts;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }
}

