/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.central.components.common.dto;

import com.tplink.smb.omada.central.components.common.dto.LogDTO;
import com.tplink.smb.omada.central.components.common.f.a;
import com.tplink.smb.omada.central.components.common.f.w;
import com.tplink.smb.omada.dispatcher.common.util.StringUtils;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CentralLogDTO {
    private static final Logger log = LoggerFactory.getLogger(CentralLogDTO.class);
    private String mspId;
    private String centralId;
    private String siteId;
    private String logKey;
    private String[] params;
    private Map<String, String> paramMap;
    private Long time;
    private String content;
    private String deviceType;
    private Map<String, String> macNameMap;
    @Nullable
    private String deviceModel;
    @Nullable
    private String deviceModelVersion;

    private CentralLogDTO(String centralId, String siteId, a centralLogKeyEnum, String[] params, Long time, String content, Map<String, String> macNameMap, String deviceType) {
        this.centralId = centralId;
        this.siteId = siteId;
        this.logKey = centralLogKeyEnum.name();
        this.params = params;
        this.time = Optional.ofNullable(time).orElse(System.currentTimeMillis());
        this.content = content;
        this.macNameMap = macNameMap;
        this.deviceType = deviceType;
    }

    public static LogDTO build(String centralId, a centralLogKeyEnum, String ... params) {
        CentralLogDTO centralLog = new CentralLogDTO(centralId, null, centralLogKeyEnum, params, null, null, null, null);
        if (!centralLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(w.a.b()).centralLogDTO(centralLog).orgType(0).build();
    }

    private CentralLogDTO(String centralId, a centralLogKeyEnum, String[] params, Date time) {
        this.centralId = centralId;
        this.logKey = centralLogKeyEnum.name();
        this.params = params;
        this.time = Optional.ofNullable(time).orElse(Calendar.getInstance().getTime()).getTime();
    }

    public static LogDTO buildLogDTO(String centralId, a centralLogKeyEnum, Date time, String ... params) {
        CentralLogDTO centralLog = new CentralLogDTO(centralId, centralLogKeyEnum, params, time);
        if (!centralLog.validate()) {
            throw new IllegalArgumentException("Invalid request parameters.");
        }
        return LogDTO.builder().logType(w.a.b()).centralLogDTO(centralLog).build();
    }

    public boolean validate() {
        if (StringUtils.isNull((String)this.centralId) || StringUtils.isNull((String)this.logKey) || this.time == null) {
            return false;
        }
        return this.params != null && this.params.length != 0 || !CollectionUtils.isEmpty(this.paramMap) || !StringUtils.isNull((String)this.content);
    }

    public boolean isDeviceLog() {
        return Objects.nonNull(this.deviceType);
    }

    public static CentralLogDTOBuilder builder() {
        return new CentralLogDTOBuilder();
    }

    public void setMspId(String mspId) {
        this.mspId = mspId;
    }

    public void setCentralId(String centralId) {
        this.centralId = centralId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setLogKey(String logKey) {
        this.logKey = logKey;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public void setParamMap(Map<String, String> paramMap) {
        this.paramMap = paramMap;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setMacNameMap(Map<String, String> macNameMap) {
        this.macNameMap = macNameMap;
    }

    public void setDeviceModel(@Nullable String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public void setDeviceModelVersion(@Nullable String deviceModelVersion) {
        this.deviceModelVersion = deviceModelVersion;
    }

    public String getMspId() {
        return this.mspId;
    }

    public String getCentralId() {
        return this.centralId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getLogKey() {
        return this.logKey;
    }

    public String[] getParams() {
        return this.params;
    }

    public Map<String, String> getParamMap() {
        return this.paramMap;
    }

    public Long getTime() {
        return this.time;
    }

    public String getContent() {
        return this.content;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public Map<String, String> getMacNameMap() {
        return this.macNameMap;
    }

    @Nullable
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Nullable
    public String getDeviceModelVersion() {
        return this.deviceModelVersion;
    }

    public CentralLogDTO() {
    }

    public CentralLogDTO(String mspId, String centralId, String siteId, String logKey, String[] params, Map<String, String> paramMap, Long time, String content, String deviceType, Map<String, String> macNameMap, @Nullable String deviceModel, @Nullable String deviceModelVersion) {
        this.mspId = mspId;
        this.centralId = centralId;
        this.siteId = siteId;
        this.logKey = logKey;
        this.params = params;
        this.paramMap = paramMap;
        this.time = time;
        this.content = content;
        this.deviceType = deviceType;
        this.macNameMap = macNameMap;
        this.deviceModel = deviceModel;
        this.deviceModelVersion = deviceModelVersion;
    }

    public String toString() {
        return "CentralLogDTO(mspId=" + this.getMspId() + ", centralId=" + this.getCentralId() + ", siteId=" + this.getSiteId() + ", logKey=" + this.getLogKey() + ", params=" + Arrays.deepToString(this.getParams()) + ", paramMap=" + this.getParamMap() + ", time=" + this.getTime() + ", content=" + this.getContent() + ", deviceType=" + this.getDeviceType() + ", macNameMap=" + this.getMacNameMap() + ", deviceModel=" + this.getDeviceModel() + ", deviceModelVersion=" + this.getDeviceModelVersion() + ")";
    }

    public static class CentralLogDTOBuilder {
        private String mspId;
        private String centralId;
        private String siteId;
        private String logKey;
        private String[] params;
        private Map<String, String> paramMap;
        private Long time;
        private String content;
        private String deviceType;
        private Map<String, String> macNameMap;
        private String deviceModel;
        private String deviceModelVersion;

        CentralLogDTOBuilder() {
        }

        public CentralLogDTOBuilder mspId(String mspId) {
            this.mspId = mspId;
            return this;
        }

        public CentralLogDTOBuilder centralId(String centralId) {
            this.centralId = centralId;
            return this;
        }

        public CentralLogDTOBuilder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public CentralLogDTOBuilder logKey(String logKey) {
            this.logKey = logKey;
            return this;
        }

        public CentralLogDTOBuilder params(String[] params) {
            this.params = params;
            return this;
        }

        public CentralLogDTOBuilder paramMap(Map<String, String> paramMap) {
            this.paramMap = paramMap;
            return this;
        }

        public CentralLogDTOBuilder time(Long time) {
            this.time = time;
            return this;
        }

        public CentralLogDTOBuilder content(String content) {
            this.content = content;
            return this;
        }

        public CentralLogDTOBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public CentralLogDTOBuilder macNameMap(Map<String, String> macNameMap) {
            this.macNameMap = macNameMap;
            return this;
        }

        public CentralLogDTOBuilder deviceModel(@Nullable String deviceModel) {
            this.deviceModel = deviceModel;
            return this;
        }

        public CentralLogDTOBuilder deviceModelVersion(@Nullable String deviceModelVersion) {
            this.deviceModelVersion = deviceModelVersion;
            return this;
        }

        public CentralLogDTO build() {
            return new CentralLogDTO(this.mspId, this.centralId, this.siteId, this.logKey, this.params, this.paramMap, this.time, this.content, this.deviceType, this.macNameMap, this.deviceModel, this.deviceModelVersion);
        }

        public String toString() {
            return "CentralLogDTO.CentralLogDTOBuilder(mspId=" + this.mspId + ", centralId=" + this.centralId + ", siteId=" + this.siteId + ", logKey=" + this.logKey + ", params=" + Arrays.deepToString(this.params) + ", paramMap=" + this.paramMap + ", time=" + this.time + ", content=" + this.content + ", deviceType=" + this.deviceType + ", macNameMap=" + this.macNameMap + ", deviceModel=" + this.deviceModel + ", deviceModelVersion=" + this.deviceModelVersion + ")";
        }
    }
}

