/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.central.components.common.auditlog;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.central.components.common.util.B;
import com.tplink.smb.omada.central.components.common.util.o;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountAuditLogDTO {
    private static final Logger log = LoggerFactory.getLogger(AccountAuditLogDTO.class);
    @NotNull
    private String accountId;
    private Long time;
    @NotNull
    private String operator;
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String ipAddress;
    private String operatorTarget;
    @NotNull
    private String auditLogKey;
    @NotNull
    private Integer resultCode;
    private String[] params;

    public String toJson() {
        return o.a(this);
    }

    public Boolean check() {
        if (Objects.isNull(this.accountId) || Objects.isNull(this.time) || B.a(this.operator) || Objects.isNull(this.auditLogKey) || Objects.isNull(this.resultCode)) {
            log.warn("Illegal Account Audit Log DTO :{}", (Object)this.toString());
            return false;
        }
        return true;
    }

    public static AccountAuditLogDTOBuilder builder() {
        return new AccountAuditLogDTOBuilder();
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setOperatorTarget(String operatorTarget) {
        this.operatorTarget = operatorTarget;
    }

    public void setAuditLogKey(String auditLogKey) {
        this.auditLogKey = auditLogKey;
    }

    public void setResultCode(Integer resultCode) {
        this.resultCode = resultCode;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Long getTime() {
        return this.time;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getOperatorTarget() {
        return this.operatorTarget;
    }

    public String getAuditLogKey() {
        return this.auditLogKey;
    }

    public Integer getResultCode() {
        return this.resultCode;
    }

    public String[] getParams() {
        return this.params;
    }

    public AccountAuditLogDTO() {
    }

    public AccountAuditLogDTO(String accountId, Long time, String operator, String ipAddress, String operatorTarget, String auditLogKey, Integer resultCode, String[] params) {
        this.accountId = accountId;
        this.time = time;
        this.operator = operator;
        this.ipAddress = ipAddress;
        this.operatorTarget = operatorTarget;
        this.auditLogKey = auditLogKey;
        this.resultCode = resultCode;
        this.params = params;
    }

    public String toString() {
        return "AccountAuditLogDTO(accountId=" + this.getAccountId() + ", time=" + this.getTime() + ", operator=" + this.getOperator() + ", ipAddress=" + this.getIpAddress() + ", operatorTarget=" + this.getOperatorTarget() + ", auditLogKey=" + this.getAuditLogKey() + ", resultCode=" + this.getResultCode() + ", params=" + Arrays.deepToString(this.getParams()) + ")";
    }

    public static class AccountAuditLogDTOBuilder {
        private String accountId;
        private Long time;
        private String operator;
        private String ipAddress;
        private String operatorTarget;
        private String auditLogKey;
        private Integer resultCode;
        private String[] params;

        AccountAuditLogDTOBuilder() {
        }

        public AccountAuditLogDTOBuilder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public AccountAuditLogDTOBuilder time(Long time) {
            this.time = time;
            return this;
        }

        public AccountAuditLogDTOBuilder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public AccountAuditLogDTOBuilder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public AccountAuditLogDTOBuilder operatorTarget(String operatorTarget) {
            this.operatorTarget = operatorTarget;
            return this;
        }

        public AccountAuditLogDTOBuilder auditLogKey(String auditLogKey) {
            this.auditLogKey = auditLogKey;
            return this;
        }

        public AccountAuditLogDTOBuilder resultCode(Integer resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        public AccountAuditLogDTOBuilder params(String[] params) {
            this.params = params;
            return this;
        }

        public AccountAuditLogDTO build() {
            return new AccountAuditLogDTO(this.accountId, this.time, this.operator, this.ipAddress, this.operatorTarget, this.auditLogKey, this.resultCode, this.params);
        }

        public String toString() {
            return "AccountAuditLogDTO.AccountAuditLogDTOBuilder(accountId=" + this.accountId + ", time=" + this.time + ", operator=" + this.operator + ", ipAddress=" + this.ipAddress + ", operatorTarget=" + this.operatorTarget + ", auditLogKey=" + this.auditLogKey + ", resultCode=" + this.resultCode + ", params=" + Arrays.deepToString(this.params) + ")";
        }
    }
}

