/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.util;

import com.tplink.smb.omada.apigateway.dispatch.util.GetRequestIpProperties;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.dispatcher.chain.AttributeRequestEntity;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.shiro.web.servlet.ShiroHttpServletResponse;
import org.json.JSONObject;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriTemplate;

public class WebUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(WebUtils.class);
    public static final String HEADER_APP_REQUEST = "requestByApp";
    private static final String HEADER_X_REQUEST = "X-Requested-With";
    private static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    private static final String X_FORWARDED_FOR = "x-forwarded-for";
    public static final String X_MAC_FORMAT = "x-mac-format";
    public static final String APP_SUPPORT_MAC_FORMAT = "support-mac-formatter";
    private static final String COOKIE_HEADER_NAME = "Set-Cookie";
    private static final String REFRESH_HEADER_NAME = "Refresh";
    private static final String REFRESH_VALUE_AUTO = "auto";
    public static final UriTemplate URI_TEMPLATE = new UriTemplate("/{omadacId}");
    public static final UriTemplate OMADAC_API_TEMPLATE = new UriTemplate("/{omadacId}/api/{*}");
    public static final UriTemplate MSP_API_TEMPLATE = new UriTemplate("/api/{*}/msp/{mspId}");
    public static final UriTemplate APP_API_TEMPLATE = new UriTemplate("/{omadacId}/api/{*}/app");
    public static final UriTemplate MSP_APP_API_TEMPLATE = new UriTemplate("/api/{*}/app/msp/{mspId}");
    public static final UriTemplate OPENAPI_OMADAC_TEMPLATE = new UriTemplate("/openapi/{*}/{omadacId}");
    public static final UriTemplate OPENAPI_MSP_TEMPLATE = new UriTemplate("/openapi/{*}/msp/{mspId}");
    public static final UriTemplate OMADAC_SITE_API_TEMPLATE = new UriTemplate("/{omadacId}/api/{*}/sites/{siteId}");
    public static final UriTemplate MSP_CUSTOMER_SITE_API_TEMPLATE = new UriTemplate("/api/{*}/msp/{mspId}/customers/{customerId}/sites/{siteId}");
    public static final UriTemplate SITE_HOTSPOT_API_TEMPLATE = new UriTemplate("/{omadacId}/api/{*}/hotspot/sites/{siteId}");
    public static final UriTemplate SITE_FILE_API_TEMPLATE = new UriTemplate("/{omadacId}/api/{*}/files/sites/{siteId}");
    public static final UriTemplate APP_SITE_API_TEMPLATE = new UriTemplate("/{omadacId}/api/{*}/app/sites/{siteId}");
    public static final UriTemplate APP_SITE_FILE_API_TEMPLATE = new UriTemplate("/{omadacId}/api/{version}/app/files/sites/{siteId}");
    public static final UriTemplate MSP_APP_CUSTOMER_SITE_API_TEMPLATE = new UriTemplate("/api/{*}/app/msp/{mspId}/customers/{customerId}/sites/{siteId}");
    public static final UriTemplate OPEN_API_SITE_API_TEMPLATE = new UriTemplate("/openapi/{*}/{omadacId}/sites/{siteId}");
    public static final UriTemplate OPEN_API_SITE_ID_API_TEMPLATE = new UriTemplate("/openapi/{version}/{omadacId}/sites/{siteId}");
    public static final UriTemplate OPEN_API_SITE_FILE_API_TEMPLATE = new UriTemplate("/openapi/{version}/{omadacId}/files/sites/{siteId}");
    public static final UriTemplate OPEN_API_SITE_TEMPLATE_API_PATH_TEMPLATE = new UriTemplate("/openapi/{*}/{omadacId}/sitetemplates/{siteTemplateId}");
    public static final UriTemplate SITE_TEMPLATE_PATH_API_TEMPLATE = new UriTemplate("/{omadacId}/api/{*}/sitetemplates/{siteTemplateId}");
    private static String APP_REMOTE = "app-remote";
    private static String APP_LOCAL = "app-local";
    private static String WEB_REMOTE = "web-remote";
    private static String WEB_LOCAL = "web-local";

    public static boolean isAutoRefreshRequest(@Nonnull HttpServletRequest request) {
        return request.getHeader(REFRESH_HEADER_NAME) != null && REFRESH_VALUE_AUTO.equalsIgnoreCase(request.getHeader(REFRESH_HEADER_NAME));
    }

    public static boolean isAutoRefreshRequest(@Nonnull RequestEntity<String> request) {
        return request.getHeaders().getFirst(REFRESH_HEADER_NAME) != null && REFRESH_VALUE_AUTO.equalsIgnoreCase(request.getHeaders().getFirst(REFRESH_HEADER_NAME));
    }

    public static boolean isAjax(@Nonnull HttpServletRequest request) {
        return request.getHeader(HEADER_X_REQUEST) != null && request.getHeader(HEADER_X_REQUEST).equalsIgnoreCase(XML_HTTP_REQUEST);
    }

    public static boolean isRequestFromApp(@Nonnull HttpServletRequest request) {
        boolean appApiRequest = false;
        if (request.getHeader(HEADER_APP_REQUEST) != null && "true".equalsIgnoreCase(request.getHeader(HEADER_APP_REQUEST))) {
            appApiRequest = true;
        }
        if (APP_REMOTE.equalsIgnoreCase(request.getHeader("Omada-Request-Source")) || APP_LOCAL.equalsIgnoreCase(request.getHeader("Omada-Request-Source"))) {
            appApiRequest = true;
        }
        return appApiRequest;
    }

    public static boolean isRequestFromWeb(@Nonnull HttpServletRequest request) {
        boolean webApiRequest = false;
        if (WEB_REMOTE.equalsIgnoreCase(request.getHeader("Omada-Request-Source")) || WEB_LOCAL.equalsIgnoreCase(request.getHeader("Omada-Request-Source"))) {
            webApiRequest = true;
        }
        return webApiRequest;
    }

    public static boolean isRequestFromWeb(@Nonnull RequestEntity request) {
        boolean webApiRequest = false;
        if (WEB_REMOTE.equalsIgnoreCase(request.getHeaders().getFirst("Omada-Request-Source")) || WEB_LOCAL.equalsIgnoreCase(request.getHeaders().getFirst("Omada-Request-Source"))) {
            webApiRequest = true;
        }
        return webApiRequest;
    }

    public static boolean isRequestFromApp(@Nonnull RequestEntity<?> request) {
        return "true".equalsIgnoreCase(request.getHeaders().getFirst(HEADER_APP_REQUEST));
    }

    public static HttpServletRequest toHttp(ServletRequest request) {
        return (HttpServletRequest)request;
    }

    public static HttpServletResponse toHttp(ServletResponse response) {
        return (HttpServletResponse)response;
    }

    public static void buildAccessDeniedResponse(ServletResponse response) {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setStatus(HttpStatus.OK.value());
            try {
                OperationResponse operRslt = new OperationResponse(b.l);
                JSONObject dataObj = new JSONObject((Object)operRslt);
                ServletOutputStream outputStream = response.getOutputStream();
                byte[] dataByteArr = dataObj.toString().getBytes(StandardCharsets.UTF_8);
                outputStream.write(dataByteArr);
            }
            catch (Exception ex) {
                log.error(ex.toString(), (Throwable)ex);
            }
        }
    }

    public static void buildAccessDeniedResponse(ServletResponse response, OperationResponse operRslt) {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setStatus(HttpStatus.OK.value());
            try {
                JSONObject dataObj = new JSONObject((Object)operRslt);
                ServletOutputStream outputStream = response.getOutputStream();
                byte[] dataByteArr = dataObj.toString().getBytes(StandardCharsets.UTF_8);
                outputStream.write(dataByteArr);
            }
            catch (Exception ex) {
                log.error(ex.toString(), (Throwable)ex);
            }
        }
    }

    public static void buildIpAccessDeniedResponse(ServletResponse response, OperationResponse operRslt) {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setStatus(HttpStatus.OK.value());
            httpResponse.addHeader(COOKIE_HEADER_NAME, "TPOMADA_SESSIONID=; Path=/; Max-Age=0");
            try {
                JSONObject dataObj = new JSONObject((Object)operRslt);
                ServletOutputStream outputStream = response.getOutputStream();
                byte[] dataByteArr = dataObj.toString().getBytes(StandardCharsets.UTF_8);
                outputStream.write(dataByteArr);
            }
            catch (Exception ex) {
                log.error(ex.toString(), (Throwable)ex);
            }
        }
    }

    public static void buildOpenApiAccessDeniedResponse(ServletResponse response) {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setStatus(HttpStatus.UNAUTHORIZED.value());
            try {
                OperationResponse operRslt = new OperationResponse(b.NF);
                JSONObject dataObj = new JSONObject((Object)operRslt);
                ServletOutputStream outputStream = response.getOutputStream();
                byte[] dataByteArr = dataObj.toString().getBytes(StandardCharsets.UTF_8);
                outputStream.write(dataByteArr);
            }
            catch (Exception ex) {
                log.error(ex.toString(), (Throwable)ex);
            }
        }
    }

    public static RequestEntity<String> getStringRequestEntity(String reqBodyString, @Nonnull HttpServletRequest request) {
        RequestEntity<String> entity = null;
        try {
            entity = WebUtils.getStringRequestEntityThrowException(reqBodyString, request);
        }
        catch (URISyntaxException e2) {
            log.warn(e2.toString(), (Throwable)e2);
        }
        return entity;
    }

    public static RequestEntity<String> getStringRequestEntityThrowException(String reqBodyString, @Nonnull HttpServletRequest request) throws URISyntaxException {
        HttpHeaders headers = new HttpHeaders();
        Enumeration e2 = request.getHeaderNames();
        while (e2.hasMoreElements()) {
            String headerName = (String)e2.nextElement();
            headers.put(headerName, EnumerationUtils.toList((Enumeration)request.getHeaders(headerName)));
        }
        String remoteAddress = WebUtils.getRemoteAddress(request);
        if (T.b((String)remoteAddress)) {
            headers.put("Omada-Remote-IP-Address", Collections.singletonList(remoteAddress));
        }
        String accessToken = WebUtils.getAccessToken(request);
        log.debug("getStringRequestEntity by open api, accessToken:{}, request:{}", (Object)accessToken, (Object)request.getHeader("Authorization"));
        if (T.b((String)accessToken)) {
            headers.put("Omada-OpenApi-Access-Token", Collections.singletonList(accessToken));
        }
        RequestEntity entity = null;
        try {
            URI url = request.getQueryString() != null ? new URI(request.getRequestURL().append("?").append(request.getQueryString()).toString()) : new URI(request.getRequestURL().toString());
            entity = new RequestEntity((Object)reqBodyString, (MultiValueMap)headers, HttpMethod.valueOf((String)request.getMethod()), url, String.class);
        }
        catch (URISyntaxException e3) {
            log.warn(e3.toString(), (Throwable)e3);
        }
        return entity;
    }

    public static AttributeRequestEntity<String> getStringAttributeRequestEntityThrowException(String reqBodyString, @Nonnull HttpServletRequest request) throws URISyntaxException {
        return new AttributeRequestEntity(WebUtils.getStringRequestEntityThrowException(reqBodyString, request));
    }

    public static AttributeRequestEntity<String> getStringAttributeRequestEntity(String reqBodyString, @Nonnull HttpServletRequest request) {
        return new AttributeRequestEntity(WebUtils.getStringRequestEntity(reqBodyString, request));
    }

    @Nullable
    public static String getSessionId(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getId();
    }

    @Nonnull
    public static String buildRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static boolean isVaildToken(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest != null) {
            String requestURI = httpRequest.getRequestURI();
            if (Objects.equals(requestURI, "/") || Objects.equals(requestURI, "/index.jsp") || Objects.equals(requestURI, "/home.html") || Objects.equals(requestURI, "/hotspot/index.html") || Objects.equals(requestURI, "/hotspot/voucher/print.html")) {
                return true;
            }
            if (httpRequest.getSession() == null || httpRequest.getSession().getAttribute("Csrf-Token") == null) {
                log.warn("sessionCSRFToken is null for request {}", (Object)requestURI);
                return false;
            }
            String sessionCSRFToken = (String)httpRequest.getSession().getAttribute("Csrf-Token");
            String requestCSRFToken = httpRequest.getHeader("Csrf-Token");
            log.debug("sessionCSRFToken {} requestCSRFToken {}", (Object)sessionCSRFToken, (Object)requestCSRFToken);
            if (T.a((String)requestCSRFToken)) {
                log.warn("sessionCSRFToken is null for request {}", (Object)requestURI);
                return false;
            }
            if (!requestCSRFToken.equals(sessionCSRFToken)) {
                log.warn("requestCSRFToken is not correct for request {}, request {}, attribute {}", (Object)requestURI, (Object)requestCSRFToken, (Object)sessionCSRFToken);
                return false;
            }
        }
        return true;
    }

    public static void setClearCookiePath(String omadacId, ServletResponse response) {
        if (!(response instanceof HttpServletResponse) || T.a((String)omadacId)) {
            return;
        }
        ((HttpServletResponse)response).addHeader(COOKIE_HEADER_NAME, "TPOMADA_SESSIONID=; Path=/" + omadacId + "; Max-Age=0");
    }

    public static void setOpenApiCookiePath(ServletResponse response) {
        if (!(response instanceof HttpServletResponse)) {
            return;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        Collection headerValues = httpServletResponse.getHeaders(COOKIE_HEADER_NAME);
        if (CollectionUtils.isEmpty((Collection)headerValues)) {
            return;
        }
        headerValues.forEach(headerValue -> {
            if (httpServletResponse instanceof ShiroHttpServletResponse) {
                ShiroHttpServletResponse shiroHttpServletResponse = (ShiroHttpServletResponse)response;
                shiroHttpServletResponse.setHeader(COOKIE_HEADER_NAME, headerValue);
            }
        });
    }

    public static void setHotspotCookiePath(String omadacId, ServletResponse response) {
        if (!(response instanceof HttpServletResponse) || T.a((String)omadacId)) {
            return;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        Collection headerValues = httpServletResponse.getHeaders(COOKIE_HEADER_NAME);
        if (CollectionUtils.isEmpty((Collection)headerValues)) {
            return;
        }
        headerValues.forEach(headerValue -> {
            headerValue = headerValue.replace("Path=/", "Path=/hotspot/" + omadacId);
            if (httpServletResponse instanceof ShiroHttpServletResponse) {
                ShiroHttpServletResponse shiroHttpServletResponse = (ShiroHttpServletResponse)response;
                shiroHttpServletResponse.setHeader(COOKIE_HEADER_NAME, headerValue);
            }
        });
    }

    public static String getRemoteAddress(HttpServletRequest request) {
        GetRequestIpProperties properties = (GetRequestIpProperties)a.b(GetRequestIpProperties.class);
        if (properties != null && properties.isUseNewMethod()) {
            String remoteAddr = request.getRemoteAddr();
            log.debug("get remote addreess with check. ip: {}.", new Supplier[]{() -> com.tplink.smb.omada.common.util.e.a.c((String)remoteAddr)});
            if (Pattern.matches("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", remoteAddr) || Pattern.matches("(^\\S*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\S*$)", remoteAddr)) {
                return remoteAddr;
            }
            log.warn("invalid Ipv4 or Ipv6, ip: {}", (Object)com.tplink.smb.omada.common.util.e.a.c((String)remoteAddr));
            return null;
        }
        if (!OmadacType.s()) {
            return request.getRemoteAddr();
        }
        String ip = request.getHeader(X_FORWARDED_FOR);
        if (T.b((String)ip)) {
            log.trace("Successfully resolved IP from X-Forwarded-For: {}", (Object)ip);
            return ip.split(",")[0];
        }
        String remoteAddr = request.getRemoteAddr();
        log.debug("Failed to get IP from X-Forwarded-For: {}, using RemoteAddr from HTTP Request: {}", new Supplier[]{() -> com.tplink.smb.omada.common.util.e.a.c((String)ip), () -> com.tplink.smb.omada.common.util.e.a.c((String)remoteAddr)});
        return remoteAddr;
    }

    public static String getAccessToken(HttpServletRequest request) {
        String accessTokenFromHeader = request.getHeader("Authorization");
        String accessTokenFromRequest = request.getParameter("Authorization");
        if (T.a((String)accessTokenFromHeader) && T.a((String)accessTokenFromRequest)) {
            return null;
        }
        String requestAccessToken = !T.c((String)accessTokenFromHeader) ? accessTokenFromHeader : accessTokenFromRequest;
        String accessToken = null;
        Map<String, String> map = WebUtils.getAttributesByOpenApi(requestAccessToken);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!T.a((String)entry.getKey(), (String)"AccessToken")) continue;
            accessToken = entry.getValue();
        }
        return accessToken;
    }

    private static Map<String, String> getAttributesByOpenApi(String attributes) {
        HashMap<String, String> attr = new HashMap<String, String>();
        Matcher m2 = Pattern.compile("(\\w+)=(.*?)(?=,\\w+=|$)").matcher(attributes);
        while (m2.find()) {
            attr.put(m2.group(1), m2.group(2));
        }
        return attr;
    }

    @Nullable
    public static String getRemoteAddressWithXForwardedHeader(HttpServletRequest request) {
        if (OmadacType.s()) {
            String ip = request.getHeader(X_FORWARDED_FOR);
            if (!T.a((String)ip)) {
                return ip.split(",")[0];
            }
            log.warn("RemoteAddress obtain error, requet header X-Forwarded-For:{},RemoteAddr:{}", (Object)ip, (Object)request.getRemoteAddr());
            return null;
        }
        return request.getRemoteAddr();
    }

    public static String getOmadacIdFromRequest(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return null;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        Map uriMap = URI_TEMPLATE.match(httpServletRequest.getRequestURI());
        return (String)uriMap.get("omadacId");
    }

    public static String getMspId(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return null;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String uri = httpServletRequest.getRequestURI();
        String mspId = null;
        Map mspUriMap = MSP_API_TEMPLATE.match(uri);
        Map mspAppUriMap = MSP_APP_API_TEMPLATE.match(uri);
        Map openApiMspUriMap = OPENAPI_MSP_TEMPLATE.match(uri);
        if (mspUriMap.containsKey("mspId")) {
            mspId = (String)mspUriMap.get("mspId");
        } else if (mspAppUriMap.containsKey("mspId")) {
            mspId = (String)mspAppUriMap.get("mspId");
        } else if (openApiMspUriMap.containsKey("mspId")) {
            mspId = (String)openApiMspUriMap.get("mspId");
        }
        return mspId;
    }

    public static String getOmadacId(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return null;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String uri = httpServletRequest.getRequestURI();
        String omadacId = null;
        Map omadacUriMap = OMADAC_API_TEMPLATE.match(uri);
        Map appTemplateUriMap = APP_API_TEMPLATE.match(uri);
        Map openApiOmadacUriMap = OPENAPI_OMADAC_TEMPLATE.match(uri);
        if (omadacUriMap.containsKey("omadacId")) {
            omadacId = (String)omadacUriMap.get("omadacId");
        } else if (appTemplateUriMap.containsKey("omadacId")) {
            omadacId = (String)appTemplateUriMap.get("omadacId");
        } else if (openApiOmadacUriMap.containsKey("omadacId")) {
            omadacId = (String)openApiOmadacUriMap.get("omadacId");
        }
        return omadacId;
    }

    public static void appendSchemeHostPort(StringBuilder url, String scheme, String server, int port) {
        url.append(scheme).append("://").append(WebUtils.normalizeHost(server));
        if (port > 0) {
            switch (scheme) {
                case "http": {
                    if (port == 80) break;
                    url.append(':').append(port);
                    break;
                }
                case "https": {
                    if (port == 443) break;
                    url.append(':').append(port);
                    break;
                }
                default: {
                    url.append(':').append(port);
                }
            }
        }
    }

    public static String normalizeHost(String host) {
        if (host.isEmpty() || host.charAt(0) == '[' || host.indexOf(58) < 0) {
            return host;
        }
        return "[" + host + "]";
    }

    @Nonnull
    public static Map<String, Collection<String>> getHeaders(@Nonnull HttpServletResponse response) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        for (String name : response.getHeaderNames()) {
            map.put(name, response.getHeaders(name));
        }
        return map;
    }

    @Nonnull
    public static HttpHeaders getHttpHeaders(@Nonnull HttpServletRequest request) {
        Enumeration headerEnumeration = request.getHeaderNames();
        HttpHeaders headers = new HttpHeaders();
        if (headerEnumeration == null) {
            return headers;
        }
        while (headerEnumeration.hasMoreElements()) {
            String headerName = (String)headerEnumeration.nextElement();
            headers.add(headerName, request.getHeader(headerName));
        }
        return headers;
    }

    @Generated
    private WebUtils() {
    }
}

