/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter;

import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.cache.StompSessionCache;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter.dto.WsCloseEvent;
import com.tplink.smb.omada.common.util.W;
import com.tplink.smb.omada.common.util.x;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class WsCloseEventSubscriber
implements EventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WsCloseEventSubscriber.class);
    private static final int TIMEOUT_MS = 1800000;
    private static final String GROUP_ID = "OMADA_WS_CLOSE_EVENT_GROUP_OMADA_API_GATEWAY";
    @Autowired
    private EventCenter eventCenter;
    @Qualifier(value="stompEventWorkGroup")
    @Autowired
    private ExecutorService executorService;

    @PostConstruct
    public void register() {
        this.eventCenter.registerUnicast("omada.apigateway.websocket.close", GROUP_ID, (EventHandler)this, this.executorService);
    }

    public void handleEvent(@Nonnull Event event) {
        if (W.a((long)event.getTimeStamp(), (int)1800000)) {
            log.trace("WsCloseEvent timeout, skip. event={}", (Object)event);
            return;
        }
        WsCloseEvent wsCloseEventDTO = (WsCloseEvent)x.a((String)((String)event.getMessage()), WsCloseEvent.class);
        log.trace("<STOMP> received ws close event message: {}", (Object)wsCloseEventDTO);
        StompSessionCache.removeAndCloseSessionByOmadacId(wsCloseEventDTO.getOmadacId());
    }
}

