/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter;

import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.omada.apigateway.dispatch.cache.OmadacCache;
import com.tplink.smb.omada.apigateway.dispatch.dto.OmadacBasicDTO;
import com.tplink.smb.omada.apigateway.dispatch.stomp.dto.CloudStompMessageDTO;
import com.tplink.smb.omada.apigateway.dispatch.stomp.dto.StompMessageDTO;
import com.tplink.smb.omada.apigateway.dispatch.stomp.dto.UserPrincipal;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter.dto.StompMessageEvent;
import com.tplink.smb.omada.apigateway.dispatch.util.ApiGatewayPIIUtil;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.q.b;
import com.tplink.smb.omada.common.q.c;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.W;
import com.tplink.smb.omada.common.util.system.NodeInfo;
import com.tplink.smb.omada.common.util.system.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.judgement.a.e;
import com.tplink.smb.omada.manager.configuration.api.internal.a.d;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.WebSocketClusterReqDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriTemplate;

@Component
public class StompEventSubscriber
implements EventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StompEventSubscriber.class);
    @Autowired
    @Lazy
    private OmadacCache omadacCache;
    @Autowired
    @Lazy
    private d webSocketClusterInternalApiService;
    private static final int TIMEOUT_MS = 1800000;
    private final UriTemplate siteUriTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.l);
    private final UriTemplate omadacUriTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.g);
    private final UriTemplate globalUriTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.k);
    private final UriTemplate mspUriTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.h);
    private final UriTemplate globalUserQueueUriTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.i);
    private final UriTemplate terminalUserUriTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.m);
    private final UriTemplate siteDeviceUriTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.r);
    private final UriTemplate omadacPendingDeviceUriTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.q);
    private final UriTemplate globalDeviceUriTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.p);
    private final UriTemplate mspDeviceUriTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.o);
    private final List<c> deviceEventList = new ArrayList<c>(Arrays.asList(c.a, c.A));
    @Autowired
    private EventCenter eventCenter;
    @Qualifier(value="stompEventWorkGroup")
    @Autowired
    private ExecutorService stompEventWorkGroup;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private e judgeService;

    @PostConstruct
    public void register() {
        this.eventCenter.registerBroadcast("omada.apigateway.websocket.stompevent", (EventHandler)this, this.stompEventWorkGroup);
    }

    public void handleEvent(@Nonnull Event domainEvent) {
        if (W.a((long)domainEvent.getTimeStamp(), (int)1800000)) {
            log.warn("StompEvent timeout, skip. event={}", (Object)domainEvent);
            return;
        }
        StompMessageEvent stompMessageEvent = (StompMessageEvent)x.a((String)((String)domainEvent.getMessage()), StompMessageEvent.class);
        if (!this.judgeService.a(stompMessageEvent.getOmadacId(), "websocket:basic")) {
            return;
        }
        log.debug("<STOMP> received stomp event message: {}", (Object)ApiGatewayPIIUtil.getMaskStompMessage((String)domainEvent.getMessage()));
        this.eventHandle(stompMessageEvent);
        if (!Boolean.TRUE.equals(stompMessageEvent.getSentByOtherNode())) {
            this.sendWebSocketMsgToNodes(stompMessageEvent);
        }
    }

    private void eventHandle(StompMessageEvent event) {
        if (event == null) {
            log.error("<STOMP> STOMP event consumer got null event.");
            return;
        }
        if (!this.checkEvent(event)) {
            log.error("<STOMP> STOMP event check failed, event: {}", (Object)event);
            return;
        }
        this.sendMessage(event);
    }

    private boolean checkEvent(@Nonnull StompMessageEvent<?> event) {
        c eventType = c.a((Integer)event.getEventType());
        if (eventType == null) {
            log.error("<STOMP> STOMP event consumer got null eventType.");
            return false;
        }
        b destination = eventType.c();
        Object data = event.getData();
        String omadacId = event.getOmadacId();
        if (destination == null || data == null || T.a((String)omadacId)) {
            log.debug("<STOMP> STOMP event consumer got null. data: {}, eventType: {}, destination: {}, omadacId: {}", new Object[]{data, eventType, destination, omadacId});
            return false;
        }
        return true;
    }

    private void sendMessage(@Nonnull StompMessageEvent<?> event) {
        c eventType = c.a((Integer)event.getEventType());
        if (eventType == null) {
            log.error("<STOMP> STOMP event consumer got null eventType.");
            return;
        }
        String omadacId = event.getOmadacId();
        if (!this.checkEventCapacity(omadacId, eventType)) {
            log.debug("<STOMP> current omadacId={} unsupport event {}", (Object)omadacId, (Object)eventType.b());
            return;
        }
        b destination = eventType.c();
        Object data = event.getData();
        log.debug("<STOMP> try to send destination: {}", (Object)destination);
        try {
            switch (destination) {
                case c: {
                    this.handleOmadaStatus(event);
                    break;
                }
                case i: {
                    String siteId = event.getSiteId();
                    if (T.a((String)siteId)) {
                        log.warn("<STOMP> STOMP event siteId is null, eventType: {}, destination: {}", (Object)eventType, (Object)destination);
                        break;
                    }
                    this.handleSiteStatus(event);
                    break;
                }
                case b: {
                    this.handleGlobalStatus(event);
                    break;
                }
                case j: {
                    String siteId = event.getSiteId();
                    if (T.a((String)siteId)) {
                        log.warn("<STOMP> STOMP event siteId is null, eventType: {}, destination: {}", (Object)eventType, (Object)destination);
                        break;
                    }
                    HashMap<String, String> uriVariables = new HashMap<String, String>();
                    uriVariables.put("omadacId", omadacId);
                    uriVariables.put("siteId", siteId);
                    String sessionDestination = this.terminalUserUriTemplate.expand(uriVariables).toASCIIString();
                    String httpSessionId = event.getUserId();
                    UserPrincipal userPrincipal = new UserPrincipal(omadacId, httpSessionId);
                    String destinationWithoutPrefix = sessionDestination.replace("/user", "");
                    log.debug("<STOMP> websocket single user send destination: {}, user: {}", (Object)destinationWithoutPrefix, (Object)userPrincipal.getName());
                    StompMessageDTO stompMessageDTO = new StompMessageDTO(eventType, omadacId, siteId, data);
                    this.messagingTemplate.convertAndSendToUser(userPrincipal.getName(), destinationWithoutPrefix, stompMessageDTO);
                    log.debug("<STOMP> websocket local send message: {}", stompMessageDTO);
                    this.sendStompMessageToOmadaCloud(sessionDestination, new StompMessageDTO(eventType, omadacId, siteId, httpSessionId, data));
                    break;
                }
                case a: {
                    this.handleMspStatus(event);
                    break;
                }
                case h: {
                    Map<String, String> uriVariables = Collections.singletonMap("omadacId", omadacId);
                    String sessionDest = this.globalUserQueueUriTemplate.expand(uriVariables).toASCIIString();
                    String globalDestinationWithoutPrefix = sessionDest.replace("/user", "");
                    String httpSessionId = event.getUserId();
                    UserPrincipal userPrincipal = new UserPrincipal(omadacId, httpSessionId);
                    log.debug("<STOMP> websocket single user send destination: {}, user: {}", (Object)globalDestinationWithoutPrefix, (Object)userPrincipal.getName());
                    StompMessageDTO messageDTO = new StompMessageDTO(eventType, omadacId, data);
                    this.messagingTemplate.convertAndSendToUser(userPrincipal.getName(), globalDestinationWithoutPrefix, messageDTO);
                    messageDTO.setUserId(httpSessionId);
                    this.sendStompMessageToOmadaCloud(sessionDest, messageDTO);
                    break;
                }
                default: {
                    log.warn("<STOMP> Unsupported STOMP message destination: {}", (Object)destination);
                    break;
                }
            }
        }
        catch (Exception e2) {
            log.error(e2.toString(), (Throwable)e2);
        }
    }

    private boolean checkEventCapacity(String omadacId, c eventType) {
        if (!this.judgeService.a(omadacId, "websocket:limit")) {
            return true;
        }
        List supportTopics = (List)this.judgeService.a(omadacId, "websocket:limit", "events", List.class);
        return !CollectionUtils.isEmpty((Collection)supportTopics) && supportTopics.contains(eventType.b());
    }

    private void sendStompMessageToOmadaCloud(String dest, StompMessageDTO message) {
        if (OmadacType.s()) {
            return;
        }
        this.eventCenter.send("omada.starter.websocket.stompevent", ((Event.EventBuilder)Event.builder().message((Object)x.a((Object)CloudStompMessageDTO.fromStompMessage(dest, message)))).build());
    }

    private boolean needBroadcastSiteWsToGlobalAndMsp(c eventType) {
        return this.deviceEventList.contains(eventType);
    }

    private String getMspId(String omadacId) {
        OmadacBasicDTO omadacBasicDTO = this.omadacCache.findOmadacById(omadacId);
        if (omadacBasicDTO != null) {
            com.tplink.smb.omada.common.f.c omadacPattern = com.tplink.smb.omada.common.f.c.a((Integer)omadacBasicDTO.getPattern());
            if (com.tplink.smb.omada.common.f.c.c.a(omadacPattern)) {
                return null;
            }
            if (com.tplink.smb.omada.common.f.c.b.a(omadacPattern)) {
                return omadacBasicDTO.getOmadacId();
            }
            if (com.tplink.smb.omada.common.f.c.a.a(omadacPattern)) {
                return omadacBasicDTO.getMspId();
            }
        }
        return null;
    }

    public void sendWebSocketMsgToNodes(StompMessageEvent event) {
        if (!a.b()) {
            return;
        }
        log.info("do sendWebSocketMsgToNodes.");
        Map nodeInfoMap = com.tplink.smb.omada.common.util.system.c.a();
        for (Map.Entry entry : nodeInfoMap.entrySet()) {
            if (Objects.equals(((NodeInfo)entry.getValue()).getNodeId(), a.h())) continue;
            WebSocketClusterReqDTO webSocketClusterReqDTO = new WebSocketClusterReqDTO();
            webSocketClusterReqDTO.setNodeId(((NodeInfo)entry.getValue()).getNodeId());
            webSocketClusterReqDTO.setEvent(x.a((Object)event));
            OperationResponse response = this.webSocketClusterInternalApiService.a(webSocketClusterReqDTO);
            if (response.success()) continue;
            log.warn("nodeId:{} controller[status:{}] failed to send websocket info.", (Object)((NodeInfo)entry.getValue()).getNodeId(), (Object)((NodeInfo)entry.getValue()).getStatus());
        }
    }

    private void handleOmadaStatus(StompMessageEvent<?> event) {
        log.debug("handleOmadaStatus.");
        c eventType = c.a((Integer)event.getEventType());
        String omadacId = event.getOmadacId();
        Object data = event.getData();
        Map<String, String> uriVariables = Collections.singletonMap("omadacId", omadacId);
        String globalDestination = this.globalUriTemplate.expand(uriVariables).toASCIIString();
        String omadacDestination = this.omadacUriTemplate.expand(uriVariables).toASCIIString();
        if (c.b.equals((Object)eventType)) {
            log.debug("handleOmadaStatus. pending device msg, oamdacId= {}", (Object)omadacId);
            this.messagingTemplate.convertAndSend((Object)globalDestination, new StompMessageDTO(eventType, omadacId, data));
            String globalDeviceDestination = this.globalDeviceUriTemplate.expand(uriVariables).toASCIIString();
            this.sendStompMessageToOmadaCloud(globalDeviceDestination, new StompMessageDTO(eventType, omadacId, data));
        }
        log.debug("handleOmadaStatus, oamdacId= {}", (Object)omadacId);
        this.messagingTemplate.convertAndSend((Object)omadacDestination, new StompMessageDTO(eventType, omadacId, data));
        if (this.deviceEventList.contains(eventType)) {
            String omadacDeviceDestination = this.omadacPendingDeviceUriTemplate.expand(uriVariables).toASCIIString();
            this.sendStompMessageToOmadaCloud(omadacDeviceDestination, new StompMessageDTO(eventType, omadacId, data));
        } else {
            this.sendStompMessageToOmadaCloud(omadacDestination, new StompMessageDTO(eventType, omadacId, data));
        }
    }

    private void handleSiteStatus(StompMessageEvent<?> event) {
        log.debug("handleSiteStatus");
        c eventType = c.a((Integer)event.getEventType());
        String omadacId = event.getOmadacId();
        String siteId = event.getSiteId();
        Object data = event.getData();
        HashMap<String, String> uriVariables = new HashMap<String, String>(4);
        uriVariables.put("omadacId", omadacId);
        uriVariables.put("siteId", siteId);
        String siteDestination = this.siteUriTemplate.expand(uriVariables).toASCIIString();
        log.debug("handleSiteStatus, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
        this.messagingTemplate.convertAndSend((Object)siteDestination, new StompMessageDTO(eventType, omadacId, siteId, data));
        if (this.deviceEventList.contains(eventType)) {
            String siteDeviceDestination = this.siteDeviceUriTemplate.expand(uriVariables).toASCIIString();
            this.sendStompMessageToOmadaCloud(siteDeviceDestination, new StompMessageDTO(eventType, omadacId, data));
        } else {
            this.sendStompMessageToOmadaCloud(siteDestination, new StompMessageDTO(eventType, omadacId, data));
        }
        if (this.needBroadcastSiteWsToGlobalAndMsp(eventType)) {
            String globalDes = this.globalUriTemplate.expand(uriVariables).toASCIIString();
            this.messagingTemplate.convertAndSend((Object)globalDes, new StompMessageDTO(eventType, omadacId, data));
            if (this.deviceEventList.contains(eventType)) {
                String globalDevice = this.globalDeviceUriTemplate.expand(uriVariables).toASCIIString();
                this.sendStompMessageToOmadaCloud(globalDevice, new StompMessageDTO(eventType, omadacId, data));
            } else {
                this.sendStompMessageToOmadaCloud(globalDes, new StompMessageDTO(eventType, omadacId, data));
            }
            String mspId = this.getMspId(omadacId);
            if (mspId != null) {
                uriVariables.put("mspId", mspId);
                String mspDes = this.mspUriTemplate.expand(uriVariables).toASCIIString();
                this.messagingTemplate.convertAndSend((Object)mspDes, new StompMessageDTO(eventType, mspId, data));
                if (this.deviceEventList.contains(eventType)) {
                    String mspDevice = this.mspDeviceUriTemplate.expand(uriVariables).toASCIIString();
                    this.sendStompMessageToOmadaCloud(mspDevice, new StompMessageDTO(eventType, mspId, data));
                } else {
                    this.sendStompMessageToOmadaCloud(mspDes, new StompMessageDTO(eventType, mspId, data));
                }
            }
        }
    }

    private void handleMspStatus(StompMessageEvent<?> event) {
        c eventType = c.a((Integer)event.getEventType());
        String omadacId = event.getOmadacId();
        Object data = event.getData();
        Map<String, String> uriVariables = Collections.singletonMap("mspId", omadacId);
        String mspDes = this.mspUriTemplate.expand(uriVariables).toASCIIString();
        this.messagingTemplate.convertAndSend((Object)mspDes, new StompMessageDTO(eventType, omadacId, data));
        if (this.deviceEventList.contains(eventType)) {
            String mspDevice = this.mspDeviceUriTemplate.expand(uriVariables).toASCIIString();
            this.sendStompMessageToOmadaCloud(mspDevice, new StompMessageDTO(eventType, omadacId, data));
        } else {
            this.sendStompMessageToOmadaCloud(mspDes, new StompMessageDTO(eventType, omadacId, data));
        }
    }

    private void handleGlobalStatus(StompMessageEvent<?> event) {
        c eventType = c.a((Integer)event.getEventType());
        String omadacId = event.getOmadacId();
        Object data = event.getData();
        Map<String, String> uriVariables = Collections.singletonMap("omadacId", omadacId);
        String globalDes = this.globalUriTemplate.expand(uriVariables).toASCIIString();
        this.messagingTemplate.convertAndSend((Object)globalDes, new StompMessageDTO(eventType, omadacId, data));
        if (this.deviceEventList.contains(eventType)) {
            String globalDeviceUri = this.globalDeviceUriTemplate.expand(uriVariables).toASCIIString();
            this.sendStompMessageToOmadaCloud(globalDeviceUri, new StompMessageDTO(eventType, omadacId, data));
        } else {
            this.sendStompMessageToOmadaCloud(globalDes, new StompMessageDTO(eventType, omadacId, data));
        }
    }
}

