/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter;

import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.omada.apigateway.dispatch.cache.IpAccessCache;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter.dto.RestoreEvent;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.concurrent.thread.b;
import com.tplink.smb.omada.common.f.c;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ListCustomersBriefDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadaRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacDTO;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestoreSubscriber
implements EventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestoreSubscriber.class);
    private static final String OMADA_API_GATEWAY_GROUP_RESTORE = "omada-api-gateway-manage-group-restore";
    @Autowired
    private IpAccessCache ipAccessCache;
    @Autowired
    private EventCenter eventCenter;
    @Autowired
    private l omadacInternalApiService;

    @PostConstruct
    public void register() {
        this.eventCenter.registerUnicast("omada.maintenance.restore", OMADA_API_GATEWAY_GROUP_RESTORE, (EventHandler)this, b.e());
    }

    public void handleEvent(Event event) {
        RestoreEvent restoreEvent = (RestoreEvent)x.a((String)((String)event.getMessage()), RestoreEvent.class);
        if (Objects.isNull(restoreEvent)) {
            return;
        }
        String omadacId = restoreEvent.getOmadacId();
        log.debug("receive event restore status,omada:{}", (Object)omadacId);
        OperationResponse omadacRes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().omadacId(omadacId).build());
        if (!omadacRes.success()) {
            log.warn("omadacId={} is not exist.", (Object)omadacId);
            return;
        }
        OmadacDTO omadacDTO = (OmadacDTO)omadacRes.getResult();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(omadacId);
        if (c.b.a(c.a((Integer)omadacDTO.getPattern()))) {
            OperationResponse customers = this.omadacInternalApiService.a(omadacId);
            List list = ((ListCustomersBriefDTO)customers.getResult()).getOmadacs().stream().map(OmadacDTO::getId).collect(Collectors.toList());
            ids.addAll(list);
        }
        for (String id : ids) {
            this.ipAccessCache.remove(id);
        }
    }
}

