/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter;

import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.omada.apigateway.dispatch.cache.OmadacTypeCache;
import com.tplink.smb.omada.apigateway.dispatch.configuration.EventCenterProperties;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter.dto.OrgTypeUpdateEventDTO;
import com.tplink.smb.omada.common.concurrent.thread.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OmadacTypeUpdateEventSubscriber
implements EventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OmadacTypeUpdateEventSubscriber.class);
    private static final String OMADA_API_GATEWAY_GROUP = "api-gateway-org-type-group";
    public static final String ORG_TYPE_EVENT_FILTER = "orgtype";
    @Autowired
    private OmadacTypeCache omadacTypeCache;
    @Autowired
    private EventCenter eventCenter;
    @Autowired
    private EventCenterProperties eventCenterProperties;

    @PostConstruct
    public void register() {
        String businessGroupIdPrefix = this.eventCenterProperties.getBusinessGroupIdPrefix();
        String groupId = businessGroupIdPrefix + "-api-gateway-org-type-group";
        String commonBusinessTopicPrefix = this.eventCenterProperties.getCommonBusinessTopicPrefix();
        Object topic = "omadacentral.settings.organization.event";
        if (!T.c((String)commonBusinessTopicPrefix)) {
            topic = commonBusinessTopicPrefix + "omadacentral.settings.organization.event";
        }
        log.info("Register topic {} with groupId {} for {}.", new Object[]{topic, groupId, this.getClass().getName()});
        this.eventCenter.registerUnicast((String)topic, groupId, (EventHandler)this, b.e());
    }

    public void handleEvent(Event event) {
        if (Objects.equals(event.getFilterKey(), ORG_TYPE_EVENT_FILTER)) {
            log.debug("clear omada type cache by org type event dto {} ", (Object)event);
            OrgTypeUpdateEventDTO result = (OrgTypeUpdateEventDTO)x.a((String)((String)event.getMessage()), OrgTypeUpdateEventDTO.class);
            if (Objects.isNull(result) || Objects.isNull(result.getCentralId())) {
                log.error("clear omada type cache by org type event dto error {} ", (Object)event);
                return;
            }
            this.omadacTypeCache.remove(result.getCentralId());
        }
    }
}

